/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ArchiveFilter
extends ViewerFilter {
    private Set fArchives;
    private List fExisting;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fArchives.contains(element) && !this.fExisting.contains(element);
    }

    public ArchiveFilter(List objects) {
        this.fExisting = objects;
        this.init();
    }

    private void init() {
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable(){

            public void run() {
                ArchiveFilter.this.fArchives = new HashSet();
                ArchiveFilter.this.traverse((IContainer)ResourcesPlugin.getWorkspace().getRoot(), ArchiveFilter.this.fArchives);
            }
        });
    }

    private boolean traverse(IContainer container, Set set) {
        boolean added = false;
        try {
            IResource[] resources = container.members();
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String ext = file.getFileExtension();
                    if (ext == null || !ext.equalsIgnoreCase("jar") && !ext.equalsIgnoreCase("zip")) continue;
                    set.add(file);
                    added = true;
                    continue;
                }
                if (!(resource instanceof IContainer) || !this.traverse((IContainer)resource, set)) continue;
                set.add(resource);
                added = true;
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        return added;
    }
}

