/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLWhitespaceDetector;

public class XMLTagScanner
extends RuleBasedScanner {
    private Token fStringToken;

    public XMLTagScanner(IColorManager manager) {
        this.fStringToken = new Token((Object)new TextAttribute(manager.getColor("editor.color.string")));
        IRule[] rules = new IRule[]{new SingleLineRule("\"", "\"", (IToken)this.fStringToken, '\\'), new SingleLineRule("'", "'", (IToken)this.fStringToken, '\\'), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
        this.setRules(rules);
    }

    protected void adaptToColorChange(ColorManager colorManager, PropertyChangeEvent event, Token token) {
        colorManager.updateProperty(event.getProperty());
        TextAttribute attr = (TextAttribute)token.getData();
        token.setData((Object)new TextAttribute(colorManager.getColor(event.getProperty()), attr.getBackground(), attr.getStyle()));
    }

    public void adaptToPreferenceChange(ColorManager colorManager, PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("editor.color.tag") || property.startsWith("editor.color.string")) {
            this.adaptToColorChange(colorManager, event, this.getTokenAffected(event));
        }
    }

    private Token getTokenAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("editor.color.string")) {
            return this.fStringToken;
        }
        return (Token)this.fDefaultReturnToken;
    }
}

