/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.internal.core.Policy;

public class PollingOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG = Policy.DEBUG_STREAMS;
    private int numAttempts;
    private IProgressMonitor monitor;
    private boolean cancellable;

    public PollingOutputStream(OutputStream out, int numAttempts, IProgressMonitor monitor) {
        super(out);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    public void write(int b) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.write(b);
                return;
            }
            catch (InterruptedIOException e) {
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingOutputStream.writeTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("write retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public void write(byte[] buffer, int off, int len) throws IOException {
        int count = 0;
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.write(buffer, off, len);
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount != 0) {
                    if ((len -= amount) <= 0) {
                        return;
                    }
                    off += amount;
                    count += amount;
                    attempts = 0;
                }
                if (++attempts == this.numAttempts) {
                    e = new InterruptedIOException(Policy.bind("PollingOutputStream.writeTimeout"));
                    e.bytesTransferred = count;
                    throw e;
                }
                if (!DEBUG) continue;
                System.out.println("write retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public void flush() throws IOException {
        int count = 0;
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                this.out.flush();
                return;
            }
            catch (InterruptedIOException e) {
                int amount = e.bytesTransferred;
                if (amount != 0) {
                    count += amount;
                    attempts = 0;
                }
                if (++attempts == this.numAttempts) {
                    e = new InterruptedIOException(Policy.bind("PollingOutputStream.writeTimeout"));
                    e.bytesTransferred = count;
                    throw e;
                }
                if (!DEBUG) continue;
                System.out.println("write retry=" + attempts);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        boolean stop2;
        int attempts = this.numAttempts - 1;
        try {
            this.out.flush();
            attempts = 0;
            Object var3_2 = null;
            stop2 = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            boolean stop2 = false;
            while (!stop2) {
                try {
                    this.out.close();
                    stop2 = true;
                }
                catch (InterruptedIOException e) {
                    if (this.checkCancellation()) {
                        throw new OperationCanceledException();
                    }
                    if (++attempts == this.numAttempts) {
                        throw new InterruptedIOException(Policy.bind("PollingOutputStream.closeTimeout"));
                    }
                    if (!DEBUG) continue;
                    System.out.println("close retry=" + attempts);
                }
            }
            throw throwable;
        }
        while (!stop2) {
            try {
                this.out.close();
                stop2 = true;
            }
            catch (InterruptedIOException e) {
                if (this.checkCancellation()) {
                    throw new OperationCanceledException();
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingOutputStream.closeTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("close retry=" + attempts);
            }
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

