/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CombinedWordRule
implements IRule {
    private static final int UNDEFINED = -1;
    private IWordDetector fDetector;
    private IToken fDefaultToken;
    private int fColumn = -1;
    private CharacterBuffer fBuffer = new CharacterBuffer(16);
    private List fMatchers = new ArrayList();

    public CombinedWordRule(IWordDetector detector) {
        this(detector, null, Token.UNDEFINED);
    }

    public CombinedWordRule(IWordDetector detector, IToken defaultToken) {
        this(detector, null, defaultToken);
    }

    public CombinedWordRule(IWordDetector detector, WordMatcher matcher) {
        this(detector, matcher, Token.UNDEFINED);
    }

    public CombinedWordRule(IWordDetector detector, WordMatcher matcher, IToken defaultToken) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        if (matcher != null) {
            this.addWordMatcher(matcher);
        }
    }

    public void addWordMatcher(WordMatcher matcher) {
        this.fMatchers.add(matcher);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.clear();
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            int n = this.fMatchers.size();
            for (int i = 0; i < n; ++i) {
                IToken token = ((WordMatcher)this.fMatchers.get(i)).evaluate(scanner, this.fBuffer);
                if (token.isUndefined()) continue;
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private void unreadBuffer(ICharacterScanner scanner) {
        for (int i = this.fBuffer.length() - 1; i >= 0; --i) {
            scanner.unread();
        }
    }

    public static class CharacterBuffer {
        private char[] fContent;
        private int fLength = 0;
        private boolean fIsHashCached = false;
        private int fHashCode;

        public CharacterBuffer(int capacity) {
            this.fContent = new char[capacity];
        }

        public CharacterBuffer(String content) {
            this.fContent = content.toCharArray();
            this.fLength = content.length();
        }

        public void clear() {
            this.fIsHashCached = false;
            this.fLength = 0;
        }

        public void append(char c) {
            this.fIsHashCached = false;
            if (this.fLength == this.fContent.length) {
                char[] old = this.fContent;
                this.fContent = new char[old.length << 1];
                System.arraycopy(old, 0, this.fContent, 0, old.length);
            }
            this.fContent[this.fLength++] = c;
        }

        public int length() {
            return this.fLength;
        }

        public String toString() {
            return new String(this.fContent, 0, this.fLength);
        }

        public char charAt(int i) {
            return this.fContent[i];
        }

        public int hashCode() {
            if (this.fIsHashCached) {
                return this.fHashCode;
            }
            int hash = 0;
            int n = this.fLength;
            for (int i = 0; i < n; ++i) {
                hash = 29 * hash + this.fContent[i];
            }
            this.fHashCode = hash;
            this.fIsHashCached = true;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CharacterBuffer)) {
                return false;
            }
            CharacterBuffer buffer = (CharacterBuffer)obj;
            int length = buffer.length();
            if (length != this.fLength) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (buffer.charAt(i) == this.fContent[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(String string) {
            int length = string.length();
            if (length != this.fLength) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (string.charAt(i) == this.fContent[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class WordMatcher {
        private Map fWords = new HashMap();

        public void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            this.fWords.put(new CharacterBuffer(word), token);
        }

        public IToken evaluate(ICharacterScanner scanner, CharacterBuffer word) {
            IToken token = (IToken)this.fWords.get(word);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public void clearWords() {
            this.fWords.clear();
        }
    }
}

