/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.SyntaxTraverser;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public final class BlockUtils {
    public static <T extends PsiStatement> T expandSingleStatementToBlockStatement(@NotNull T statement) {
        if (statement == null) {
            BlockUtils.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiBlockStatement) {
            return statement;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory(statement.getProject()).createStatementFromText("{\n}", statement);
        blockStatement.getCodeBlock().add(statement);
        PsiBlockStatement result2 = (PsiBlockStatement)statement.replace(blockStatement);
        PsiElement sibling = result2.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && PsiUtil.isJavaToken(sibling.getNextSibling(), JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return (T)result2.getCodeBlock().getStatements()[0];
    }

    public static void unwrapTryBlock(PsiTryStatement tryStatement) {
        PsiElement last;
        PsiUtilCore.ensureValid(tryStatement);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement parent2 = tryStatement.getParent();
        boolean singleStatement = false;
        if (parent2 instanceof PsiStatement) {
            PsiStatement[] statements = tryBlock.getStatements();
            if (statements.length == 1 && !(statements[0] instanceof PsiDeclarationStatement)) {
                singleStatement = true;
            } else {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else if (parent2 instanceof PsiCodeBlock) {
            if (BlockUtils.containsConflictingDeclarations(tryBlock, (PsiCodeBlock)parent2)) {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else {
            return;
        }
        tryBlock = tryStatement.getTryBlock();
        assert (tryBlock != null);
        PsiElement first = singleStatement ? BlockUtils.skip(tryBlock.getFirstBodyElement(), true) : tryBlock.getFirstBodyElement();
        PsiElement psiElement = last = singleStatement ? BlockUtils.skip(tryBlock.getLastBodyElement(), false) : tryBlock.getLastBodyElement();
        assert (first != null && last != null);
        tryStatement.getParent().addRangeBefore(first, last, tryStatement);
        tryStatement.delete();
    }

    private static PsiElement skip(PsiElement element, boolean forward) {
        if (!(element instanceof PsiWhiteSpace)) {
            return element;
        }
        return forward ? element.getNextSibling() : element.getPrevSibling();
    }

    public static boolean containsConflictingDeclarations(@NotNull PsiCodeBlock block, @NotNull PsiCodeBlock parentBlock) {
        PsiStatement[] statements;
        if (block == null) {
            BlockUtils.$$$reportNull$$$0(1);
        }
        if (parentBlock == null) {
            BlockUtils.$$$reportNull$$$0(2);
        }
        if ((statements = block.getStatements()).length == 0) {
            return false;
        }
        int endOffset = block.getTextRange().getEndOffset();
        List affectedBlocks = SyntaxTraverser.psiTraverser(parentBlock).filter(PsiCodeBlock.class).filter(cb -> cb.getTextRange().getEndOffset() > endOffset).addAllTo(new SmartList());
        Project project = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement : statements) {
            PsiElement[] variables2;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
            for (PsiElement variable : variables2 = declaration.getDeclaredElements()) {
                if (!(variable instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                String variableName = localVariable.getName();
                for (PsiCodeBlock codeBlock : affectedBlocks) {
                    PsiVariable target = resolveHelper.resolveAccessibleReferencedVariable(variableName, codeBlock);
                    if (target instanceof PsiLocalVariable) {
                        return true;
                    }
                    if (!(target instanceof PsiField)) continue;
                    for (PsiCodeBlock affectedBlock : affectedBlocks) {
                        if (SyntaxTraverser.psiTraverser(affectedBlock).filter(PsiReferenceExpression.class).filter(ref -> ref.resolve() == target).isEmpty()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/BlockUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandSingleStatementToBlockStatement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsConflictingDeclarations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCodeBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

