/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.impl.PatternSetSnapshottingFilter;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileSystemAccess fileSystemAccess;
    private final Stat stat;

    public DefaultFileCollectionSnapshotter(FileSystemAccess fileSystemAccess, Stat stat) {
        this.fileSystemAccess = fileSystemAccess;
        this.stat = stat;
    }

    public FileCollectionSnapshotter.Result snapshot(FileCollection fileCollection) {
        SnapshottingVisitor visitor = new SnapshottingVisitor();
        ((FileCollectionInternal)fileCollection).visitStructure((FileCollectionStructureVisitor)visitor);
        final FileSystemSnapshot snapshot = CompositeFileSystemSnapshot.of(visitor.getRoots());
        final boolean containsArchiveTrees = visitor.containsArchiveTrees();
        return new FileCollectionSnapshotter.Result(){

            public FileSystemSnapshot getSnapshot() {
                return snapshot;
            }

            public boolean containsArchiveTrees() {
                return containsArchiveTrees;
            }
        };
    }

    private class SnapshottingVisitor
    implements FileCollectionStructureVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();
        private boolean containsArchiveTrees;

        private SnapshottingVisitor() {
        }

        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            for (File file : contents) {
                this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(file.getAbsolutePath()));
            }
        }

        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(root.getAbsolutePath(), (SnapshottingFilter)new PatternSetSnapshottingFilter(patterns, DefaultFileCollectionSnapshotter.this.stat)).map(this.roots::add);
        }

        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemAccess.read(file.getAbsolutePath()));
            this.containsArchiveTrees = true;
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }

        public boolean containsArchiveTrees() {
            return this.containsArchiveTrees;
        }
    }
}

