/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MutableModuleMetadataFactory;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.PreferJavaRuntimeVariant;
import org.gradle.internal.component.external.model.ivy.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class IvyMutableModuleMetadataFactory
implements MutableModuleMetadataFactory<MutableIvyModuleResolveMetadata> {
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration("default", true, true, (Collection<String>)ImmutableSet.of());
    private static final List<Configuration> DEFAULT_CONFIGURATION_LIST = ImmutableList.of((Object)DEFAULT_CONFIGURATION);
    private static final ImmutableSet<String> SINGLE_DEFAULT_CONFIGURATION_NAME = ImmutableSet.of((Object)"default");
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final AttributesFactory attributesFactory;
    private final ImmutableAttributesSchema schema;

    @Inject
    public IvyMutableModuleMetadataFactory(ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributesFactory attributesFactory, PreferJavaRuntimeVariant schema) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributesFactory = attributesFactory;
        this.schema = schema.getSchema();
    }

    public MutableIvyModuleResolveMetadata create(ModuleComponentIdentifier from, List<IvyDependencyDescriptor> dependencies) {
        return this.create(from, dependencies, (Collection<Configuration>)DEFAULT_CONFIGURATION_LIST, (Collection<? extends Artifact>)this.createDefaultArtifact(from), (Collection<? extends Exclude>)ImmutableList.of());
    }

    public MutableIvyModuleResolveMetadata create(ModuleComponentIdentifier from, List<IvyDependencyDescriptor> dependencies, Collection<Configuration> configurationDefinitions, Collection<? extends Artifact> artifactDefinitions, Collection<? extends Exclude> excludes) {
        ModuleVersionIdentifier mvi = this.asVersionIdentifier(from);
        return new DefaultMutableIvyModuleResolveMetadata(this.attributesFactory, mvi, from, dependencies, configurationDefinitions, artifactDefinitions, excludes, this.schema);
    }

    @Override
    public MutableIvyModuleResolveMetadata createForGradleModuleMetadata(ModuleComponentIdentifier from) {
        return this.create(from, (List<IvyDependencyDescriptor>)ImmutableList.of(), (Collection<Configuration>)ImmutableList.of(), (Collection<? extends Artifact>)this.createDefaultArtifact(from), (Collection<? extends Exclude>)ImmutableList.of());
    }

    private ImmutableList<? extends Artifact> createDefaultArtifact(ModuleComponentIdentifier from) {
        return ImmutableList.of((Object)new Artifact(new DefaultIvyArtifactName(from.getModule(), "jar", "jar"), (Set<String>)SINGLE_DEFAULT_CONFIGURATION_NAME));
    }

    private ModuleVersionIdentifier asVersionIdentifier(ModuleComponentIdentifier from) {
        return this.moduleIdentifierFactory.moduleWithVersion(from.getGroup(), from.getModule(), from.getVersion());
    }

    @Override
    public MutableIvyModuleResolveMetadata missing(ModuleComponentIdentifier from) {
        MutableIvyModuleResolveMetadata metadata = this.create(from, (List<IvyDependencyDescriptor>)ImmutableList.of());
        metadata.setMissing(true);
        return metadata;
    }
}

