/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.execution.ExecutionProblemHandler;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.steps.ValidateStep;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionProblemHandler
implements ExecutionProblemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionProblemHandler.class);
    private final ValidateStep.ValidationWarningRecorder warningReporter;
    private final VirtualFileSystem virtualFileSystem;

    public DefaultExecutionProblemHandler(ValidateStep.ValidationWarningRecorder warningReporter, VirtualFileSystem virtualFileSystem) {
        this.warningReporter = warningReporter;
        this.virtualFileSystem = virtualFileSystem;
    }

    @Override
    public void handleReportedProblems(UnitOfWork.Identity identity, UnitOfWork work, WorkValidationContext validationContext) {
        InternalProblems problemsService = validationContext.getProblemsService();
        InternalProblemReporter reporter = problemsService.getInternalReporter();
        List<InternalProblem> problems = validationContext.getProblems();
        Map problemsMap = problems.stream().collect(Collectors.groupingBy(p -> p.getDefinition().getSeverity(), Collectors.mapping(Function.identity(), ImmutableList.toImmutableList())));
        List warnings = (List)problemsMap.getOrDefault(Severity.WARNING, ImmutableList.of());
        List errors = (List)problemsMap.getOrDefault(Severity.ERROR, ImmutableList.of());
        if (!warnings.isEmpty()) {
            for (InternalProblem warning : warnings) {
                reporter.report((Problem)warning);
            }
            this.warningReporter.recordValidationWarnings(identity, work, warnings);
        }
        if (!errors.isEmpty()) {
            DefaultExecutionProblemHandler.throwValidationException(work, validationContext, errors);
        }
        if (!warnings.isEmpty()) {
            LOGGER.info("Invalidating VFS because {} failed validation", (Object)work.getDisplayName());
            this.virtualFileSystem.invalidateAll();
        }
    }

    private static void throwValidationException(UnitOfWork work, WorkValidationContext validationContext, Collection<? extends InternalProblem> validationErrors) {
        Set uniqueErrors = (Set)validationErrors.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
        WorkValidationException workValidationException = WorkValidationException.forProblems(uniqueErrors).withSummaryForContext(work.getDisplayName(), validationContext).get();
        InternalProblemReporter reporter = validationContext.getProblemsService().getInternalReporter();
        throw reporter.throwing((Throwable)((Object)workValidationException), validationErrors);
    }
}

