/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

class V8PropertyMap<V>
implements Map<String, V> {
    private Hashtable<String, V> map = new Hashtable();
    private Set<String> nulls = new HashSet<String>();

    V8PropertyMap() {
    }

    @Override
    public int size() {
        return this.map.size() + this.nulls.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && this.nulls.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2) || this.nulls.contains(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null && !this.nulls.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key2) {
        if (this.nulls.contains(key2)) {
            return null;
        }
        return this.map.get(key2);
    }

    @Override
    public V put(String key2, V value) {
        if (value == null) {
            if (this.map.containsKey(key2)) {
                this.map.remove(key2);
            }
            this.nulls.add(key2);
            return null;
        }
        if (this.nulls.contains(key2)) {
            this.nulls.remove(key2);
        }
        return this.map.put(key2, value);
    }

    @Override
    public V remove(Object key2) {
        if (this.nulls.contains(key2)) {
            this.nulls.remove(key2);
            return null;
        }
        return this.map.remove(key2);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.nulls.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result2 = new HashSet<String>(this.map.keySet());
        result2.addAll(this.nulls);
        return result2;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result2 = new ArrayList<V>(this.map.values());
        for (int i = 0; i < this.nulls.size(); ++i) {
            result2.add(null);
        }
        return result2;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> result2 = new HashSet<Map.Entry<String, V>>(this.map.entrySet());
        for (String nullKey : this.nulls) {
            result2.add(new AbstractMap.SimpleEntry<String, Object>(nullKey, null));
        }
        return result2;
    }
}

