/*
 * Decompiled with CFR 0.152.
 */
package mill.eval;

import java.io.Serializable;
import java.util.regex.Matcher;
import mill.define.NamedTask;
import mill.define.Segment;
import mill.define.Segments;
import mill.eval.EvaluatorPaths;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class EvaluatorPaths$
implements Serializable {
    public static final EvaluatorPaths$ MODULE$ = new EvaluatorPaths$();
    private static final Regex ReservedWinNames = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([cC][oO][nN]|[pP][rR][nN]|[aA][uU][xX]|[nN][uU][lL]|[cC][oO][mM][0-9\u00b9\u00b2\u00b3]|[lL][pP][tT][0-9\u00b9\u00b2\u00b3])($|[.].*$)"));
    private static final Regex Colon = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[:]"));
    private static final Regex Dollar = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[$]"));
    private static final Regex Slash = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("/"));
    private static final Seq<Function1<String, String>> steps = new $colon$colon<Nothing$>((Nothing$)(Function1<String, String> & Serializable)s -> MODULE$.Dollar().replaceAllIn((CharSequence)s, Matcher.quoteReplacement("$$")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(Function1<String, String> & Serializable)x$3 -> {
        Option<List<String>> option;
        String string = x$3;
        if (string != null && !(option = MODULE$.ReservedWinNames().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(2) == 0) {
            String keyword = (String)((LinearSeqOps)option.get()).apply(0);
            String rest = (String)((LinearSeqOps)option.get()).apply(1);
            return new StringBuilder(1).append(keyword).append("~").append(rest).toString();
        }
        return string;
    }, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(Function1<String, String> & Serializable)s -> MODULE$.Colon().replaceAllIn((CharSequence)s, Matcher.quoteReplacement("$colon")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(Function1<String, String> & Serializable)s -> MODULE$.Slash().replaceAllIn((CharSequence)s, Matcher.quoteReplacement("$slash")), Nil$.MODULE$))));

    public EvaluatorPaths apply(Path dest, Path meta, Path log) {
        return new EvaluatorPaths(dest, meta, log);
    }

    private Option<Tuple3<Path, Path, Path>> unapply(EvaluatorPaths evaluatorPaths) {
        return Option$.MODULE$.apply(new Tuple3<Path, Path, Path>(evaluatorPaths.dest(), evaluatorPaths.meta(), evaluatorPaths.log()));
    }

    public Seq<String> makeSegmentStrings(Segments segments) {
        return (Seq)segments.value().flatMap((Function1<Segment, IterableOnce> & Serializable)x0$1 -> {
            Segment segment = x0$1;
            if (segment instanceof Segment.Label) {
                Segment.Label label = (Segment.Label)segment;
                String s = label.value();
                return new $colon$colon<Nothing$>((Nothing$)((Object)s), Nil$.MODULE$);
            }
            if (segment instanceof Segment.Cross) {
                Segment.Cross cross = (Segment.Cross)segment;
                Seq<String> values2 = cross.value();
                return (IterableOnce)values2.map((Function1<String, String> & Serializable)x$1 -> x$1.toString());
            }
            throw new MatchError(segment);
        });
    }

    public EvaluatorPaths resolveDestPaths(Path workspacePath, Segments segments, Option<Segments> foreignSegments) {
        Segments refinedSegments = (Segments)foreignSegments.map((Function1<Segments, Segments> & Serializable)x$2 -> x$2.$plus$plus(segments)).getOrElse((Function0<Segments> & Serializable)() -> segments);
        Seq<String> segmentStrings = this.makeSegmentStrings(refinedSegments);
        Path targetPath = workspacePath.$div(PathChunk$.MODULE$.SeqPathChunk((Seq)segmentStrings.map((Function1<String, PathChunk> & Serializable)segment -> MODULE$.sanitizePathSegment((String)segment)), Predef$.MODULE$.$conforms()));
        return this.apply(targetPath.$div(PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())).$div(new PathChunk.StringPathChunk(new StringBuilder(5).append(targetPath.last()).append(".dest").toString())), targetPath.$div(PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())).$div(new PathChunk.StringPathChunk(new StringBuilder(5).append(targetPath.last()).append(".json").toString())), targetPath.$div(PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())).$div(new PathChunk.StringPathChunk(new StringBuilder(4).append(targetPath.last()).append(".log").toString())));
    }

    public EvaluatorPaths resolveDestPaths(Path workspacePath, NamedTask<?> task) {
        return this.resolveDestPaths(workspacePath, task.ctx().segments(), task.ctx().foreign());
    }

    public Option<Segments> resolveDestPaths$default$3() {
        return None$.MODULE$;
    }

    private Regex ReservedWinNames() {
        return ReservedWinNames;
    }

    private Regex Colon() {
        return Colon;
    }

    private Regex Dollar() {
        return Dollar;
    }

    private Regex Slash() {
        return Slash;
    }

    private Seq<Function1<String, String>> steps() {
        return steps;
    }

    public PathChunk sanitizePathSegment(String segment2) {
        return new PathChunk.StringPathChunk(this.steps().foldLeft(segment2, (Function2<String, Function1, String> & Serializable)(segment, f) -> (String)f.apply(segment)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EvaluatorPaths$.class);
    }

    private EvaluatorPaths$() {
    }
}

