/*
 * Decompiled with CFR 0.152.
 */
package mill.resolve;

import java.io.Serializable;
import mill.define.Segment;
import mill.define.Segments;
import mill.moduledefs.Scaladoc;
import mill.resolve.LevenshteinDistance$;
import mill.resolve.ResolveCore;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Scaladoc(value="/**\n * Reports errors in the case where nothing was resolved\n */")
public final class ResolveNotFoundHandler$ {
    public static final ResolveNotFoundHandler$ MODULE$ = new ResolveNotFoundHandler$();

    public String apply(Segments selector, Segments segments, Set<ResolveCore.Resolved> found, Segment next, Set<Segment> possibleNexts, Set<String> allPossibleNames) {
        if (found.head() instanceof ResolveCore.Resolved.Module) {
            Segment segment = next;
            if (segment instanceof Segment.Label) {
                Segment.Label label = (Segment.Label)segment;
                String s = label.value();
                Set possibleStrings = (Set)possibleNexts.collect(new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Segment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof Segment.Label) {
                            Segment.Label label = (Segment.Label)A1;
                            String s = label.value();
                            return (B1)s;
                        }
                        return function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Segment x1) {
                        Segment segment = x1;
                        return segment instanceof Segment.Label;
                    }
                });
                return this.errorMsgLabel(s, possibleStrings, segments, selector, allPossibleNames);
            }
            if (segment instanceof Segment.Cross) {
                Segment.Cross cross = (Segment.Cross)segment;
                Seq<String> keys = cross.value();
                Set possibleCrossKeys = (Set)possibleNexts.collect(new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Segment, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof Segment.Cross) {
                            Segment.Cross cross = (Segment.Cross)A1;
                            Seq<String> keys = cross.value();
                            return (B1)keys;
                        }
                        return function1.apply(x2);
                    }

                    public final boolean isDefinedAt(Segment x2) {
                        Segment segment = x2;
                        return segment instanceof Segment.Cross;
                    }
                });
                return this.errorMsgCross(keys, possibleCrossKeys, segments, selector, allPossibleNames);
            }
            throw new MatchError(segment);
        }
        return new StringBuilder(38).append(this.unableToResolve(segments.$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)next), Nil$.MODULE$)).render())).append(" ").append(segments.render()).append(" resolves to a Task with no children.").toString();
    }

    public String unableToResolve(String segments) {
        return new StringBuilder(16).append("Cannot resolve ").append(segments).append(".").toString();
    }

    public String hintList(Segments revSelectorsSoFar, Segment lastSegment, Set<String> allPossibleNames) {
        String search = revSelectorsSoFar.render();
        Option lastSearchOpt = Option$.MODULE$.apply(lastSegment).withFilter((Function1<Segment, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ResolveNotFoundHandler$.$anonfun$hintList$1(check$ifrefutable$1))).withFilter((Function1<Segment, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(ResolveNotFoundHandler$.$anonfun$hintList$2(x$1))).flatMap((Function1<Segment, Option> & Serializable)x$2 -> {
            Segment segment = x$2;
            if (segment instanceof Segment.Label) {
                Segment.Label label = (Segment.Label)segment;
                String s = label.value();
                return MODULE$.findMostSimilar(s, allPossibleNames).map((Function1<String, String> & Serializable)possibility -> new StringBuilder(3).append("__.").append((String)possibility).toString());
            }
            throw new MatchError(segment);
        });
        String searchStr = ((IterableOnceOps)((IterableOps)new $colon$colon<Nothing$>((Nothing$)((Object)search), Nil$.MODULE$).$plus$plus((IterableOnce)lastSearchOpt)).map((Function1<String, String> & Serializable)s -> new StringBuilder(15).append("`mill resolve ").append((String)s).append("`").toString())).mkString(" or ");
        return new StringBuilder(30).append(" Try ").append(searchStr).append(" to see what's available.").toString();
    }

    public String hintListLabel(Segments revSelectorsSoFar, Segment lastSegment, Set<String> allPossibleNames) {
        return this.hintList(revSelectorsSoFar.$plus$plus(new Segment.Label("_")), lastSegment, allPossibleNames);
    }

    public Option<String> findMostSimilar(String given, Set<String> options) {
        return ((IterableOnceOps)((IterableOps)options.map((Function1<String, Tuple2> & Serializable)option -> new Tuple2<String, Integer>((String)option, BoxesRunTime.boxToInteger(LevenshteinDistance$.MODULE$.editDistance(given, (String)option))))).filter((Function1<Tuple2, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ResolveNotFoundHandler$.$anonfun$findMostSimilar$2(x$3)))).minByOption((Function1<Tuple2, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4._2$mcI$sp()), Ordering$Int$.MODULE$).map((Function1<Tuple2, String> & Serializable)x$5 -> (String)x$5._1());
    }

    public String errorMsgLabel(String given, Set<String> possibleMembers, Segments prefixSegments, Segments fullSegments, Set<String> allPossibleNames) {
        String string;
        Option<String> option = this.findMostSimilar(given, possibleMembers);
        if (None$.MODULE$.equals(option)) {
            string = this.hintListLabel(prefixSegments, (Segment)fullSegments.value().last(), allPossibleNames);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String similar = (String)some.value();
            string = new StringBuilder(15).append(" Did you mean ").append(prefixSegments.$plus$plus(new Segment.Label(similar)).render()).append("?").toString();
        } else {
            throw new MatchError(option);
        }
        String suggestion = string;
        String msg = new StringBuilder(0).append(this.unableToResolve(fullSegments.render())).append(suggestion).toString();
        return msg;
    }

    public String errorMsgCross(Seq<String> givenKeys, Set<Seq<String>> possibleCrossKeys, Segments prefixSegments, Segments fullSegments, Set<String> allPossibleNames) {
        String string;
        Option<String> option = this.findMostSimilar(givenKeys.mkString(","), (Set)possibleCrossKeys.map((Function1<Seq, String> & Serializable)x$6 -> x$6.mkString(",")));
        if (None$.MODULE$.equals(option)) {
            string = this.hintListLabel(prefixSegments, (Segment)fullSegments.value().last(), allPossibleNames);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String similar = (String)some.value();
            string = new StringBuilder(15).append(" Did you mean ").append(prefixSegments.$plus$plus(new Segment.Cross(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(similar), ',')))).render()).append("?").toString();
        } else {
            throw new MatchError(option);
        }
        String suggestion = string;
        return new StringBuilder(0).append(this.unableToResolve(fullSegments.render())).append(suggestion).toString();
    }

    public static final /* synthetic */ boolean $anonfun$hintList$1(Segment check$ifrefutable$1) {
        Segment segment = check$ifrefutable$1;
        return segment instanceof Segment.Label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$hintList$2(Segment x$1) {
        String s;
        Segment segment = x$1;
        if (!(segment instanceof Segment.Label)) throw new MatchError(segment);
        Segment.Label label = (Segment.Label)segment;
        String string = s = label.value();
        String string2 = "_";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = s;
        String string4 = "__";
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findMostSimilar$2(Tuple2 x$3) {
        return x$3._2$mcI$sp() < 3;
    }

    private ResolveNotFoundHandler$() {
    }
}

