/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib.publish;

import java.io.Serializable;
import mill.api.AggWrapper;
import mill.moduledefs.Scaladoc;
import mill.scalalib.publish.Artifact;
import mill.scalalib.publish.Dependency;
import mill.scalalib.publish.Ivy;
import mill.scalalib.publish.PublishInfo;
import mill.scalalib.publish.PublishInfo$;
import mill.scalalib.publish.Scope;
import mill.scalalib.publish.Scope$Compile$;
import mill.scalalib.publish.Scope$Provided$;
import mill.scalalib.publish.Scope$Runtime$;
import mill.scalalib.publish.Scope$Test$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Nothing$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class Ivy$ {
    public static final Ivy$ MODULE$ = new Ivy$();
    private static final String head = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public String head() {
        return head;
    }

    @Scaladoc(value="/**\n   * Generates the content of an ivy.xml file\n   *\n   * @param artifact Coordinates of the module\n   * @param dependencies Dependencies of the module\n   * @param extras Extra artifacts published alongside the module\n   * @param overrides Version overrides\n   * @param hasJar Whether the module has a JAR\n   * @return ivy.xml content\n   */")
    public String apply(Artifact artifact, AggWrapper.Agg<Dependency> dependencies, Seq<PublishInfo> extras, Seq<Ivy.Override> overrides, boolean hasJar) {
        Object x$1 = null;
        String x$2 = "pom";
        String x$3 = "pom";
        String x$4 = "pom";
        Option<String> x$5 = PublishInfo$.MODULE$.apply$default$2();
        PublishInfo pomInfo = new PublishInfo(null, x$5, "pom", "pom", "pom");
        $colon$colon<Nothing$> mainPublishInfo = hasJar ? new $colon$colon<Nothing$>((Nothing$)((Object)pomInfo), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)PublishInfo$.MODULE$.jar(null)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)PublishInfo$.MODULE$.sourcesJar(null)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)PublishInfo$.MODULE$.docJar(null)), Nil$.MODULE$)))) : new $colon$colon<Nothing$>((Nothing$)((Object)pomInfo), Nil$.MODULE$);
        NamespaceBinding $tmpscope = TopScope$.MODULE$;
        NamespaceBinding $scope = $tmpscope = new NamespaceBinding("e", "http://ant.apache.org/ivy/extra", $tmpscope);
        MetaData $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("version", new Text("2.0"), $md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n        "));
        MetaData $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("status", new Text("release"), $md2);
        $md2 = new UnprefixedAttribute("revision", artifact.version(), $md2);
        $md2 = new UnprefixedAttribute("module", artifact.id(), $md2);
        $md2 = new UnprefixedAttribute("organisation", artifact.group(), $md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(new Text("\n          "));
        $buf2.$amp$plus(new Elem(null, "description", Null$.MODULE$, $scope, true, Nil$.MODULE$));
        $buf2.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(new Elem(null, "info", $md2, $scope, false, NodeSeq$.MODULE$.seqToNodeSeq($buf2)));
        $buf.$amp$plus(new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("description", Nil$.MODULE$, $md3);
        $md3 = new UnprefixedAttribute("visibility", new Text("public"), $md3);
        $md3 = new UnprefixedAttribute("name", new Text("pom"), $md3);
        $buf3.$amp$plus(new Elem(null, "conf", $md3, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("description", Nil$.MODULE$, $md4);
        $md4 = new UnprefixedAttribute("visibility", new Text("public"), $md4);
        $md4 = new UnprefixedAttribute("name", new Text("test"), $md4);
        $md4 = new UnprefixedAttribute("extends", new Text("runtime"), $md4);
        $buf3.$amp$plus(new Elem(null, "conf", $md4, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("description", Nil$.MODULE$, $md5);
        $md5 = new UnprefixedAttribute("visibility", new Text("public"), $md5);
        $md5 = new UnprefixedAttribute("name", new Text("provided"), $md5);
        $buf3.$amp$plus(new Elem(null, "conf", $md5, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("description", Nil$.MODULE$, $md6);
        $md6 = new UnprefixedAttribute("visibility", new Text("public"), $md6);
        $md6 = new UnprefixedAttribute("name", new Text("optional"), $md6);
        $buf3.$amp$plus(new Elem(null, "conf", $md6, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("description", Nil$.MODULE$, $md7);
        $md7 = new UnprefixedAttribute("visibility", new Text("public"), $md7);
        $md7 = new UnprefixedAttribute("name", new Text("compile"), $md7);
        $buf3.$amp$plus(new Elem(null, "conf", $md7, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n          "));
        MetaData $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("description", Nil$.MODULE$, $md8);
        $md8 = new UnprefixedAttribute("visibility", new Text("public"), $md8);
        $md8 = new UnprefixedAttribute("name", new Text("runtime"), $md8);
        $md8 = new UnprefixedAttribute("extends", new Text("compile"), $md8);
        $buf3.$amp$plus(new Elem(null, "conf", $md8, $scope, true, Nil$.MODULE$));
        $buf3.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(new Elem(null, "configurations", Null$.MODULE$, $scope, false, NodeSeq$.MODULE$.seqToNodeSeq($buf3)));
        $buf.$amp$plus(new Text("\n\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus(new Text("\n          "));
        $buf4.$amp$plus(((IterableOps)mainPublishInfo.$plus$plus(extras)).map((Function1<PublishInfo, Elem> & Serializable)e -> Ivy$.renderArtifact$1(e, artifact)));
        $buf4.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(new Elem(null, "publications", Null$.MODULE$, $scope, false, NodeSeq$.MODULE$.seqToNodeSeq($buf4)));
        $buf.$amp$plus(new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus(new Text("\n          "));
        $buf5.$amp$plus(((IterableOnceOps)dependencies.map((Function1<Dependency, Elem> & Serializable)dep -> MODULE$.renderDependency((Dependency)dep))).toSeq());
        $buf5.$amp$plus(new Text("\n          "));
        $buf5.$amp$plus(overrides.map((Function1<Ivy.Override, Elem> & Serializable)override0 -> MODULE$.renderOverride((Ivy.Override)override0)));
        $buf5.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(new Elem(null, "dependencies", Null$.MODULE$, $scope, false, NodeSeq$.MODULE$.seqToNodeSeq($buf5)));
        $buf.$amp$plus(new Text("\n      "));
        Elem xml = new Elem(null, "ivy-module", $md, $scope, false, NodeSeq$.MODULE$.seqToNodeSeq($buf));
        PrettyPrinter pp = new PrettyPrinter(120, 4);
        return new StringBuilder(0).append(this.head()).append(pp.format((Node)xml, pp.format$default$2()).replaceAll("&gt;", ">")).toString();
    }

    public String apply(Artifact artifact, AggWrapper.Agg<Dependency> dependencies, Seq<PublishInfo> extras, Seq<Ivy.Override> overrides) {
        return this.apply(artifact, dependencies, extras, overrides, true);
    }

    public String apply(Artifact artifact, AggWrapper.Agg<Dependency> dependencies, Seq<PublishInfo> extras) {
        return this.apply(artifact, dependencies, extras, Nil$.MODULE$);
    }

    public Seq<PublishInfo> apply$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<Ivy.Override> apply$default$4() {
        return Nil$.MODULE$;
    }

    public boolean apply$default$5() {
        return true;
    }

    private Elem renderDependency(Dependency dep) {
        if (dep.exclusions().isEmpty()) {
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("conf", this.depIvyConf(dep), $md);
            $md = new UnprefixedAttribute("rev", dep.artifact().version(), $md);
            $md = new UnprefixedAttribute("name", dep.artifact().id(), $md);
            $md = new UnprefixedAttribute("org", dep.artifact().group(), $md);
            return new Elem(null, "dependency", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
        }
        MetaData $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("conf", this.depIvyConf(dep), $md);
        $md = new UnprefixedAttribute("rev", dep.artifact().version(), $md);
        $md = new UnprefixedAttribute("name", dep.artifact().id(), $md);
        $md = new UnprefixedAttribute("org", dep.artifact().group(), $md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(dep.exclusions().map((Function1<Tuple2, Elem> & Serializable)ex -> {
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("matcher", new Text("exact"), $md);
            $md = new UnprefixedAttribute("name", (String)ex._2(), $md);
            $md = new UnprefixedAttribute("org", (String)ex._1(), $md);
            return new Elem(null, "exclude", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
        }));
        $buf.$amp$plus(new Text("\n      "));
        return new Elem(null, "dependency", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq($buf));
    }

    private Elem renderOverride(Ivy.Override override0) {
        MetaData $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rev", override0.version(), $md);
        $md = new UnprefixedAttribute("module", override0.name(), $md);
        $md = new UnprefixedAttribute("org", override0.organization(), $md);
        return new Elem(null, "override", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
    }

    private String depIvyConf(Dependency d) {
        if (d.optional()) {
            return new StringBuilder(10).append("optional->").append(Ivy$.target$1("runtime", d)).toString();
        }
        Scope scope = d.scope();
        if (Scope$Compile$.MODULE$.equals(scope)) {
            return new StringBuilder(19).append("compile->").append(Ivy$.target$1("compile", d)).append(";runtime->").append(Ivy$.target$1("runtime", d)).toString();
        }
        if (Scope$Provided$.MODULE$.equals(scope)) {
            return new StringBuilder(10).append("provided->").append(Ivy$.target$1("compile", d)).toString();
        }
        if (Scope$Test$.MODULE$.equals(scope)) {
            return new StringBuilder(6).append("test->").append(Ivy$.target$1("runtime", d)).toString();
        }
        if (Scope$Runtime$.MODULE$.equals(scope)) {
            return new StringBuilder(9).append("runtime->").append(Ivy$.target$1("runtime", d)).toString();
        }
        throw new MatchError(scope);
    }

    private static final Elem renderArtifact$1(PublishInfo e, Artifact artifact$1) {
        Option<String> option = e.classifier();
        if (None$.MODULE$.equals(option)) {
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("conf", e.ivyConfig(), $md);
            $md = new UnprefixedAttribute("ext", e.ext(), $md);
            $md = new UnprefixedAttribute("type", e.ivyType(), $md);
            $md = new UnprefixedAttribute("name", artifact$1.id(), $md);
            return new Elem(null, "artifact", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String c = (String)some.value();
            MetaData $md = Null$.MODULE$;
            $md = new PrefixedAttribute("e", "classifier", c, $md);
            $md = new UnprefixedAttribute("conf", e.ivyConfig(), $md);
            $md = new UnprefixedAttribute("ext", e.ext(), $md);
            $md = new UnprefixedAttribute("type", e.ivyType(), $md);
            $md = new UnprefixedAttribute("name", artifact$1.id(), $md);
            return new Elem(null, "artifact", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
        }
        throw new MatchError(option);
    }

    private static final String target$1(String value, Dependency d$1) {
        return (String)d$1.configuration().getOrElse((Function0<String> & Serializable)() -> value);
    }

    private Ivy$() {
    }
}

