/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.GTPlanarizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MinimumBendOrthogonalizer;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.RectangularCompactor;

public class OrthogonalLayout<N, E>
extends GraphLayout<N, E> {
    private MGraph<N, E> mGraph = null;
    private GraphScene<N, E> scene = null;
    private final boolean animate;
    public static final int gutter = 55;
    public final int halfGutter = 27;

    public OrthogonalLayout(GraphScene<N, E> graphScene, boolean bl) {
        this.scene = graphScene;
        this.animate = bl;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> universalGraph) {
        this.mGraph = MGraph.createGraph(universalGraph, this.scene);
        GTPlanarizer<N, E> gTPlanarizer = new GTPlanarizer<N, E>();
        Collection collection = gTPlanarizer.planarize(this.mGraph);
        MinimumBendOrthogonalizer minimumBendOrthogonalizer = new MinimumBendOrthogonalizer();
        Collection collection2 = minimumBendOrthogonalizer.orthogonalize(collection);
        RectangularCompactor rectangularCompactor = new RectangularCompactor();
        rectangularCompactor.compact(collection2);
        this.layoutNodes();
    }

    private void layoutNodes() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object2;
        Collection<E> collection = this.scene.getEdges();
        for (Object object2 : collection) {
            ConnectionWidget connectionWidget = (ConnectionWidget)this.scene.findWidget(object2);
            connectionWidget.setRouter(RouterFactory.createOrthogonalSearchRouter(new LayerWidget[0]));
        }
        ArrayList arrayList = new ArrayList();
        object2 = this.mGraph.getVertices();
        int n = -1;
        int n2 = -1;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            MGraph.Vertex vertex = (MGraph.Vertex)object3.next();
            Object n3 = vertex.getNodeDesignElement();
            if (n3 == null) continue;
            Widget widget = this.scene.findWidget(n3);
            int n4 = (int)vertex.getX();
            int n5 = (int)vertex.getY();
            cloneable2 = new Point(n4, n5);
            if (cloneable2.x == 0 && cloneable2.y == 0) {
                arrayList.add(widget);
                continue;
            }
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(widget, (Point)cloneable2);
            }
            cloneable = widget.getBounds();
            widget.resolveBounds((Point)cloneable2, (Rectangle)cloneable);
            if (n4 + cloneable.width > n) {
                n = n4 + cloneable.width;
            }
            if (n5 + cloneable.height <= n2) continue;
            n2 = n5 + cloneable.height;
        }
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        object3 = this.scene.getBounds();
        if (((Rectangle)object3).width > n) {
            n = ((Rectangle)object3).width;
        }
        int n6 = 0;
        int n7 = n2 + 27;
        int n8 = -1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Widget widget = (Widget)iterator.next();
            cloneable2 = widget.getBounds();
            if (n6 + ((Rectangle)cloneable2).width > n) {
                n6 = 0;
                n7 = n7 + n8 + 27;
                n8 = -1;
            }
            cloneable = new Point(n6, n7);
            if (this.animate) {
                this.scene.getSceneAnimator().animatePreferredLocation(widget, (Point)cloneable);
            }
            widget.resolveBounds((Point)cloneable, (Rectangle)cloneable2);
            n6 = n6 + ((Rectangle)cloneable2).width + 27;
            if (((Rectangle)cloneable2).height <= n8) continue;
            n8 = ((Rectangle)cloneable2).height;
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

