/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class VerifyFile {
    public static void main(String[] args) {
        File file = new File(args[0]);
        try {
            JarFile jar = new JarFile(file);
            URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (VerifyFile.getClassName(entry) == null) continue;
                try {
                    System.out.println("loading class " + VerifyFile.getClassName(entry));
                    loader.loadClass(VerifyFile.getClassName(entry));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (IllegalAccessError illegalAccessError) {}
            }
            jar.close();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String getClassName(JarEntry entry) {
        String name = entry.getName();
        if (name.endsWith(".class")) {
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            if (className.matches("([a-zA-Z][a-zA-Z0-9_]+\\.)+[a-zA-Z][a-zA-Z0-9_]+")) {
                return className;
            }
            return null;
        }
        return null;
    }
}

