/*
 *  linux/arch/arm/mach-dmw/board-tf-evb.c
 *
 *  Copyright (C) 2012 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/interrupt.h>
#include <linux/cpufreq.h>
#include <linux/delay.h>
#include <linux/dma-mapping.h>
#include <linux/dwf_platform.h>
#include <linux/i2c-pnx.h>
#include <linux/i2c.h>
#include <linux/i2c/ssd2531-ts.h>
#include <linux/init.h>
#include <linux/lis3lv02d.h>
#include <linux/mfd/core.h>
#include <linux/mfd/dp52/core.h>
#include <linux/mmc/dw_mmc.h>
#include <linux/mmc/host.h>
#include <linux/platform_device.h>
#include <linux/regulator/machine.h>
#include <linux/spi/spi.h>
#include <linux/spi/spi_dmw96.h>
#include <linux/usb/dwc_otg.h>
#include <linux/dmw96-rfkill.h>
#include <linux/stmmac.h>
#include <mach/cpufreq.h>
#include <mach/gpio.h>
#include <mach/headsetdet.h>
#include <mach/irqs.h>
#include <mach/keypad.h>
#include <mach/reset.h>
#include <mach/camera.h>
#include <mach/hdmi.h>
#include <media/dmw96ciu.h>
#include <media/dmw96ciu_w.h>
#include <media/v4l2-int-device.h>
#include <media/ov2643.h>
#include <sound/dmw-tdm.h>
#include <sound/dmw-boards.h>
#include <video/amoled.h>
#include <video/dmw96osdm_common.h>
#include <video/dw74fb.h>
#include <linux/usb/android_composite.h>
#include <linux/platform_data/goodix-ts.h>
#include <mach/css.h>
#include <linux/regulator/machine.h>
#include <linux/regulator/fixed.h>
#include <mach/platform.h>
#include <mach/hardware.h>

#include "devices.h"
#include "gpio-setup.h"
#include "pm.h"

/*
 * CPU overdrive is needed permanently to guarantee system stability. Set to
 * invalid GPIO number until the feature can be used safely.
 */
#define OVERDRIVE_GPIO (-1) /* (GPIO_PORTG(9)) */

static __initdata struct gpio_setup_t gpio_setup_default[] = {
	GPIO_SETUP(A,  0, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD0 */
	GPIO_SETUP(A,  1, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD1 */
	GPIO_SETUP(A,  2, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD2 */
	GPIO_SETUP(A,  3, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD3 */
	GPIO_SETUP(A,  4, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD4 */
	GPIO_SETUP(A,  5, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD5 */
	GPIO_SETUP(A,  6, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD6 */
	GPIO_SETUP(A,  7, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD7 */
	GPIO_SETUP(A,  8, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD8 */
	GPIO_SETUP(A,  9, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD9 */
	GPIO_SETUP(A, 10, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD10*/
	GPIO_SETUP(A, 11, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD11 */
	GPIO_SETUP(A, 12, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD12 */
	GPIO_SETUP(A, 13, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD13 */
	GPIO_SETUP(A, 14, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD14 */
	GPIO_SETUP(A, 15, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLD15 */
	GPIO_SETUP(A, 16, GPIO_DISABLE, GPIO_PULL_DISABLE), /* NFL - NFLWR */
	GPIO_SETUP(A, 17, GPIO_DISABLE, GPIO_PULL_DISABLE), /* NFL - NFLRD */
	GPIO_SETUP(A, 18, GPIO_DISABLE, GPIO_PULL_DISABLE), /* NFL - NFLREADY1 */
	GPIO_SETUP(A, 20, GPIO_DISABLE, GPIO_PULL_DISABLE), /* NFL - NFLALE */
	GPIO_SETUP(A, 21, GPIO_DISABLE, GPIO_PULL_UP), /* NFL - NFLCS0 */
	GPIO_SETUP(A, 22, GPIO_DISABLE, GPIO_PULL_DISABLE), /* NFL - NFLCS1 */

	GPIO_SETUP(B, 0,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART1 - TX */
	GPIO_SETUP(B, 1,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART1 - RX */
	GPIO_SETUP(B, 4,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART2 - TX */
	GPIO_SETUP(B, 5,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART2 - RX */

	GPIO_SETUP(B, 12, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - SCLK */
	GPIO_SETUP(B, 13, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - Fsync */
	GPIO_SETUP(B, 14, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM1 - TX */
	GPIO_SETUP(B, 15, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - RX */
	GPIO_SETUP(B, 16, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - SCLK */
	GPIO_SETUP(B, 17, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - Fsync */
	GPIO_SETUP(B, 18, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM2 - TX */
	GPIO_SETUP(B, 19, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - RX */
	GPIO_SETUP(B, 20, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - SCLK */
	GPIO_SETUP(B, 21, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - Fsync */
	GPIO_SETUP(B, 22, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM3 - TX */
	GPIO_SETUP(B, 23, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - RX */

	GPIO_SETUP(B, 28, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - DO */
	GPIO_SETUP(B, 29, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* SPI1 - DI */
	GPIO_SETUP(B, 30, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - CS1 */
	GPIO_SETUP(B, 31, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - CK */

	GPIO_SETUP(D,  0, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data0 */
	GPIO_SETUP(D,  1, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data1 */
	GPIO_SETUP(C,  0, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data2 */
	GPIO_SETUP(C,  1, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data3 */
	GPIO_SETUP(C,  2, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data4 */
	GPIO_SETUP(C,  3, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data5 */
	GPIO_SETUP(C,  4, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data6 */
	GPIO_SETUP(C,  5, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data7 */
	GPIO_SETUP(D,  2, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data8 */
	GPIO_SETUP(D,  3, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data9 */
	GPIO_SETUP(C,  6, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data10 */
	GPIO_SETUP(C,  7, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data11 */
	GPIO_SETUP(C,  8, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data12 */
	GPIO_SETUP(C,  9, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data13 */
	GPIO_SETUP(C, 10, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data14 */
	GPIO_SETUP(C, 11, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data15 */
	GPIO_SETUP(D,  4, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data16 */
	GPIO_SETUP(D,  5, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data17 */
	GPIO_SETUP(C, 12, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data18 */
	GPIO_SETUP(C, 13, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data19 */
	GPIO_SETUP(C, 14, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data20 */
	GPIO_SETUP(C, 15, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data21 */
	GPIO_SETUP(C, 16, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data22 */
	GPIO_SETUP(C, 17, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - data23 */
	GPIO_SETUP(C, 18, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - pixel clock */
	GPIO_SETUP(C, 19, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - VSYNC */
	GPIO_SETUP(C, 20, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - HSYNC */
	GPIO_SETUP(C, 21, GPIO_DISABLE, GPIO_PULL_DISABLE), /* LCDC - ENABLE */

	GPIO_SETUP(C, 26, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* LCD panel - power */
	GPIO_SETUP(C, 25, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* LCD panel - up/down orientation */
	GPIO_SETUP(G, 21, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* LCD panel - left/right orientation */

	GPIO_SETUP(C, 28, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC1 - clock */
	GPIO_SETUP(C, 29, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC1 - data */
	GPIO_SETUP(C, 30, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC2 - clock */
	GPIO_SETUP(C, 31, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC2 - data */

	GPIO_SETUP(D,  6, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data0 */
	GPIO_SETUP(D,  7, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data1 */
	GPIO_SETUP(D,  8, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data2 */
	GPIO_SETUP(D,  9, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data3 */
	GPIO_SETUP(D, 10, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data4 */
	GPIO_SETUP(D, 11, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data5 */
	GPIO_SETUP(D, 12, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data6 */
	GPIO_SETUP(D, 13, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - data7 */
	GPIO_SETUP(D, 14, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - pixel clock */
	GPIO_SETUP(D, 15, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - hsync */
	GPIO_SETUP(D, 16, GPIO_DISABLE, GPIO_PULL_UP), /* CAM - vsync */
	GPIO_SETUP(D, 17, GPIO_DISABLE, GPIO_PULL_DISABLE), /* CAM - 25MHz clock */
	GPIO_SETUP(G, 14, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Sensor - reset */
	GPIO_SETUP(F,  6, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* Sensor - standby */
	GPIO_SETUP(F, 13, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Flash light - GPIO1 */
	GPIO_SETUP(F, 14, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Flash light - GPIO2 */
	GPIO_SETUP(G, 18, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Flash light - enable */

	GPIO_SETUP(D, 18, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data0 */
	GPIO_SETUP(D, 19, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data1 */
	GPIO_SETUP(D, 20, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data2 */
	GPIO_SETUP(D, 21, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data3 */
	GPIO_SETUP(D, 22, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - clock */
	GPIO_SETUP(D, 23, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - command */
	GPIO_SETUP(F, 19, GPIO_IN,       GPIO_PULL_UP      ), /* SDMMC - detect */

	GPIO_SETUP(D, 28, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DP - PWM_HILO0 */
	GPIO_SETUP(D, 29, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DP - PWM_HILO1 */
	GPIO_SETUP(D, 30, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DP - clock */
	GPIO_SETUP(F, 18, GPIO_IN,       GPIO_PULL_DISABLE ), /* DP - INT */

	GPIO_SETUP(F,  0, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 0 */
	GPIO_SETUP(F,  1, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 1 */
	GPIO_SETUP(F,  2, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 2 */
	GPIO_SETUP(F,  3, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 3 */
	GPIO_SETUP(F,  4, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 4 */
	GPIO_SETUP(F,  5, GPIO_DISABLE, GPIO_PULL_UP), /* KPD - row 5 (stick) */

	GPIO_SETUP(F,  8, GPIO_DISABLE, GPIO_PULL_DISABLE), /* KPD - col 0 */
	GPIO_SETUP(F,  9, GPIO_DISABLE, GPIO_PULL_DISABLE), /* KPD - col 1 */
	GPIO_SETUP(F, 10, GPIO_DISABLE, GPIO_PULL_DISABLE), /* KPD - col 2 */
	GPIO_SETUP(F, 11, GPIO_DISABLE, GPIO_PULL_DISABLE), /* KPD - col 3 */
	GPIO_SETUP(F, 12, GPIO_DISABLE, GPIO_PULL_DISABLE), /* KPD - col 4 */

	GPIO_SETUP(F, 24, GPIO_IN,       GPIO_PULL_UP     ), /* HDMI - interrupt */
	GPIO_SETUP(G, 11, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* HDMI - power */
	GPIO_SETUP(A, 25, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* HDMI - CEC clock */

	//GPIO_SETUP(A, 27, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Analog switch - control */

	GPIO_SETUP(B,  2, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* Audio - mic enable */
	GPIO_SETUP(B, 25, GPIO_OUT_LOW, GPIO_PULL_DISABLE), /* Audio PA - shutdown */

	GPIO_SETUP(F, 16, GPIO_IN, GPIO_PULL_DOWN), /* Accelerometer - Int1 */
	GPIO_SETUP(F, 17, GPIO_IN, GPIO_PULL_DOWN), /* Accelerometer - Int2 */

	GPIO_SETUP(G, 17, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* Touch panel - reset */
	GPIO_SETUP(F, 21, GPIO_IN, GPIO_PULL_DOWN), /* Touch panel - interrupt */

	GPIO_SETUP(D, 26, GPIO_OUT_HIGH, GPIO_PULL_DISABLE), /* PHY - reset */
	GPIO_SETUP(E,  0, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXD0 */
	GPIO_SETUP(E,  1, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXD1 */
	GPIO_SETUP(E,  2, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXEN */
	GPIO_SETUP(E,  3, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXD0 */
	GPIO_SETUP(E,  4, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXD1 */
	GPIO_SETUP(E,  5, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - CRS_DV */
	GPIO_SETUP(E,  6, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXER */
	GPIO_SETUP(E,  7, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - REFCK */
	GPIO_SETUP(E,  8, GPIO_DISABLE,  GPIO_PULL_UP     ), /* MII - MDIO */
	GPIO_SETUP(E,  9, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - MDC */
	GPIO_SETUP(E, 10, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXER */
	GPIO_SETUP(E, 11, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXD2 */
	GPIO_SETUP(E, 12, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* MII - TXD3 */
	GPIO_SETUP(E, 13, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXD2 */
	GPIO_SETUP(E, 14, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXD3 */
	GPIO_SETUP(E, 15, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXCLK */
	GPIO_SETUP(E, 16, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - RXCRS */
	GPIO_SETUP(E, 17, GPIO_DISABLE,  GPIO_PULL_DOWN   ), /* MII - COL */

	GPIO_SETUP(F, 26, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* USB - VBUS enable */
	GPIO_SETUP(F, 20, GPIO_IN,       GPIO_PULL_DISABLE ), /* USB1 - detect */
	GPIO_SETUP(A, 28, GPIO_IN,       GPIO_PULL_DOWN    ), /* USB1 - port type detect */
	GPIO_SETUP(A, 29, GPIO_IN,       GPIO_PULL_DOWN    ), /* USB1 - port type FET control */
	GPIO_SETUP(D, 24, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* USB1 - VBUS enable */
	GPIO_SETUP(F, 22, GPIO_IN,       GPIO_PULL_DISABLE ), /* USB2 - detect */
	GPIO_SETUP(D, 25, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* USB2 - VBUS enable */

	GPIO_SETUP(D, 31, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* DECT - power */
	GPIO_SETUP(G,  0, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SDATA_OUT */
	GPIO_SETUP(G,  1, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SCLK */
	GPIO_SETUP(G,  2, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SDATA_IN */
	GPIO_SETUP(G,  3, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SEN */
	GPIO_SETUP(G,  4, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SLOT_CTRL */
	GPIO_SETUP(G,  5, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - RADIO_EN */
	GPIO_SETUP(G,  6, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - TR_DATA */
	GPIO_SETUP(G,  7, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* DECT - SYNC_MATCH */
	GPIO_SETUP(G,  8, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* DECT - RSTN */

	GPIO_SETUP(F, 25, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* Vibrator - enable */

	GPIO_SETUP(G, 15, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* Wi-Fi Baseband/RF - SW1 */
	GPIO_SETUP(G, 16, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* Wi-Fi Baseband/RF - SW1B */

	GPIO_SETUP(G,  9, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* OVERDRIVE */
};

/* feature specific gpio's */
static __initdata struct gpio_setup_t gpio_setup_emmc[] = {
	GPIO_SETUP(A, 19, GPIO_DISABLE,  GPIO_PULL_UP), /* EMMC - RST */
	GPIO_SETUP(E, 31, GPIO_DISABLE,  GPIO_PULL_UP), /* EMMC - CMD*/
};

static __initdata struct gpio_setup_t gpio_setup_nand[] = {
	GPIO_SETUP(A, 19, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* NFL - NFLCLE */
	GPIO_SETUP(E, 31, GPIO_DISABLE,  GPIO_PULL_UP),      /* NFL - NFLREADY2 */
};


static struct regulator_consumer_supply spare2_consumers[] = {
};

static struct regulator_consumer_supply spare3_consumers[] = {
};

static struct regulator_init_data spare2_data = {
	.constraints = {
		.min_uV = 3300000,
		.max_uV = 3300000,
		.apply_uV = 1,
		.valid_modes_mask = REGULATOR_MODE_NORMAL,
		.valid_ops_mask = REGULATOR_CHANGE_STATUS,
	},
	.num_consumer_supplies = ARRAY_SIZE(spare2_consumers),
	.consumer_supplies = spare2_consumers,
};

static struct regulator_init_data spare3_data = {
	.constraints = {
		.min_uV = 1800000,
		.max_uV = 1800000,
		.apply_uV = 1,
		.valid_modes_mask = REGULATOR_MODE_NORMAL,
		.valid_ops_mask = REGULATOR_CHANGE_STATUS,
	},
	.num_consumer_supplies = ARRAY_SIZE(spare3_consumers),
	.consumer_supplies = spare3_consumers,
};

static struct resource dp52_rtc_resources[] = {
	{
		.name  = "rtc",
		.start = DP52_IRQ_RTC,
		.end   = DP52_IRQ_RTC,
		.flags = IORESOURCE_IRQ,
	},
};

static struct resource dp52_pmu_resources[] = {
	{
		.name  = "pmu",
		.start = DP52_IRQ_PMUEN,
		.end   = DP52_IRQ_PMUEN,
		.flags = IORESOURCE_IRQ,
	},
};

static struct resource dp52_bat_resources[] = {
	{
		.name  = "auxcomp",
		.start = DP52_IRQ_AUXCOMP,
		.end   = DP52_IRQ_AUXCOMP,
		.flags = IORESOURCE_IRQ,
	},
};

static struct dwheadset_config dp52_hsdet_pdata = {
	.switch_platform_data = {
		.name = "h2w",
		.name_on = "ON",
		.name_off = "OFF",
		.state_on = NULL,
		.state_off = NULL,
	},
};

static struct mfd_cell dp52_cells[] = {
	{
		.name = "dp52-rtc",
		.num_resources = ARRAY_SIZE(dp52_rtc_resources),
		.resources = dp52_rtc_resources,
	},
	{
		.name = "dp52-onkey",
		.num_resources = ARRAY_SIZE(dp52_pmu_resources),
		.resources = dp52_pmu_resources,
	},
	{
		.name = "dp52-power",
		.num_resources = ARRAY_SIZE(dp52_pmu_resources),
		.resources = dp52_pmu_resources,
	},
	{
		.name = "dp52-hsdet",
		.num_resources = ARRAY_SIZE(dp52_bat_resources),
		.resources = dp52_bat_resources,
		.mfd_data = &dp52_hsdet_pdata,
	},
};

static struct dp52_platform_data dp52_pdata = {
	.irq = DMW_IID_EXTERNAL_REQUEST_2,
	.irq_base = 64,

	.spare2 = &spare2_data,
	.spare3 = &spare3_data,

	.cells     = dp52_cells,
	.num_cells = ARRAY_SIZE(dp52_cells),
};


static struct spi_board_info spi_devices[] = {
	{
		/* DP52 */
		.modalias	= "dp52",
		.chip_select	= 0,
		.max_speed_hz	= 5 * 1000 * 1000,
		.bus_num	= 0,
		.platform_data	= &dp52_pdata,
	},
};

static struct dmw96_spi_info dmw_spi_info = {
	.bus_num	= 0,
	.set_cs		= NULL,
};

static struct resource dmw_spi_resources[] = {
	{
		.start  = DMW_SPI1_BASE,
		.end    = DMW_SPI1_BASE + 0x200 - 1,
		.flags  = IORESOURCE_MEM,
	},
	{
		.start  = DMW_IID_SPI1,
		.end    = DMW_IID_SPI1,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = 16, /* SPI1 RX */
		.end    = 16,
		.flags  = IORESOURCE_DMA,
	},
	{
		.start  = 15, /* SPI1 TX */
		.end    = 15,
		.flags  = IORESOURCE_DMA,
	},
};

static struct platform_device spi_device = {
	.name = "dmw96-spi",
	.id = 0,
	.num_resources = ARRAY_SIZE(dmw_spi_resources),
	.resource = dmw_spi_resources,
	.dev = {
		.platform_data = &dmw_spi_info
	},
};

static void panel_init(struct dw74fb_panel *panel)
{
	gpio_request(GPIO_PORTC(26), "lcd-power");
	gpio_direction_output(GPIO_PORTC(26), 1);
}

static void panel_suspend(struct dw74fb_panel *panel)
{
	gpio_set_value(GPIO_PORTC(26), 0);
}

static void panel_resume(struct dw74fb_panel *panel)
{
	gpio_set_value(GPIO_PORTC(26), 1);
}

static struct dw74fb_panel panel_innolux_at070tn90 = {
	.name = "innolux_at070tn90",
	.xres = 800,
	.yres = 480,
	.bits_per_pixel = 24,
	.is_cpu_type = 0,
	.clock_rate = 37125000,
	.width_mm = 180,
	.height_mm = 100,
	.osdm_config = OSDM_DISPLAY_RGB24_888_RGB,
	.init = panel_init,
	.suspend = panel_suspend,
	.resume = panel_resume,
	.no_dimmable_backlight = 1,
	.dispir = 0x0001,
	.pancsr = 0x0006,
	.videomode = {
		"innolux_at070tn90", 0, 800, 480, 37125000, 46, 210, 24, 23, 2, 1,
		0, FB_VMODE_NONINTERLACED, FB_MODE_IS_STANDARD
	},
};

static struct resource lcdc_resource[] = {
	{
		.start	= DMW_LCDC_BASE,
		.end	= DMW_LCDC_BASE + SZ_4K + SZ_2K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_LCD_CONTROLLER,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device lcdc_device = {
	.name		= "dw74fb",
	.dev		= {
		.coherent_dma_mask = DMA_BIT_MASK(32),
		.platform_data = &panel_innolux_at070tn90,
	},
	.num_resources	= ARRAY_SIZE(lcdc_resource),
	.resource	= lcdc_resource,
};

static struct i2c_pnx_data i2c0_data = {
	.name	= "pnx-i2c0",
	.base	= DMW_I2C1_BASE,
	.irq	= DMW_IID_I2C1,
	.scl	= GPIO_PORTC(28),
	.sda	= GPIO_PORTC(29),
	.recover = dmw_i2c_recover,
};

static struct i2c_pnx_data i2c1_data = {
	.name	= "pnx-i2c1",
	.base	= DMW_I2C2_BASE,
	.irq	= DMW_IID_I2C2,
	.scl	= GPIO_PORTC(30),
	.sda	= GPIO_PORTC(31),
	.recover = dmw_i2c_recover,
};

static struct platform_device i2c0_pnx_device = {
	.name	= "pnx-i2c",
	.id	= 0,
	.dev	= {
		.platform_data = &i2c0_data,
	},
};

static struct platform_device i2c1_pnx_device = {
	.name	= "pnx-i2c",
	.id	= 1,
	.dev	= {
		.platform_data = &i2c1_data,
	},
};

static struct lis3lv02d_platform_data lis3lv02d_pdata = {
	/* .irq_cfg = 0x9, */ /* Interrupt 1 source OR interrupt 2 source */
};

static struct hdmi_platform_data hdmi_pdata = {
	.switch_platform_data = {
		.name = "hdmi",
		.name_on = "ON",
		.name_off = "OFF",
		.state_on = "1",
		.state_off = "0",
	},
};

/****************************
 * camera
 ****************************/

static int sensor_power_set_parallel(struct dmw_camera_port_s * port,
									 enum v4l2_power 			power,
									 dmw_camera_sensor_desc_t * sensor)
{
	static enum v4l2_power previous_power = V4L2_POWER_OFF;
	static char requested = 0;

	if (!requested) {
		gpio_request(GPIO_PORTF(6), "CAM_PWDN");
		gpio_request(GPIO_PORTG(14), "CAM_RESETB");
		requested = 1;
	}

	switch (power) {
	case V4L2_POWER_ON:
		ciu_configure_intreface();
		ciu_interface_parallel();

		gpio_set_value(GPIO_PORTF(6), 0); /* power up */
		if (previous_power == V4L2_POWER_OFF) {
			/* reset */
			udelay(100);
			gpio_set_value(GPIO_PORTG(14), 0);
			udelay(100);
			gpio_set_value(GPIO_PORTG(14), 1);

			mdelay( 20 );
		}
		break;

	case V4L2_POWER_OFF:
		/* Cannot power off on EVB96. Just assert power down. */
		gpio_set_value(GPIO_PORTF(6), 1);
		gpio_set_value(GPIO_PORTG(14), 0);
		break;

	case V4L2_POWER_STANDBY:
		gpio_set_value(GPIO_PORTF(6), 1);
		break;

	}
	previous_power = power;

	return 0;
}

static int sensor_set_xclk(struct dmw_camera_port_s * port,
						   unsigned long 			  xclkfreq)
{
	ciu_clock_rate(xclkfreq);
	return 0;
}

static struct resource dmw96ciu_resources[] = {
	{
		.start = DMW_CIU_BASE,
		.end   = DMW_CIU_BASE + SZ_4K - 1,
		.flags = IORESOURCE_MEM,
	},
	{
		.start = DMW_IID_CIU,
		.flags = IORESOURCE_IRQ,
		.name  = "dmw96ciu-irq",
	},
};

static void ciu_reset(int enable)
{
	if (enable)
		reset_set(RESET_CIU);
	else
		reset_release(RESET_CIU);
};

static struct ciu_pdata ciu_pdata = {
	.ciu_reset = ciu_reset,
};

static struct platform_device ciu_device = {
	.name = "dmw96ciu",
	.id		= 0,
	.dev		= {
		.platform_data = &ciu_pdata,
		.coherent_dma_mask = ~0,
	},
	.num_resources = ARRAY_SIZE(dmw96ciu_resources),
	.resource = dmw96ciu_resources,
};

static struct ov2643_sensor_platform_data ov2643_sensor_pdata = {
	.output_drive_capability = 3,
};

static dmw_camera_sensor_platform_data_t ov2643_sensor_platform_data = {
	.sensor_pdata = &ov2643_sensor_pdata,
};

static struct platform_device ov2643_device = {
	.name = "ov2643",
	.id   = 0,
};

/* list of possible back sensors */
static struct platform_device *dmw96_cam_back_sensors[] = {
	&ov2643_device,
};

/* back camera port */
static dmw_camera_port_t dmw96_cam =
{
	.name		= "cam",
	.pdata		= NULL,
	.power_ctl	= sensor_power_set_parallel,
	.clock_ctl	= sensor_set_xclk,
	.sensor_list	= dmw96_cam_back_sensors,
	.num_sensors	= ARRAY_SIZE(dmw96_cam_back_sensors),
	.i2c_adapter_num= 0,
	.hw_config	= {
		.dev_index	= 1,
		.dev_minor	= 4,
		.dev_type	= DMW96CAM_SLAVE_SENSOR,
		.u.sensor.xclk	= DMW96CAM_XCLK_B,
	},
};

static struct i2c_board_info __initdata i2c0_devices[] = {
	{
		I2C_BOARD_INFO("lis3lv02d", 0x1d),
		.irq = DMW_IID_EXTERNAL_REQUEST_0,
		.platform_data = &lis3lv02d_pdata,
	},
	{
		I2C_BOARD_INFO("wm897X", 0x1A),
	},
	{
		I2C_BOARD_INFO("sii902xA", 0x39),
		.irq = DMW_IID_EXTERNAL_REQUEST_8,
		.platform_data = &hdmi_pdata,
	},
};

static struct goodix_ts_pdata goodix_ts_pdata = {
	.gpio_irq = GPIO_PORTF(21),
	.gpio_shutdown = GPIO_PORTG(17),
	.screen_width = 800,
	.screen_height = 480,
//	.full_screen_width = 800,
//	.full_screen_height = 480,
};

static struct i2c_board_info __initdata i2c1_devices[] = {
	{
		I2C_BOARD_INFO("Goodix-TS", 0x55),
		.irq = DMW_IID_EXTERNAL_REQUEST_5,
		.platform_data = &goodix_ts_pdata,
	},
};

static struct dmw_keypad_config dmw_keypad_config = {
	.rows = 6,
	.cols = 5,
};

static struct resource dmw_keypad_resources[] = {
	{
		.start	= DMW_GPIO_BASE,
		.end	= DMW_GPIO_BASE + 0x3fff,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_KEYPAD,
		.end	= DMW_IID_KEYPAD,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device keypad_device = {
	.name		= "dmw-keypad",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(dmw_keypad_resources),
	.resource	= dmw_keypad_resources,
	.dev		= {
		.platform_data = &dmw_keypad_config,
	},
};

static struct resource dmw_uart0_resource[] = {
	{
		.start	= DMW_UART1_BASE,
		.end	= DMW_UART1_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_UART1,
		.end	= DMW_IID_UART1,
		.flags	= IORESOURCE_IRQ,
	}
};

static struct platform_device uart0_device = {
	.name		= "dw-uart",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(dmw_uart0_resource),
	.resource	= dmw_uart0_resource,
};

static struct plat_stmmacenet_data stmmaceth_plat_data = {
	.bus_id		= 0,
	.pbl		= 32, /* DMA burst length */
	.has_gmac	= 1,
	.enh_desc	= 0,
};

static struct resource stmmaceth_resources[] = {
	{
		.start	= DMW_MAC_BASE,
		.end	= DMW_MAC_BASE + SZ_4K + SZ_256 - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_8023MAC,
		.flags	= IORESOURCE_IRQ,
		.name	= "macirq",
	},
};

static struct platform_device stmmaceth_device = {
	.name		= "stmmaceth",
	.dev		= {
		.platform_data = &stmmaceth_plat_data,
		.coherent_dma_mask = DMA_BIT_MASK(32),
	},
	.num_resources	= ARRAY_SIZE(stmmaceth_resources),
	.resource	= stmmaceth_resources,
};

static struct plat_stmmacphy_data stmmacphy_plat_data = {
	.bus_id		= 0,
	.phy_addr	= -1,
	.interface	= 0,
};

static struct platform_device stmmacphy_device = {
	.name		= "stmmacphy",
	.dev		= {
		.platform_data = &stmmacphy_plat_data,
	},
};

static struct resource dmw_nand_resources[] = {
	{
		.start	= DMW_NAND_LCD_BASE,
		.end	= DMW_NAND_LCD_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start  = DMW_IID_FLASH_CONTROLLER,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device nand_device = {
	.name		= "dmw_nand",
	.dev		= {
		.coherent_dma_mask = DMA_BIT_MASK(32),
	},
	.num_resources	= ARRAY_SIZE(dmw_nand_resources),
	.resource	= dmw_nand_resources,
};

static struct resource dw_mmc_resource[] = {
	{
		.start = DMW_SDMMC_BASE,
		.end   = DMW_SDMMC_BASE + SZ_4K - 1,
		.flags = IORESOURCE_MEM,
	},
	{
		.start = DMW_IID_SDMMC_CONTROLLER,
		.flags = IORESOURCE_IRQ,
	},
};

static int dw_mmc_init(u32 slot_id, irq_handler_t isr, void *dev_id)
{
	switch (slot_id) {
	case 0:
		enable_irq_wake(DMW_IID_EXTERNAL_REQUEST_3);
		return request_irq(DMW_IID_EXTERNAL_REQUEST_3, isr, IRQF_DISABLED |
				   IRQF_TRIGGER_RISING | IRQF_TRIGGER_FALLING,
				   "dw-mci cdetect", dev_id);
	case 1:
		return 0;
	default:
		return -ENOSYS;
	}
}

static int dw_mmc_get_ro(u32 slot_id)
{
	/* always read-write */
	return 0;
}

static int dw_mmc_get_cd(u32 slot_id)
{
	switch (slot_id) {
	case 0:
		return gpio_get_value(GPIO_PORTF(19));
	case 1:
		return 0;
	default:
		return 1;
	}
}

static struct dw_mci_board_slot dw_mmc_slots_single[] = {
	{
		.id = 0,
		.caps = MMC_CAP_4_BIT_DATA,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
};

static struct dw_mci_board_slot dw_mmc_slots_emmc[] = {
	{
		.id = 1,
		.caps = MMC_CAP_4_BIT_DATA | MMC_CAP_8_BIT_DATA |
			MMC_CAP_NONREMOVABLE,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
	{
		.id = 0,
		.caps = MMC_CAP_4_BIT_DATA,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
};

static struct block_settings dw_mmc_blk_settings = {
	.max_segs = 64,
	.max_blk_size = 65536,
	.max_blk_count = 0xffffffff,
	.max_req_size = 0xffffffff,
	.max_seg_size = 4096,
};

static struct dw_mci_board dw_mmc_pdata = {
	.detect_delay_ms = 500,
	.bus_hz = 10000000,
	.blk_settings = &dw_mmc_blk_settings,
	.fifo_depth = 0x20,
	.quirks = DW_MCI_QUIRK_SBE_NEED_STOP | DW_MCI_QUIRK_HIGHSPEED,
};

static struct platform_device sdmmc_device = {
	.name = "dw_mmc",
	.dev.platform_data = &dw_mmc_pdata,
	.dev.coherent_dma_mask = DMA_BIT_MASK(32),
	.num_resources = ARRAY_SIZE(dw_mmc_resource),
	.resource = dw_mmc_resource,
};

static void reset_tdm0(int enable)
{
	if (enable)
		reset_set(RESET_TDM1);
	else
		reset_release(RESET_TDM1);
}

static void reset_tdm1(int enable)
{
	if (enable)
		reset_set(RESET_TDM2);
	else
		reset_release(RESET_TDM2);
}

static void reset_tdm2(int enable)
{
	if (enable)
		reset_set(RESET_TDM3);
	else
		reset_release(RESET_TDM3);
}

static struct dmw_tdm_pdata tdm0_pdata = {
	.reset = reset_tdm0,
};

static struct dmw_tdm_pdata tdm1_pdata = {
	.reset = reset_tdm1,
};

static struct dmw_tdm_pdata tdm2_pdata = {
	.reset = reset_tdm2,
};

static struct resource tdm0_resources[] = {
	{
		.start	= DMW_IID_TDM1,
		.end	= DMW_IID_TDM1,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM1_BASE,
		.end	= DMW_TDM1_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 8, /* capture -> TDM1 RX FIFO */
		.end	= 8,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 9, /* playback -> TDM1 TX FIFO */
		.end	= 9,
		.flags	= IORESOURCE_DMA,
	},
};

static struct resource tdm1_resources[] = {
	{
		.start	= DMW_IID_TDM2,
		.end	= DMW_IID_TDM2,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM2_BASE,
		.end	= DMW_TDM2_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 10, /* capture -> TDM2 RX FIFO */
		.end	= 10,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 11, /* playback -> TDM2 TX FIFO */
		.end	= 11,
		.flags	= IORESOURCE_DMA,
	},
};

static struct resource tdm2_resources[] = {
	{
		.start	= DMW_IID_TDM3,
		.end	= DMW_IID_TDM3,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM3_BASE,
		.end	= DMW_TDM3_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 12, /* capture -> TDM3 RX FIFO */
		.end	= 12,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 13, /* playback -> TDM3 TX FIFO */
		.end	= 13,
		.flags	= IORESOURCE_DMA,
	},
};

static struct platform_device tdm0_device = {
	.name		= "dmw-tdm",
	.id		= 0,
	.dev		= {
		.platform_data = &tdm0_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm0_resources),
	.resource	= tdm0_resources,
};

static struct platform_device tdm1_device = {
	.name		= "dmw-tdm",
	.id		= 1,
	.dev		= {
		.platform_data = &tdm1_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm1_resources),
	.resource	= tdm1_resources,
};

static struct platform_device tdm2_device = {
	.name		= "dmw-tdm",
	.id		= 2,
	.dev		= {
		.platform_data = &tdm2_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm2_resources),
	.resource	= tdm2_resources,
};

static void usb1_set_vbus_power(int enable)
{
	gpio_request(GPIO_PORTD(24), "usb1");
	gpio_direction_output(GPIO_PORTD(24), !!enable);
	gpio_free(GPIO_PORTD(24));
}

static struct dwc_otg_platform_data usb1_pdata = {
	.set_vbus_power		= usb1_set_vbus_power,
	.drvvbus_gpio		= GPIO_PORTD(24),
	.overcurrent_gpio	= -1,
	.vbusdetect_gpio	= GPIO_PORTF(20),
	.busy			= dmw_usb1_busy,
	.idle			= dmw_usb1_idle,
};

static struct resource usb1_resources[] = {
	{
		.start	= DMW_IID_USB1OTG_MC_NINT,
		.end	= DMW_IID_USB1OTG_MC_NINT,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_IID_USB1OTG_SOF_PULSE,
		.end	= DMW_IID_USB1OTG_SOF_PULSE,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_USB1_OTG_BASE,
		.end	= DMW_USB1_OTG_BASE + SZ_1M - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device usb1_device = {
	.name		= "dwc_otg",
	.id		= 0,
	.dev		= {
		.coherent_dma_mask = DMA_BIT_MASK(32),
		.platform_data = &usb1_pdata,
	},
	.num_resources	= ARRAY_SIZE(usb1_resources),
	.resource	= usb1_resources,
};

static void usb2_set_vbus_power(int enable)
{
	gpio_request(GPIO_PORTD(25), "usb1");
	gpio_direction_output(GPIO_PORTD(25), !!enable);
	gpio_free(GPIO_PORTD(25));
}

static struct dwc_otg_platform_data usb2_pdata = {
	.set_vbus_power		= usb2_set_vbus_power,
	.drvvbus_gpio		= GPIO_PORTD(25),
	.overcurrent_gpio	= -1,
	.vbusdetect_gpio	= GPIO_PORTF(22),
	.busy			= dmw_usb2_busy,
	.idle			= dmw_usb2_idle,
};

static struct resource usb2_resources[] = {
	{
		.start	= DMW_IID_USB2OTG_MC_NINT,
		.end	= DMW_IID_USB2OTG_MC_NINT,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_IID_USB2OTG_SOF_PULSE,
		.end	= DMW_IID_USB2OTG_SOF_PULSE,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_USB2_OTG_BASE,
		.end	= DMW_USB2_OTG_BASE + SZ_1M - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device usb2_device = {
	.name		= "dwc_otg",
	.id		= 1,
	.dev		= {
		.coherent_dma_mask = DMA_BIT_MASK(32),
		.platform_data = &usb2_pdata,
	},
	.num_resources	= ARRAY_SIZE(usb2_resources),
	.resource	= usb2_resources,
};

static char *android_usb_functions[] = {
	"adb",
	"usb_mass_storage",
};

static struct android_usb_platform_data android_usb_data = {
	.vendor_id = 0x18D1,
	.product_id = 2,
	.product_name = "DMW96-EVB",
	.manufacturer_name = "DSPG",
	.serial_number = "DSPG-DMW96-EVB",
	.num_functions = ARRAY_SIZE(android_usb_functions),
	.functions = android_usb_functions,
};

static struct platform_device android_usb = {
	.name			= "android_usb",
	.id			= -1,
	.dev			= {
		.platform_data	= &android_usb_data,
	},
};

static struct usb_mass_storage_platform_data android_mass_storage = {
	.nluns = 1,
};

static struct platform_device android_usb_mass_storage = {
	.name			= "usb_mass_storage",
	.id			= -1,
	.dev			= {
		.platform_data	= &android_mass_storage,
	},
};

static struct usb_ether_platform_data rndis_usb_data = {
	.ethaddr	= { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 },
	.vendorID	= 0,
	.vendorDescr	= "DSPG",
};

static struct platform_device rndis = {
	.name			= "rndis",
	.id			= -1,
	.dev			= {
		.platform_data	= &rndis_usb_data,
	},
};

static void wifi_cmu_reset(void)
{
	reset_set(RESET_WIFI);
	reset_release(RESET_WIFI);
}

static struct dwf_platform_data wifi_pdata = {
	.chip = DMW_CHIP_DMW96,
	.board = 2, /* DMW_BOARD_TFEVB */
	.reset = wifi_cmu_reset,
	.busy = dmw_wifi_busy,
	.idle = dmw_wifi_idle,
};

static struct resource wifi_resources[] = {
	[DWF_RESOURCE_APB] = {
		.start	= DMW_WIFI_APB_BASE,
		.end	= DMW_WIFI_APB_BASE + 0xA000 - 1,
		.flags	= IORESOURCE_MEM,
	},
	[DWF_RESOURCE_AHB] = {
		.start	= DMW_WIFI_AHB_BASE,
		.end	= DMW_WIFI_AHB_BASE + 0x214 - 1,
		.flags	= IORESOURCE_MEM,
	},
	[DWF_RESOURCE_ONCHIP] = {
		.start	= DMW_SRAM_WIFI_BASE,
		.end	= DMW_SRAM_WIFI_BASE + DMW_SRAM_WIFI_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[DWF_RESOURCE_IRQ] = {
		.start	= DMW_IID_MAC,
		.end	= DMW_IID_MAC,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device wifi_device = {
	.name = "dw-wifi",
	.id = -1,
	.dev.platform_data = &wifi_pdata,
	.num_resources	= ARRAY_SIZE(wifi_resources),
	.resource	= wifi_resources,
};

static struct cpufreq_frequency_table dmw_freq_table[] = {
	{
		.frequency	= 756000,
		.index		= 0,
	},
	{
		.frequency	= 864000,
		.index		= 1,
	},
#if 0
	{
		.frequency	= 996000,
		.index		= 1,
	},
#endif
	{
		.frequency	= CPUFREQ_TABLE_END,
	},
};

static struct dmw_cpufreq_pdata cpufreq_pdata = {
	.freq_table = dmw_freq_table,
	.overdrive_gpio = OVERDRIVE_GPIO,
};

static struct platform_device cpufreq_device = {
	.name	= "cpufreq-dmw",
	.id	= -1,
	.dev	= {
		.platform_data	= &cpufreq_pdata,
	},
};

static struct dmw_pm_pdata pm_pdata = {
	.overdrive_gpio = OVERDRIVE_GPIO,
	.dram_rtt_gpio = -1,
};

static struct platform_device pm_device = {
	.name	= "dmw-pm",
	.id	= -1,
	.dev	= {
		.platform_data	= &pm_pdata,
	},
};

/*
 * FIXME: even though this device is not on the board we currently need to
 * register it because without it the dmw asoc code will not fully initialize
 */
static struct platform_device csr8811_device = {
	.name	= "BT-csr8811",
	.id	= -1,
};

/* Dummy codec */
static struct platform_device dummy_codec_device = {
	.name	= "dummy",
	.id	= -1,
};

static struct platform_device pcm_device = {
	.name	= "dmw-pcm-audio",
	.id	= -1,
};

static struct dmw_board_pdata asoc_mach_pdata = {
	.out_ana_sw    	= -1,
	.in_ana_sw 	= GPIO_PORTB(2),
	.pa_gain   	= -1,
	.pa_shutdn 	= GPIO_PORTB(25),
};

static struct platform_device asoc_mach_device = {
	.name = "snd-tfevb-mach-drv",
	.id = -1,
	.dev.platform_data = &asoc_mach_pdata,
};

static struct css_pdata css_pdata = {
	.rf_reset = GPIO_PORTG(8),
	.uart = 1, /* UART2 */
};

static struct resource css_resources[] = {
	[CSS_AHBRAM] = {
		.start	= CSS_AHBRAM_BASE,
		.end	= CSS_AHBRAM_BASE + CSS_AHBRAM_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[CSS_ITCM] = {
		.start	= CSS_ITCM_BASE,
		.end	= CSS_ITCM_BASE + CSS_ITCM_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
	[CSS_DTCM] = {
		.start	= CSS_DTCM_BASE,
		.end	= CSS_DTCM_BASE + CSS_DTCM_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device css_device = {
	.name		= "css",
	.id		= 0,
	.dev		= {
		.platform_data = &css_pdata,
		.coherent_dma_mask = DMA_BIT_MASK(32),
	},
	.num_resources	= ARRAY_SIZE(css_resources),
	.resource	= css_resources,
};

static struct regulator_consumer_supply vcc3v3_supplies[] = {
	REGULATOR_SUPPLY("avdd", "0-001a"), /* Wolfson */
};

static struct regulator_init_data vcc3v3_init_data = {
	.constraints		= {
		.valid_modes_mask	= REGULATOR_MODE_NORMAL,
		.always_on		= 1,
	},
	.num_consumer_supplies	= ARRAY_SIZE(vcc3v3_supplies),
	.consumer_supplies	= vcc3v3_supplies,
};

static struct fixed_voltage_config vcc3v3_config = {
	.supply_name		= "vcc3v3",
	.microvolts		= 3300000,
	.gpio			= -EINVAL,
	.enabled_at_boot	= 1,
	.init_data		= &vcc3v3_init_data,
};

static struct platform_device vcc3v3_reg_device = {
	.name			= "reg-fixed-voltage",
	.id			= 0,
	.dev			= {
		.platform_data	= &vcc3v3_config,
	},
};

static struct platform_device *evb_platform_devs[] __initdata = {
	&lcdc_device,
	&cpufreq_device,
	&i2c0_pnx_device,
	&i2c1_pnx_device,
	&keypad_device,
	&stmmaceth_device,
	&stmmacphy_device,
	&pm_device,
	&sdmmc_device,
	&spi_device,
	&tdm0_device,
	&tdm1_device,
	&tdm2_device,
	&pcm_device,
	&asoc_mach_device,
	&csr8811_device,
	&dummy_codec_device,
	&usb1_device,
	&usb2_device,
	&wifi_device,
	&vcc3v3_reg_device,
	&ov2643_device,
};

static int __init dmw_tfevb_dev_init(void)
{
	uint32_t reg;

	if (!dmw_board_is("tf-evb"))
		return -ENODEV;

	/*
	 * Configure pads according to the used devices
	 */
	reg = readl(IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR1);
	reg |= DMW_SYSCFG_SPCR1_BB_PAD_EN;

	if (dmw_board_has_feature("nand"))
		reg |= DMW_SYSCFG_SPCR1_FC_PAD_EN;
	else
		reg |= DMW_SYSCFG_SPCR1_EMMC_PAD_EN;

	reg |= DMW_SYSCFG_SPCR1_UART1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_UART2_PAD_EN;

	reg |= DMW_SYSCFG_SPCR1_TDM1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_TDM2_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_TDM3_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_SPI1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_I2C_1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_I2C_2_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_SD_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_EMACA_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_LCDC_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_LCDGP_PAD2_EN;
	reg |= DMW_SYSCFG_SPCR1_LCDGP_PAD1_EN;
	reg |= DMW_SYSCFG_SPCR1_LCDGP_PAD0_EN;
	writel(reg, IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR1);

	reg = readl(IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR2);
	reg |= DMW_SYSCFG_SPCR2_CIU_PAD_EN;
	reg |= DMW_SYSCFG_SPCR2_DP_CLK_PAD_EN;
	reg |= DMW_SYSCFG_SPCR2_BMP_PAD_EN;
	reg |= DMW_SYSCFG_SPCR2_DECT_IF_PAD_EN;
	reg |= DMW_SYSCFG_SPCR2_CLK_OUT_PAD_EN;
	writel(reg, IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR2);

	/* Setup GPIOs */
	dmw_gpio_setup(gpio_setup_default, ARRAY_SIZE(gpio_setup_default));

	/*
	 * Release USB from reset.
	 */
	reset_set(RESET_USB1_PHY_POR);
	reset_set(RESET_USB1_PHY_PORT);
	reset_set(RESET_USB1_MAC_PHYIF);
	reset_set(RESET_USB1_MAC_RST);
	udelay(10); reset_release(RESET_USB1_PHY_POR);
	udelay(40); reset_release(RESET_USB1_PHY_PORT);
	udelay(10); reset_release(RESET_USB1_MAC_PHYIF);
	udelay(10); reset_release(RESET_USB1_MAC_RST);

	reset_set(RESET_USB2_PHY_POR);
	reset_set(RESET_USB2_PHY_PORT);
	reset_set(RESET_USB2_MAC_PHYIF);
	reset_set(RESET_USB2_MAC_RST);
	udelay(10); reset_release(RESET_USB2_PHY_POR);
	udelay(40); reset_release(RESET_USB2_PHY_PORT);
	udelay(10); reset_release(RESET_USB2_MAC_PHYIF);
	udelay(10); reset_release(RESET_USB2_MAC_RST);

	/*
	 * First register UART device so we can read errors on the console
	 */
	platform_device_register(&uart0_device);

	/*
	 * Register SPI and I2C devices.
	 */
	spi_register_board_info(spi_devices, ARRAY_SIZE(spi_devices));
	i2c_register_board_info(0, i2c0_devices, ARRAY_SIZE(i2c0_devices));
	i2c_register_board_info(1, i2c1_devices, ARRAY_SIZE(i2c1_devices));

	platform_device_register(&android_usb);
	platform_device_register(&android_usb_mass_storage);
	platform_device_register(&rndis);

	if (dmw_board_has_feature("nand")) {
		dmw_gpio_setup(gpio_setup_nand, ARRAY_SIZE(gpio_setup_nand));
		dw_mmc_pdata.slots = dw_mmc_slots_single;
		dw_mmc_pdata.num_slots = ARRAY_SIZE(dw_mmc_slots_single);
		platform_device_register(&nand_device);
	} else {
		dmw_gpio_setup(gpio_setup_emmc, ARRAY_SIZE(gpio_setup_emmc));
		dw_mmc_pdata.slots = dw_mmc_slots_emmc;
		dw_mmc_pdata.num_slots = ARRAY_SIZE(dw_mmc_slots_emmc);
	}

	if (dmw_dev_reserve_dmamem(&ciu_device.dev, DMW_RESERVEMEM_CAMERA, 1) == 0)
		platform_device_register(&ciu_device);

	if (dmw_dev_reserve_dmamem(&css_device.dev, DMW_RESERVEMEM_CSS, 0) == 0)
		platform_device_register(&css_device);

	/* register ov2643 driver data */
	platform_set_drvdata(&ov2643_device, &ov2643_sensor_platform_data);

	return platform_add_devices(evb_platform_devs, ARRAY_SIZE(evb_platform_devs));
}

device_initcall(dmw_tfevb_dev_init);

static int dmw_tfevb_late_init( void )
{
	if (!dmw_board_is("tf-evb"))
		return -ENODEV;

	/* initialize camera port */
	dmw_camera_initialize_port(&dmw96_cam);

	return 0;
}

late_initcall( dmw_tfevb_late_init );
