// TODO: limitation: only one sensor instance of any kind (because of global data structures)
/*
 * drivers/media/video/ov5640.c
 *
 * ov5640 sensor driver
 *
 *
 * Copyright (C) 2012 DSPG.
 *
 * Leverage ov5640.c
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#include <linux/io.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <media/v4l2-int-device.h>
#include <media/ov5640.h>
#include <linux/dma-mapping.h> /*For page align*/
#include <media/dmw96ciu.h>
#include <mach/hardware.h>
#include <mach/camera.h>

/**********************************
 * definitions
 **********************************/

#define OV5640_DRIVER_NAME  "ov5640"
#define MOD_NAME "OV5640: "

#define OV5640_I2C_ADDR (0x78 >> 1)

#define I2C_M_WR 0

#define OV5640_PIDH 0x300A
#define OV5640_PIDL 0x300B

/* High byte of product ID */
#define OV5640_PIDH_MAGIC      0x56
/* Low byte of product ID  */
#define OV5640_PIDL_MAGIC      0x40

#define OV5640_USE_XCLKA       0
#define OV5640_USE_XCLKB       1

#define OV5640_CSI2_VIRTUAL_ID 0x1

/* FPS Capabilities */
#define OV5640_MIN_FPS                 3
#define OV5640_DEF_FPS                 15
#define OV5640_MAX_FPS                 30

#define OV5640_MIN_BRIGHT              0
#define OV5640_MAX_BRIGHT              6
#define OV5640_DEF_BRIGHT              0
#define OV5640_BRIGHT_STEP             1

#define OV5640_DEF_CONTRAST            0
#define OV5640_MIN_CONTRAST            0
#define OV5640_MAX_CONTRAST            6
#define OV5640_CONTRAST_STEP           1

#define OV5640_DEF_COLOR               0
#define OV5640_MIN_COLOR               0
#define OV5640_MAX_COLOR               2
#define OV5640_COLOR_STEP              1

#define OV5640_DEF_FLIP               	0

#define OV5640_DEF_MIRRO               	0

#define SENSOR_DETECTED                1
#define SENSOR_NOT_DETECTED    0

/* NOTE: Set this as 0 for enabling SoC mode */
#define OV5640_RAW_MODE        0

/* XCLK Frequency in Hz*/
#define OV5640_XCLK_MIN                24000000
#define OV5640_XCLK_MAX                24000000

#define OV5640_REG_TERM 0xFFFF /* terminating list entry for reg */
#define OV5640_VAL_TERM 0xFF   /* terminating list entry for val */

#define vidioc_int_s_reg_num (vidioc_int_priv_start_num + 1)
V4L2_INT_WRAPPER_1(s_reg, const struct v4l2_dbg_register, *);

#define vidioc_int_g_reg_num (vidioc_int_priv_start_num + 2)
V4L2_INT_WRAPPER_1(g_reg, const struct v4l2_dbg_register, *);

#define array_size( arr ) (sizeof( arr ) / sizeof( arr[0] ))

static dmw_camera_sensor_desc_t ov5640_sensor_desc;

/**********************************
 * data
 **********************************/

typedef struct ov5640_reg_s
{
	unsigned int  reg;
	unsigned char val;
} ov5640_reg_t;

enum ov5640_frameintervals_type
{
	OV5640_3_FPS,
	OV5640_7_5_FPS,
	OV5640_11_FPS,
	OV5640_15_FPS,
	OV5640_20_FPS,
	OV5640_25_FPS,
	OV5640_30_FPS,
};

typedef struct ov5640_mode_s
{
	/* resolution */
    unsigned long  		 width;
    unsigned long  		 height;

    /* mode name string */
    const char *   		 name;

    /* initialization registers */
    const ov5640_reg_t * reg_list;
    unsigned long  		 num_regs;

} ov5640_mode_t;

/**********************************
 * registers
 **********************************/

//////////////////
// WORKING
//////////////////

#if 1

static const ov5640_reg_t ov5640_regs_mode_VGA[] =
{
	{0x3008, 0x82},
	{0x3008, 0x42},

	{0x3103, 0x03},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3630, 0x2e},

	{0x3632, 0xe2},
	{0x3633, 0x23},
	{0x3634, 0x44},
	{0x3621, 0xe0},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3905, 0x02},
	{0x3906, 0x10},
	{0x3901, 0x0a},
	{0x3731, 0x12},
	{0x3600, 0x04},
	{0x3601, 0x22},
	{0x471c, 0x50},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3503, 0x07},
	{0x3500, 0x00},
	{0x3501, 0x01},
	{0x3502, 0x00},
	{0x350a, 0x00},
	{0x350b, 0x3f},
	{0x3002, 0x1c},
	{0x3006, 0xc3},
	{0x300e, 0x65},
	{0x302e, 0x08},
	{0x3612, 0x4b},
	{0x3618, 0x00},
	{0x3034, 0x18},

	{0x3035, 0x31},
	{0x3036, 0x54}, // orig mul
	{0x3037, 0x13}, // div

	{0x3108, 0x01},
	{0x3708, 0x64},
	{0x3709, 0x12},
	{0x370c, 0x03},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x04},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9b},
	{0x3808, 0x02},
	{0x3809, 0x80},
	{0x380a, 0x01},
	{0x380b, 0xe0},
	{0x380c, 0x07},
	{0x380d, 0x68},
	{0x380e, 0x03},
	{0x380f, 0xd8},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x06},
	{0x3814, 0x31},
	{0x3815, 0x31},
	{0x3820, 0x40},
	{0x3821, 0x06},
	{0x3824, 0x01},
	{0x3a02, 0x07},
	{0x3a03, 0xb0},
	{0x3a08, 0x00},
	{0x3a09, 0x94},

	{0x3a0a, 0x00},
	{0x3a0b, 0x7b},
	{0x3a0e, 0x06},
	{0x3a0d, 0x08},
	{0x3a14, 0x07},
	{0x3a15, 0xb0},
	{0x4001, 0x02},
	{0x4004, 0x06},
	{0x4300, 0x3f},
	{0x460b, 0x37},
	{0x460c, 0x20},
	{0x4713, 0x02},
	{0x4750, 0x00},
	{0x4751, 0x00},
//	{0x4837, 0x2a},
	{0x5000, 0x07},
	{0x5001, 0x03},
	{0x501d, 0x00},
	{0x501f, 0x00},
	{0x5684, 0x10},
	{0x5685, 0xa0},
	{0x5686, 0x0c},
	{0x5687, 0x78},
	{0x5a00, 0x08},
	{0x5a21, 0x00},
	{0x5a24, 0x00},
	{0x5000, 0x27},

	// TODO ROEE changed resolution
	{0x5001, 0xa3},
//	{0x5001, 0x83},

	{0x3821, 0x06},
	{0x5481, 0x08},
	{0x5482, 0x14},
	{0x5483, 0x28},
	{0x5484, 0x51},
	{0x5485, 0x65},

	{0x5486, 0x71},
	{0x5487, 0x7d},
	{0x5488, 0x87},
	{0x5489, 0x91},
	{0x548a, 0x9a},
	{0x548b, 0xaa},
	{0x548c, 0xb8},
	{0x548d, 0xcd},
	{0x548e, 0xdd},
	{0x548f, 0xea},
	{0x5490, 0x1d},
	{0x5381, 0x20},
	{0x5382, 0x64},
	{0x5383, 0x08},
	{0x5384, 0x20},
	{0x5385, 0x80},
	{0x5386, 0xa0},
	{0x5387, 0xa2},
	{0x5388, 0xa0},
	{0x5389, 0x02},
	{0x538a, 0x01},
	{0x538b, 0x98},
	{0x5300, 0x08},
	{0x5301, 0x30},
	{0x5302, 0x10},
	{0x5303, 0x00},
	{0x5304, 0x08},
	{0x5305, 0x30},
	{0x5306, 0x08},
	{0x5307, 0x16},
	{0x5580, 0x02},
	{0x5583, 0x40},
	{0x5584, 0x10},
	{0x5589, 0x10},

	{0x558a, 0x00},
	{0x558b, 0xf8},

	// ROEE
	/*495*/ {0x4800,0x24},
//	/*496*/ {0x4801,0x0c},


	{0x3a0f, 0x36},
	{0x3a10, 0x2e},
	{0x3a1b, 0x38},
	{0x3a1e, 0x2c},
	{0x3a11, 0x70},
	{0x3a1f, 0x18},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3003, 0x03},
	{0x3003, 0x01},
	{0x3008, 0x02},
	{0x3503, 0x00},


	// TODO DEBUG
//	{0x503d, 0x80},

	////////////////////////////////
//	{0x3821, 0x06},
//	{0x3824, 0x01},
//	{0x3814, 0x11},
//	{0x3815, 0x11},
//	{0x3035, 0x11},
//	{0x3618, 0x04},
//	{0x370c, 0x00},
//	{0x5001, 0x83},
//	{0x4837, 0x15},
//	{0x3803, 0x00},
//	{0x3807, 0x9f},
//	{0x3808, 0x0a},
//	{0x3809, 0x20},
//	{0x380a, 0x07},
//	{0x380b, 0x98},
//	{0x380c, 0x0b},
//	{0x380d, 0x1c},
//	{0x380e, 0x07},
//	{0x380f, 0xb0},
//	{0x4005, 0x1A},
};

#endif

//////////////////
// 1.3mp testing based on VGA
//////////////////

static const ov5640_reg_t ov5640_regs_mode_1_3MP[] =
{
	{0x3008, 0x82},
	{0x3008, 0x42},

	{0x3103, 0x03},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3630, 0x2e},

	//////////////////////// ROEE MIPI TIMING TEST

//	{0x4819, 0x80},
//	{0x481d, 0x70},
//	{0x4821, 0x40},
//	{0x4825, 0x26},
//	{0x4827, 0x26},
//	{0x4829, 0x50},
//	{0x482e, 0x26},
//	{0x4837, 0x22},

	// TODO ????
//	{0x4805, 0x00},
	////////////////////////////////////////

	{0x3632, 0xe2},
	{0x3633, 0x23},
	{0x3634, 0x44},
	{0x3621, 0xe0},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3905, 0x02},
	{0x3906, 0x10},
	{0x3901, 0x0a},
	{0x3731, 0x12},
	{0x3600, 0x04},
	{0x3601, 0x22},
	{0x471c, 0x50},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3503, 0x07},
	{0x3500, 0x00},
	{0x3501, 0x01},
	{0x3502, 0x00},
	{0x350a, 0x00},
	{0x350b, 0x3f},
	{0x3002, 0x1c},
	{0x3006, 0xc3},
	{0x300e, 0x65},
	{0x302e, 0x08},
	{0x3612, 0x4b},
	{0x3618, 0x00},
	{0x3034, 0x18},

//	{0x3036, 0x36}, // orig


	///////////// WORKING
	{0x3035, 0x21},
	{0x3036, 0x36},
	{0x3037, 0x13},
	{0x3038, 0x00},
	{0x3039, 0x00},
	///////////////////////


//	{0x3035, 0x31},
//	{0x3036, 0x54},
//	{0x3037, 0x13},

	{0x3108, 0x01},
	{0x3708, 0x64},
	{0x3709, 0x12},
	{0x370c, 0x03},

///////////// VGA scaler timings /////////////////
#if 0
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x04},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9b},
	{0x3808, 0x02},
	{0x3809, 0x80},
	{0x380a, 0x01},
	{0x380b, 0xe0},
	{0x380c, 0x07},
	{0x380d, 0x68},
	{0x380e, 0x03},
	{0x380f, 0xd8},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x06},
#endif

////////////////// 1.3M timings /////////////////////////

	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9f},
	{0x3808, 0x05},
	{0x3809, 0x00},
	{0x380a, 0x03},
	{0x380b, 0xc0},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x04},
//	{0x3814, 0x31},
//	{0x3815, 0x31},
//	{0x380c, 0x07},
//	{0x380d, 0xe0},
//	{0x380e, 0x04},
//	{0x380f, 0x40},

//////////////////////////////////


	{0x3814, 0x31},
	{0x3815, 0x31},
	{0x3820, 0x40},
	{0x3821, 0x06},
	{0x3824, 0x01},
	{0x3a02, 0x07},
	{0x3a03, 0xb0},
	{0x3a08, 0x00},
	{0x3a09, 0x94},

	{0x3a0a, 0x00},
	{0x3a0b, 0x7b},
	{0x3a0e, 0x06},
	{0x3a0d, 0x08},
	{0x3a14, 0x07},
	{0x3a15, 0xb0},
	{0x4001, 0x02},
	{0x4004, 0x06},
	{0x4300, 0x3f},
	{0x460b, 0x37},
	{0x460c, 0x20},
	{0x4713, 0x02},
	{0x4750, 0x00},
	{0x4751, 0x00},
//	{0x4837, 0x2a},
	{0x5000, 0x07},
	{0x5001, 0x03},
	{0x501d, 0x00},
	{0x501f, 0x00},
	{0x5684, 0x10},
	{0x5685, 0xa0},
	{0x5686, 0x0c},
	{0x5687, 0x78},
	{0x5a00, 0x08},
	{0x5a21, 0x00},
	{0x5a24, 0x00},
	{0x5000, 0x27},

	// TODO ROEE changed resolution
	{0x5001, 0xa3},
//	{0x5001, 0x83},

	{0x3821, 0x06},
	{0x5481, 0x08},
	{0x5482, 0x14},
	{0x5483, 0x28},
	{0x5484, 0x51},
	{0x5485, 0x65},

	{0x5486, 0x71},
	{0x5487, 0x7d},
	{0x5488, 0x87},
	{0x5489, 0x91},
	{0x548a, 0x9a},
	{0x548b, 0xaa},
	{0x548c, 0xb8},
	{0x548d, 0xcd},
	{0x548e, 0xdd},
	{0x548f, 0xea},
	{0x5490, 0x1d},
	{0x5381, 0x20},
	{0x5382, 0x64},
	{0x5383, 0x08},
	{0x5384, 0x20},
	{0x5385, 0x80},
	{0x5386, 0xa0},
	{0x5387, 0xa2},
	{0x5388, 0xa0},
	{0x5389, 0x02},
	{0x538a, 0x01},
	{0x538b, 0x98},
	{0x5300, 0x08},
	{0x5301, 0x30},
	{0x5302, 0x10},
	{0x5303, 0x00},
	{0x5304, 0x08},
	{0x5305, 0x30},
	{0x5306, 0x08},
	{0x5307, 0x16},
	{0x5580, 0x02},
	{0x5583, 0x40},
	{0x5584, 0x10},
	{0x5589, 0x10},

	{0x558a, 0x00},
	{0x558b, 0xf8},

	// ROEE
	/*495*/ {0x4800,0x24},
//	/*496*/ {0x4801,0x0c},


	{0x3a0f, 0x36},
	{0x3a10, 0x2e},
	{0x3a1b, 0x38},
	{0x3a1e, 0x2c},
	{0x3a11, 0x70},
	{0x3a1f, 0x18},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3003, 0x03},
	{0x3003, 0x01},
	{0x3008, 0x02},
	{0x3503, 0x00},


	// TODO DEBUG
//	{0x503d, 0x80},

	////////////////////////////////
//	{0x3821, 0x06},
//	{0x3824, 0x01},
//	{0x3814, 0x11},
//	{0x3815, 0x11},
//	{0x3035, 0x11},
//	{0x3618, 0x04},
//	{0x370c, 0x00},
//	{0x5001, 0x83},
//	{0x4837, 0x15},
//	{0x3803, 0x00},
//	{0x3807, 0x9f},
//	{0x3808, 0x0a},
//	{0x3809, 0x20},
//	{0x380a, 0x07},
//	{0x380b, 0x98},
//	{0x380c, 0x0b},
//	{0x380d, 0x1c},
//	{0x380e, 0x07},
//	{0x380f, 0xb0},
//	{0x4005, 0x1A},
};

/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
/////////////////////////////////////////////////////

#if 0 // OV not working
static const ov5640_reg_t ov5640_regs_mode_1_3MP[] =
{
	{0x3103, 0x11},
	{0x3008, 0x82},
	{0x3008, 0x42},
	{0x3103, 0x03},
	{0x3017, 0xff},
	{0x3018, 0xff},
	{0x3108, 0x01},
	{0x3630, 0x36},
	{0x3631, 0x0e},
	{0x3632, 0xe2},
	{0x3633, 0x12},
	{0x3621, 0xe0},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3905, 0x02},
	{0x3906, 0x10},
	{0x3901, 0x0a},
	{0x3731, 0x12},
	{0x3600, 0x08},
	{0x3601, 0x33},
	{0x302d, 0x60},
	{0x3620, 0x52},
	{0x371b, 0x20},
	{0x471c, 0x50},
	{0x3a13, 0x43},
	{0x3a18, 0x00},
	{0x3a19, 0xd0},
	{0x3635, 0x13},
	{0x3636, 0x03},
	{0x3634, 0x40},
	{0x3622, 0x01},
	{0x3c04, 0x28},
	{0x3c05, 0x98},
	{0x3c06, 0x00},
	{0x3c07, 0x08},
	{0x3c08, 0x00},
	{0x3c09, 0x1c},
	{0x3c0a, 0x9c},
	{0x3c0b, 0x40},
	{0x3820, 0x47},
	{0x3821, 0x01},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9f},
	{0x3808, 0x05},
	{0x3809, 0x00},
	{0x380a, 0x03},
	{0x380b, 0xc0},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x04},
	{0x3814, 0x31},
	{0x3815, 0x31},
	{0x380c, 0x07},
	{0x380d, 0xe0},
	{0x380e, 0x04},
	{0x380f, 0x40},
	{0x3034, 0x1a}, //clk
	{0x3035, 0x21},
	{0x3036, 0x46}, //5a
	{0x3037, 0x13},
	{0x3038, 0x00},
	{0x3039, 0x00},
	{0x460c, 0x20},
	{0x3108, 0x01},
	{0x3824, 0x02},
	{0x3c01, 0xb4},
	{0x3c00, 0x04},
	{0x3a08, 0x00},
	{0x3a09, 0x8a},
	{0x3a0e, 0x07},
	{0x3a0a, 0x00},
	{0x3a0b, 0x73},
	{0x3a0d, 0x09},
	{0x3a00, 0x78},
	{0x3a02, 0x03},
	{0x3a03, 0xd8},
	{0x3a14, 0x03},
	{0x3a15, 0xd8},
	{0x3618, 0x00},
	{0x3612, 0x29},
	{0x3708, 0x64},
	{0x3709, 0x52},
	{0x370c, 0x03},
	{0x4001, 0x02},
	{0x4004, 0x02},
	{0x3000, 0x00},
	{0x3002, 0x1c},
	{0x3004, 0xff},
	{0x3006, 0xc3},
	{0x300e, 0x58},
	{0x302e, 0x00},
	{0x4300, 0x30},
	{0x501f, 0x00},
	{0x4713, 0x03},
	{0x4407, 0x04},
	{0x440e, 0x00},
	{0x460b, 0x35},
	{0x4837, 0x22},
	{0x5001, 0x83},

	{0x5180, 0xff},  // awb
	{0x5181, 0xf3},
	{0x5182, 0x0},
	{0x5183, 0x14},
	{0x5184, 0x25},
	{0x5185, 0x24},
	{0x5186, 0xf},
	{0x5187, 0x1f},
	{0x5188, 0xc},
	{0x5189, 0x78},
	{0x518a, 0x5a},
	{0x518b, 0xff},
	{0x518c, 0xbf},
	{0x518d, 0x3c},
	{0x518e, 0x32},
	{0x518f, 0x58},
	{0x5190, 0x47},
	{0x5191, 0xf8},
	{0x5192, 0x4},
	{0x5193, 0x70},
	{0x5194, 0xf0},
	{0x5195, 0xf0},
	{0x5196, 0x3},
	{0x5197, 0x1},
	{0x5198, 0x5},
	{0x5199, 0xf6},
	{0x519a, 0x4},
	{0x519b, 0x0},
	{0x519c, 0x7},
	{0x519d, 0x7f},
	{0x519e, 0x38},

	{0x5490, 0x1d}, // gamma
	{0x5481, 0x8},
	{0x5482, 0x14},
	{0x5483, 0x28},
	{0x5484, 0x51},
	{0x5485, 0x65},
	{0x5486, 0x71},
	{0x5487, 0x7d},
	{0x5488, 0x87},
	{0x5489, 0x91},
	{0x548a, 0x9a},
	{0x548b, 0xaa},
	{0x548c, 0xb8},
	{0x548d, 0xcd},
	{0x548e, 0xdd},
	{0x548f, 0xea},

	{0x5381, 0x1c},  // cmx
	{0x5382, 0x5a},
	{0x5383, 0x6},
	{0x5384, 0x7},
	{0x5385, 0x6b},
	{0x5386, 0x72},
	{0x5387, 0x71},
	{0x5388, 0x61},
	{0x5389, 0xe},
	{0x538b, 0x98},
	{0x538a, 0x01},

	{0x5800, 0x2a}, // lens shading
	{0x5801, 0x15},
	{0x5802, 0x11},
	{0x5803, 0x11},
	{0x5804, 0x15},
	{0x5805, 0x32},
	{0x5806, 0xe},
	{0x5807, 0x9},
	{0x5808, 0x6},
	{0x5809, 0x6},
	{0x580A, 0x9},
	{0x580B, 0xf},
	{0x580C, 0xa},
	{0x580D, 0x4},
	{0x580E, 0x0},
	{0x580F, 0x0},
	{0x5810, 0x3},
	{0x5811, 0xa},
	{0x5812, 0xa},
	{0x5813, 0x4},
	{0x5814, 0x0},
	{0x5815, 0x0},
	{0x5816, 0x4},
	{0x5817, 0xb},
	{0x5818, 0xf},
	{0x5819, 0xa},
	{0x581A, 0x7},
	{0x581B, 0x7},
	{0x581C, 0x9},
	{0x581D, 0x10},
	{0x581E, 0x32},
	{0x581F, 0x17},
	{0x5820, 0x12},
	{0x5821, 0x12},
	{0x5822, 0x18},
	{0x5823, 0x3b},
	{0x5824, 0x2c},
	{0x5825, 0xa},
	{0x5826, 0xc},
	{0x5827, 0xa},
	{0x5828, 0x2a},
	{0x5829, 0xa},
	{0x582A, 0x26},
	{0x582B, 0x24},
	{0x582C, 0x26},
	{0x582D, 0x8},
	{0x582E, 0x28},
	{0x582F, 0x42},
	{0x5830, 0x40},
	{0x5831, 0x42},
	{0x5832, 0x26},
	{0x5833, 0xa},
	{0x5834, 0x26},
	{0x5835, 0x24},
	{0x5836, 0x26},
	{0x5837, 0x8},
	{0x5838, 0x6c},
	{0x5839, 0x2c},
	{0x583A, 0x2e},
	{0x583B, 0x2c},
	{0x583C, 0x48},
	{0x583D, 0xce},
	{0x5580, 0x00},  // uv adjust
	{0x5588, 0x00},
	{0x5583, 0x40},
	{0x5584, 0x18},
	{0x5589, 0x80},
	{0x558a, 0x00},
	{0x558b, 0xf8},
	{0x5308, 0x75},
	{0x5300, 0x08}, //edg
	{0x5301, 0x30},
	{0x5302, 0x20},
	{0x5303, 0x1c},
	{0x5304, 0x08},
	{0x5305, 0x30},
	{0x5306, 0x20},
	{0x5307, 0x2c},
	{0x5309, 0x08},
	{0x530a, 0x30},
	{0x530b, 0x04},
	{0x530c, 0x06},
	{0x5000, 0xa7},
	{0x5025, 0x00},
	{0x4005, 0x1a},
	{0x5688, 0x11},   //16zone
	{0x5689, 0x11},
	{0x569a, 0x31},
	{0x569b, 0x13},
	{0x569c, 0x31},
	{0x569d, 0x13},
	{0x569e, 0x11},
	{0x569f, 0x11},
	{0x583e, 0x20}, // lens shading min Q
	{0x583f, 0x08},
	{0x5840, 0x02},
	{0x5841, 0x0d},
	{0x3a0f, 0x40}, //    ;ae target
	{0x3a10, 0x38},
	{0x3a11, 0x82},
	{0x3a1b, 0x40},
	{0x3a1e, 0x38},
	{0x3a1f, 0x14},
	{0x3008, 0x02},
};
#endif

#if 1
// ROEE new
static const ov5640_reg_t ov5640_regs_mode_5MP[] =
{
	{0x3008, 0x82},
	{0x3008, 0x42},

	{0x3103, 0x03},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3630, 0x2e},

	{0x3632, 0xe2},
	{0x3633, 0x23},
	{0x3634, 0x44},
	{0x3621, 0xe0},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3905, 0x02},
	{0x3906, 0x10},
	{0x3901, 0x0a},
	{0x3731, 0x12},
	{0x3600, 0x04},
	{0x3601, 0x22},
	{0x471c, 0x50},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3503, 0x07},
	{0x3500, 0x00},
	{0x3501, 0x01},
	{0x3502, 0x00},
	{0x350a, 0x00},
	{0x350b, 0x3f},
	{0x3002, 0x1c},
	{0x3006, 0xc3},
	{0x300e, 0x65},
	{0x302e, 0x08},
	{0x3612, 0x4b},
	{0x3618, 0x00},
	{0x3034, 0x18},
	{0x3035, 0x31},
	{0x3036, 0x54},

	{0x3037, 0x13},
	{0x3108, 0x01},
	{0x3708, 0x64},
	{0x3709, 0x12},
	{0x370c, 0x03},

	///////////////////////////////////// window 5m
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9f},
	{0x3808, 0x0a},
	{0x3809, 0x20},
	{0x380a, 0x07},
	{0x380b, 0x98},
	{0x380c, 0x0b},
	{0x380d, 0x1c},
	{0x380e, 0x07},
	{0x380f, 0xb0},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x06},

	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x3820, 0x40},
	{0x3821, 0x26},
	{0x3824, 0x04},

	//////////////////////////////////////

	// just added, clock timings
//	{0x3035, 0x21},
//	{0x3036, 0x3a},
//	{0x3037, 0x13},
//	{0x3038, 0x00},
//	{0x3039, 0x00},

//	{0x3034, 0x18},
	{0x3035, 0x12},
	{0x3036, 0x44},

	//////////////////

	{0x3a02, 0x07},
	{0x3a03, 0xb0},
	{0x3a08, 0x00},
	{0x3a09, 0x94},

	{0x3a0a, 0x00},
	{0x3a0b, 0x7b},
	{0x3a0e, 0x06},
	{0x3a0d, 0x08},
	{0x3a14, 0x07},
	{0x3a15, 0xb0},
	{0x4001, 0x02},
	{0x4004, 0x06},
	{0x4300, 0x3f},
	{0x460b, 0x37},
	{0x460c, 0x20},
	{0x4713, 0x02},
	{0x4750, 0x00},
	{0x4751, 0x00},
	{0x5000, 0x07},

//	{0x5001, 0x03},
	{0x5001, 0x83},

	{0x501d, 0x00},
	{0x501f, 0x00},
	{0x5684, 0x10},
	{0x5685, 0xa0},
	{0x5686, 0x0c},
	{0x5687, 0x78},
	{0x5a00, 0x08},
	{0x5a21, 0x00},
	{0x5a24, 0x00},
	{0x5000, 0x27},

//	{0x3821, 0x26}, // not working, JPEG
	{0x3821, 0x06},

	{0x5481, 0x08},
	{0x5482, 0x14},
	{0x5483, 0x28},
	{0x5484, 0x51},
	{0x5485, 0x65},

	{0x5486, 0x71},
	{0x5487, 0x7d},
	{0x5488, 0x87},
	{0x5489, 0x91},
	{0x548a, 0x9a},
	{0x548b, 0xaa},
	{0x548c, 0xb8},
	{0x548d, 0xcd},
	{0x548e, 0xdd},
	{0x548f, 0xea},
	{0x5490, 0x1d},
	{0x5381, 0x20},
	{0x5382, 0x64},
	{0x5383, 0x08},
	{0x5384, 0x20},
	{0x5385, 0x80},
	{0x5386, 0xa0},
	{0x5387, 0xa2},
	{0x5388, 0xa0},
	{0x5389, 0x02},
	{0x538a, 0x01},
	{0x538b, 0x98},
	{0x5300, 0x08},
	{0x5301, 0x30},
	{0x5302, 0x10},
	{0x5303, 0x00},
	{0x5304, 0x08},
	{0x5305, 0x30},
	{0x5306, 0x08},
	{0x5307, 0x16},
	{0x5580, 0x02},
	{0x5583, 0x40},
	{0x5584, 0x10},
	{0x5589, 0x10},

	{0x558a, 0x00},
	{0x558b, 0xf8},

	// ROEE
	/*495*/ {0x4800,0x24},
//	/*496*/ {0x4801,0x0c},


	{0x3a0f, 0x36},
	{0x3a10, 0x2e},
	{0x3a1b, 0x38},
	{0x3a1e, 0x2c},
	{0x3a11, 0x70},
	{0x3a1f, 0x18},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3003, 0x03},
	{0x3003, 0x01},
	{0x3008, 0x02},
	{0x3503, 0x00},
};

#endif

/////////////////////////////////////////////////////////////
// AS GIVEN BY OV
#if 0
static const ov5640_reg_t ov5640_regs_mode_5MP[] =
{
	{0x3008, 0x82},
	{0x3008, 0x42},
	{0x3103, 0x03},
	{0x3017, 0x00},
	{0x3018, 0x00},
	{0x3630, 0x2e},
	{0x3632, 0xe2},
	{0x3633, 0x23},
	{0x3634, 0x44},
	{0x3621, 0xe0},
	{0x3704, 0xa0},
	{0x3703, 0x5a},
	{0x3715, 0x78},
	{0x3717, 0x01},
	{0x370b, 0x60},
	{0x3705, 0x1a},
	{0x3905, 0x02},
	{0x3906, 0x10},
	{0x3901, 0x0a},
	{0x3731, 0x12},
	{0x3600, 0x04},
	{0x3601, 0x22},
	{0x471c, 0x50},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3503, 0x07},
	{0x3500, 0x00},
	{0x3501, 0x01},
	{0x3502, 0x00},
	{0x350a, 0x00},
	{0x350b, 0x3f},
	{0x3002, 0x00},
	{0x3006, 0xff},
	{0x300e, 0x65},
	{0x302e, 0x08},
	{0x3612, 0x4b},
	{0x3618, 0x04},
	{0x3034, 0x18},

	{0x3035, 0x12},
	{0x3036, 0x54},
	{0x3708, 0x64},
	{0x3709, 0x12},
	{0x370c, 0x00},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x0a},
	{0x3805, 0x3f},
	{0x3806, 0x07},
	{0x3807, 0x9f},
	{0x3808, 0x0a},
	{0x3809, 0x20},
	{0x380a, 0x07},
	{0x380b, 0x98},
	{0x380c, 0x0b},
	{0x380d, 0x1c},
	{0x380e, 0x07},
	{0x380f, 0xb0},
	{0x3810, 0x00},
	{0x3811, 0x10},
	{0x3812, 0x00},
	{0x3813, 0x06},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x3820, 0x40},
	{0x3821, 0x26},
	{0x3824, 0x04},
	{0x3a02, 0x07},
	{0x3a03, 0xb0},
	{0x3a08, 0x01},
	{0x3a09, 0x27},
	{0x3a0a, 0x00},
	{0x3a0b, 0xf6},
	{0x3a0e, 0x06},
	{0x3a0d, 0x08},
	{0x3a14, 0x07},
	{0x3a15, 0xb0},
	{0x4001, 0x02},
	{0x4004, 0x06},
	{0x4300, 0x30},
	{0x460b, 0x35},
	{0x460c, 0x22},
	{0x4713, 0x02},
	{0x4750, 0x00},
	{0x4751, 0x00},

	{0x5000, 0x07},
	{0x5001, 0x03},
	{0x501d, 0x00},
	{0x501f, 0x00},
	{0x5684, 0x10},
	{0x5685, 0xa0},
	{0x5686, 0x0c},
	{0x5687, 0x78},
	{0x5a00, 0x08},
	{0x5a21, 0x00},
	{0x5a24, 0x00},
	{0x5000, 0x27},
	{0x5001, 0x83},
	{0x3821, 0x26},
	{0x5481, 0x08},
	{0x5482, 0x14},
	{0x5483, 0x28},
	{0x5484, 0x51},
	{0x5485, 0x65},
	{0x5486, 0x71},
	{0x5487, 0x7d},
	{0x5488, 0x87},
	{0x5489, 0x91},
	{0x548a, 0x9a},
	{0x548b, 0xaa},
	{0x548c, 0xb8},
	{0x548d, 0xcd},
	{0x548e, 0xdd},
	{0x548f, 0xea},
	{0x5490, 0x1d},
	{0x5381, 0x20},
	{0x5382, 0x64},
	{0x5383, 0x08},
	{0x5384, 0x20},
	{0x5385, 0x80},
	{0x5386, 0xa0},
	{0x5387, 0xa2},
	{0x5388, 0xa0},
	{0x5389, 0x02},
	{0x538a, 0x01},
	{0x538b, 0x98},
	{0x5300, 0x08},
	{0x5301, 0x30},
	{0x5302, 0x10},
	{0x5303, 0x00},
	{0x5304, 0x08},
	{0x5305, 0x30},
	{0x5306, 0x08},


	{0x5307, 0x16},
	{0x5580, 0x02},
	{0x5583, 0x40},
	{0x5584, 0x10},
	{0x5589, 0x10},
	{0x558a, 0x00},
	{0x558b, 0xf8},
	{0x3a0f, 0x36},
	{0x3a10, 0x2e},
	{0x3a1b, 0x38},
	{0x3a1e, 0x2c},
	{0x3a11, 0x70},
	{0x3a1f, 0x18},
	{0x3a18, 0x00},
	{0x3a19, 0xf8},
	{0x3003, 0x03},
	{0x3003, 0x01},
	{0x3008, 0x02},
	{0x3503, 0x00},
};
#endif

/**********************************
 * sensor configuration
 **********************************/

/* OV5640 modes */
const static ov5640_mode_t ov5640_modes[] =
{
#if 1
    /* VGA */
	{
		.width    = 640,
		.height   = 480,

		.name     = "OV5640_RESOLUTION_VGA",

		.reg_list = ov5640_regs_mode_VGA,
		.num_regs = array_size( ov5640_regs_mode_VGA ),
	},
#endif
#if 1
    /* 1.3MP */
	{
		.width    = 1280,
		.height   = 960,
		.name     = "OV5640_RESOLUTION_1.3MP",
		.reg_list = ov5640_regs_mode_1_3MP,
		.num_regs = array_size( ov5640_regs_mode_1_3MP )
	},
#endif
#if 1
    /* 5MP */
	{
		.width    = 2592,
		.height   = 1944,

		.name     = "OV5640_RESOLUTION_5MP",
		.reg_list = ov5640_regs_mode_5MP,
		.num_regs = array_size( ov5640_regs_mode_5MP )
	},
#endif
};

#define OV5640_NUM_MODES array_size( ov5640_modes )

//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

const struct v4l2_fract ov5640_frameintervals[] = {
	{ .numerator = 1, .denominator = 3 },
	{ .numerator = 2, .denominator = 15 },
	{ .numerator = 1, .denominator = 11 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 20 },
	{ .numerator = 1, .denominator = 25 },

	{ .numerator = 1, .denominator = 30 },
};

static const char* frame_rate_tostring(unsigned int frame_rate)
{
	switch (frame_rate)
	{
		case	OV5640_3_FPS:
			return "OV5640_3_FPS";
		case	OV5640_7_5_FPS:
			return "OV5640_7_5_FPS";
		case	OV5640_11_FPS:
			return "OV5640_11_FPS";
		case	OV5640_15_FPS:
			return "OV5640_15_FPS";
		case	OV5640_20_FPS:
			return "OV5640_20_FPS";
		case	OV5640_25_FPS:
			return "OV5640_25_FPS";
		case	OV5640_30_FPS:
			return "OV5640_30_FPS";
		default:
				return "INVALID";
	}
}

/* List of image formats supported by OV5640 sensor */
const static struct v4l2_fmtdesc ov5640_formats[] = {
#if OV5640_RAW_MODE
       {
               .description    = "RAW10",
               .pixelformat    = V4L2_PIX_FMT_SGRBG10,
       },
#else
	   {
               /* Note:  V4L2 defines FMT_NV16 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 u0v0u1v1
                */
		       .description    = "Y/CbCr, 4:2:2",
               .pixelformat    = V4L2_PIX_FMT_NV16,
	   },

	   // TODO not supported in MIPI???
#if 0
	   {
               /* Note:  V4L2 defines FMT_NV61 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 v0u0v1u1
                */
		       .description    = "Y/CrCb, 4:2:2",
               .pixelformat    = V4L2_PIX_FMT_NV61,
	   },

	   {
               /* Note:  V4L2 defines FMT_NV12 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 u0v0
                */
		       .description    = "Y/CbCr, 4:2:0",
               .pixelformat    = V4L2_PIX_FMT_NV12,
	   },
	   {
               /* Note:  V4L2 defines FMT_NV12 as:
                *	Two planes -- one Y, one Cr + Cb interleaved
                *   y0y1y2y3 v0u0
                */
		       .description    = "Y/CrCb, 4:2:0",
               .pixelformat    = V4L2_PIX_FMT_NV21,
	   },
       {
               /* Note:  V4L2 defines RGB565 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 r4 r3 r2 r1 r0   b4 b3 b2 b1 b0 g5 g4 g3
                *
                * We interpret RGB565 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 b4 b3 b2 b1 b0   r4 r3 r2 r1 r0 g5 g4 g3
                */
               .description    = "RGB565, le",
               .pixelformat    = V4L2_PIX_FMT_RGB565,
       },
       {
               /* Note:  V4L2 defines RGB565X as:
                *
                *      Byte 0                    Byte 1
                *      b4 b3 b2 b1 b0 g5 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
                *
                * We interpret RGB565X as:
                *
                *      Byte 0                    Byte 1
                *      r4 r3 r2 r1 r0 g5 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
                */
               .description    = "RGB565, be",
               .pixelformat    = V4L2_PIX_FMT_RGB565X,
       },
       {
               .description    = "YUYV (YUV 4:2:2), packed",
               .pixelformat    = V4L2_PIX_FMT_YUYV,
       },
       {
               .description    = "UYVY, packed",
               .pixelformat    = V4L2_PIX_FMT_UYVY,
       },
       {
               /* Note:  V4L2 defines RGB555 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 r4 r3 r2 r1 r0   x  b4 b3 b2 b1 b0 g4 g3
                *
                * We interpret RGB555 as:
                *
                *      Byte 0                    Byte 1
                *      g2 g1 g0 b4 b3 b2 b1 b0   x  r4 r3 r2 r1 r0 g4 g3
                */
               .description    = "RGB555, le",
               .pixelformat    = V4L2_PIX_FMT_RGB555,
       },
       {
               /* Note:  V4L2 defines RGB555X as:
                *
                *      Byte 0                    Byte 1
                *      x  b4 b3 b2 b1 b0 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
                *
                * We interpret RGB555X as:
                *
                *      Byte 0                    Byte 1
                *      x  r4 r3 r2 r1 r0 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
                */
               .description    = "RGB555, be",
               .pixelformat    = V4L2_PIX_FMT_RGB555X,
       },
#endif
#endif
};

#define NUM_CAPTURE_FORMATS array_size( ov5640_formats )
#define NUM_TIMEFRAME_VALS  array_size( ov5640_frameintervals )


const static ov5640_reg_t ov5640_common[] =
{
	{OV5640_REG_TERM, OV5640_VAL_TERM},
};

const static ov5640_reg_t ov5640_standby_on[] =
{
 	{0x300e, 0x18},
	{OV5640_REG_TERM , OV5640_VAL_TERM},
};

const static ov5640_reg_t ov5640_standby_off[] =
{
 	{0x300e, 0x45},
	{OV5640_REG_TERM, OV5640_VAL_TERM},
};

/**
 * struct ov5640_sensor - main structure for storage of sensor information
 * @cam_port: camera port to which we're connected
 * @v4l2_int_device: V4L2 device structure structure
 * @pix: V4L2 pixel format information structure
 * @timeperframe: time per frame expressed as V4L fraction
 * @isize: base image size
 * @ver: ov5640 chip version
 * @width: configured width
 * @height: configuredheight
 * @vsize: vertical size for the image
 * @hsize: horizontal size for the image
 * @crop_rect: crop rectangle specifying the left,top and width and height
 */
struct ov5640_sensor
{
       struct dmw_camera_port_s * cam_port;
       struct v4l2_int_device *	  v4l2_int_device;
       struct v4l2_pix_format 	  pix;
       struct v4l2_fract 		  timeperframe;
       const ov5640_mode_t * 	  mode;
       int 						  ver;
       int 						  fps;
       unsigned long 			  vsize;
       unsigned long 			  hsize;
       struct v4l2_rect 		  crop_rect;
	   unsigned int 			  vflip;
	   unsigned int 			  hflip;
       int 						  state;
};

static struct ov5640_sensor ov5640;
static unsigned long xclk_current = OV5640_XCLK_MIN;

/* Brightness Settings - 7 levels */
const static ov5640_reg_t brightness[7][5] =
{
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
};

/* Contrast Settings - 7 levels */
const static ov5640_reg_t contrast[7][5] =
{
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
};

/* Color Settings - 3 colors */
const static ov5640_reg_t colors[3][5] =
{
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
};

/* Average Based Algorithm - Based on target Luminance */
const static ov5640_reg_t exposure_avg[11][5] =
{
       /* -1.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -1.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -1.0EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -0.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -0.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* default */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 0.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 0.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.0EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
};

/* Histogram Based Algorithm - Based on histogram and probability */
const static ov5640_reg_t exposure_hist[11][5] =
{
       /* -1.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -1.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -1.0EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -0.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* -0.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* default */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 0.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 0.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.0EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.3EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
       /* 1.7EV */
       {
               {OV5640_REG_TERM, OV5640_VAL_TERM}
       },
};


/*
 * struct vcontrol - Video controls
 * @v4l2_queryctrl: V4L2 VIDIOC_QUERYCTRL ioctl structure
 * @current_value: current value of this control
 */
static struct vcontrol
{
       struct v4l2_queryctrl qc;
       int current_value;
} video_control[] =
{
       {
               {
               .id = V4L2_CID_BRIGHTNESS,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Brightness",
               .minimum = OV5640_MIN_BRIGHT,
               .maximum = OV5640_MAX_BRIGHT,
               .step = OV5640_BRIGHT_STEP,
               .default_value = OV5640_DEF_BRIGHT,
               },
       .current_value = OV5640_DEF_BRIGHT,
       },
       {
               {
               .id = V4L2_CID_CONTRAST,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Contrast",
               .minimum = OV5640_MIN_CONTRAST,
               .maximum = OV5640_MAX_CONTRAST,
               .step = OV5640_CONTRAST_STEP,
               .default_value = OV5640_DEF_CONTRAST,
               },
       .current_value = OV5640_DEF_CONTRAST,
       },
       {
               {
               .id = V4L2_CID_PRIVATE_BASE,
               .type = V4L2_CTRL_TYPE_INTEGER,
               .name = "Color Effects",
               .minimum = OV5640_MIN_COLOR,
               .maximum = OV5640_MAX_COLOR,
               .step = OV5640_COLOR_STEP,
               .default_value = OV5640_DEF_COLOR,
               },
       .current_value = OV5640_DEF_COLOR,
       },
	   {
               {
               .id = V4L2_CID_VFLIP,
               .type = V4L2_CTRL_TYPE_BOOLEAN,
               .name = "Vertical Flip",
               .default_value = OV5640_DEF_FLIP,
               },
       .current_value = OV5640_DEF_FLIP,
       },
	   {
               {
               .id = V4L2_CID_HFLIP,
               .type = V4L2_CTRL_TYPE_BOOLEAN,
               .name = "Horizontal Flip (Mirror)",
               .default_value = OV5640_DEF_FLIP,
               },
       .current_value = OV5640_DEF_FLIP,
       }
};

/* check if a resolution is supported by the sensor */
static int check_if_res_supported( unsigned long width, unsigned long height )
{
	printk( KERN_ERR "req: %lux%lu avail: %lux%lu\n", width, height, ov5640_modes[OV5640_NUM_MODES - 1].width, ov5640_modes[OV5640_NUM_MODES - 1].height );
	if ( (width > ov5640_modes[OV5640_NUM_MODES - 1].width) || (height > ov5640_modes[OV5640_NUM_MODES - 1].height) )
	{
		return -EINVAL;
	}

	return 0;
}

/*
 * find_vctrl - Finds the requested ID in the video control structure array
 * @id: ID of control to search the video control array.
 *
 * Returns the index of the requested ID from the control structure array
 */
static int find_vctrl( int id )
{
	int i = 0;

	if ( id < V4L2_CID_BASE )
		return -EDOM;

	for ( i = (ARRAY_SIZE( video_control ) - 1); i >= 0; i-- )
		if ( video_control[i].qc.id == id )
			break;
	if ( i < 0 )
		i = -EINVAL;
	return i;
}

/*
 * Read a value from a register in ov5640 sensor device.
 * The value is returned in 'val'.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5640_read_reg( struct i2c_client * client, u16 data_length, u16 reg, unsigned long * val )
{
	int err = 0;
	struct i2c_msg msg[2];
	unsigned char data[4];

	if ( !client || !client->adapter )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}

	msg[0].addr = client->addr;
	msg[0].flags = I2C_M_WR;
	msg[0].len = 2;
	msg[0].buf = data;

	msg[1].addr = client->addr;
	msg[1].flags = I2C_M_RD;
	msg[1].len = data_length;
	msg[1].buf = data;

	/* High byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);

	err = i2c_transfer( client->adapter, msg, 2 );
	if ( err >= 0 )
	{
		*val = 0;
		/* High byte comes first */
		if ( data_length == 1 )
			*val = data[0];
		else if ( data_length == 2 )
			*val = data[1] + (data[0] << 8);
		else
			*val = data[3] + (data[2] << 8) + (data[1] << 16) + (data[0] << 24);

		return 0;
	}
	PDEBUG( "read from offset 0x%x error %d\n", reg, err );
	return err;
}

/* Write a value to a register in ov5640 sensor device.
 * @client: i2c driver client structure.
 * @reg: Address of the register to read value from.
 * @val: Value to be written to a specific register.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5640_write_reg( struct i2c_client * client, u16 reg, u8 val )
{
	int err = 0;
	struct i2c_msg msg[1];
	unsigned char data[3];
	int retries = 0;

	if ( !client || !client->adapter )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}
	//	PDEBUG("__78 %x %x\n",reg,val);
	retry: msg->addr = client->addr;
	msg->flags = I2C_M_WR;
	msg->len = 3;
	msg->buf = data;

	/* high byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);
	data[2] = val;

	err = i2c_transfer( client->adapter, msg, 1 );
	udelay(50);

	if ( err >= 0 )
		return 0;

	if ( retries <= 5 )
	{
		dev_dbg(&client->dev, "Retrying I2C... %d", retries);
		retries++;
		set_current_state( TASK_UNINTERRUPTIBLE );
		schedule_timeout( msecs_to_jiffies( 20 ) );
		goto retry;
	}

	return err;
}

/*
 * Initialize a list of ov5640 registers.
 * The list of registers is terminated by the pair of values
 * {OV5640_REG_TERM, OV5640_VAL_TERM}.
 * @client: i2c driver client structure.
 * @reglist[]: List of address of the registers to write data.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov5640_write_regs( const ov5640_reg_t * reglist )
{
	int err = 0;
	const ov5640_reg_t *next;
	struct i2c_client * client;

	/* get i2c */
	client = dmw_camera_get_i2c( ov5640.cam_port,
								 &ov5640_sensor_desc );

	if ( !client )
	{
		return -EIO;
	}

	if ( !reglist )
	{
		dmw_camera_put_i2c( ov5640.cam_port );
		PDEBUG("Invalid input\n");
		return -1;
	}

	next = reglist;

	while ( next && !((next->reg == OV5640_REG_TERM) && (next->val == OV5640_VAL_TERM)) )
	{
		err = ov5640_write_reg( client, next->reg, next->val );
		udelay(100);
		if ( err )
		{
			dmw_camera_put_i2c( ov5640.cam_port );
			return err;
		}

		next++;
	}

	dmw_camera_put_i2c( ov5640.cam_port );
	return 0;
}

/* initialize sensor */
static int ov5640_init_sensor( const ov5640_mode_t * mode )
{
	s32 i = 0;
	int retval = 0;
	struct i2c_client * c;

	/* get i2c */
	c = dmw_camera_get_i2c( ov5640.cam_port,
				 	 	 	&ov5640_sensor_desc );

	if ( !c )
	{
		return -EIO;
	}

	if ( !mode )
	{
		dmw_camera_put_i2c( ov5640.cam_port );
		pr_err( "Wrong ov5640 mode\n" );
		return -EINVAL;
	}

	PDEBUG("mode = %s\n", mode->name);

	for ( i = 0; i < mode->num_regs; i++ )
	{
		retval = ov5640_write_reg( c, mode->reg_list[i].reg, mode->reg_list[i].val );

		if ( retval < 0 )
		{
			dmw_camera_put_i2c( ov5640.cam_port );
			return retval;
		}

//		printk( "setting 0x%lx: 0x%lx\n", mode->reg_list[i].reg, mode->reg_list[i].val );
//		mdelay( 1 );
	}


	// TODO DEBUG
//	for ( i = 0; i < mode->num_regs; i++ )
//	{
//		int temp;
//
//		retval = ov5640_read_reg( c, 1, mode->reg_list[i].reg, &temp );
//
//		if ( retval < 0 )
//		{
//			dmw_camera_put_i2c( ov5640.cam_port );
//			return retval;
//		}
//
//		printk( "reading 0x%lx: 0x%lx (0x%lx) %s\n", mode->reg_list[i].reg, temp, mode->reg_list[i].val, (mode->reg_list[i].val != temp) ? "!!!!!!!!!" : "" );
//		mdelay( 1 );
//	}

	dmw_camera_put_i2c( ov5640.cam_port );
	return retval;
}

static void ov5640_set_flip( void )
{
	PDEBUG("Hflip is %s  Vflip is %s\n", ((ov5640.hflip == 1) ? "On" : "Off") , ((ov5640.vflip == 1) ? "On" : "Off") );
	PDEBUG("%s\n",__func__);
#if 0
	ov5640_read_reg(client,1, 0x12, &regval);

	if (ov5640.hflip)
	ov5640_write_reg(client, 0x12, regval | (1<<5));
	else
	ov5640_write_reg(client, 0x12, regval & ~(1<<5));

	if (ov5640.vflip)
	ov5640_write_reg(client, 0x12, regval | (1<<4));
	else
	ov5640_write_reg(client, 0x12, regval & ~(1<<4));
#endif
}

static int ov5640_set_v_flip( unsigned int val )
{
	PDEBUG("%s\n",__func__);
	ov5640.vflip = ((val > 0) ? 1 : 0);

	ov5640_set_flip();

	return 0;
}

static int ov5640_set_h_flip( unsigned int val )
{
	PDEBUG("%s\n",__func__);
	ov5640.hflip = ((val > 0) ? 1 : 0);

	ov5640_set_flip();

	return 0;
}

/* Find the best match for a requested image capture size.  The best match
 * is chosen as the nearest match that has the same number or fewer pixels
 * as the requested size, or the smallest image size if the requested size
 * has fewer pixels than the smallest image.
 */
static const ov5640_mode_t * ov5640_find_mode( unsigned int width, unsigned int height )
{
	int i;
	const ov5640_mode_t * mode;

	for ( i = 0; i < OV5640_NUM_MODES; i++ )
	{
		mode = &(ov5640_modes[i]);

		/* if found a match */
		if ( (mode->height == height) && (mode->width == width) )
		{
			return mode;
		}
	}

	/* no match */
	return NULL;
}

static int set_frame_rate( struct v4l2_int_device *s, unsigned long xclk )
{
	struct ov5640_sensor *sensor;
	int res = 0;

	if ( !s || !s->priv )
		return -1;

	sensor = s->priv;
	res = dmw_camera_port_clock_ctl( sensor->cam_port,
									 xclk );
	if ( !res )
	{
		xclk_current = xclk;
	}
	return res;
}

// TODO
static int switch_fps( struct v4l2_fract *a, struct v4l2_int_device *s, enum ov5640_frameintervals_type* fps )
{
	unsigned int i = 0;
	unsigned int val;
	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	PDEBUG("Try to set FPS to denominator=%d numerator=%d \n",a->denominator ,a->numerator );

	for ( i = 0; i < NUM_TIMEFRAME_VALS; i++ )
	{

		PDEBUG("Check FPS to denominator=%d numerator=%d \n", ov5640_frameintervals[i].denominator , ov5640_frameintervals[i].numerator);

		if ( (a->denominator == ov5640_frameintervals[i].denominator) && (a->numerator == ov5640_frameintervals[i].numerator) )
		{
			switch ( i )
			{
			case OV5640_3_FPS:
				*fps = OV5640_3_FPS;
				PDEBUG("setting 3 FPS\n");
				break;
			case OV5640_7_5_FPS:
				*fps = OV5640_7_5_FPS;
				PDEBUG("setting 7.5 FPS\n");
				break;
			case OV5640_11_FPS:
				*fps = OV5640_11_FPS;
				PDEBUG("setting 11 FPS\n");
				break;
			case OV5640_15_FPS:
				*fps = OV5640_15_FPS;
				PDEBUG("setting 15 FPS\n");
				break;
			case OV5640_20_FPS:
				*fps = OV5640_20_FPS;
				PDEBUG("setting 20 FPS\n");
				break;
			case OV5640_25_FPS:
				*fps = OV5640_25_FPS;
				PDEBUG("setting 25 FPS\n");
				break;
			case OV5640_30_FPS:
				*fps = OV5640_30_FPS;
				PDEBUG("setting 30 FPS\n");
				break;
			default:
				PDEBUG("Non existed set to 15 FPS as default\n");
				*fps = OV5640_15_FPS;
			}
			break;
		}
	}

	if ( i == NUM_TIMEFRAME_VALS )
	{
		PDEBUG("Invalid frame interval\n");
		return -1;
	}

	val = ((OV5640_XCLK_MAX * ov5640_frameintervals[*fps].denominator) / ov5640_frameintervals[*fps].numerator) / 30;

	PDEBUG("frame_rate=%s denominator=%d numerator=%d OV5640_XCLK_MAX=%d val=%d\n",
			frame_rate_tostring(*fps), ov5640_frameintervals[*fps].denominator , ov5640_frameintervals[*fps].numerator,
			OV5640_XCLK_MAX, val);

	// TODO ROEE
	printk( KERN_ERR "frame_rate=%s denominator=%d numerator=%d OV5640_XCLK_MAX=%d val=%d\n",
			frame_rate_tostring(*fps), ov5640_frameintervals[*fps].denominator , ov5640_frameintervals[*fps].numerator,
			OV5640_XCLK_MAX, val);

	set_frame_rate( s, val );

	return 0;
}

static int ov5640_configure( struct v4l2_int_device *s )
{
	struct ov5640_sensor *sensor = NULL;
	struct v4l2_pix_format *pix = NULL;
	enum ov5640_frameintervals_type frame_rate = OV5640_30_FPS;
	int err = 0;

	if ( s && s->priv )
	{
		sensor = s->priv;

		pix = &sensor->pix;
	}

	if ( !sensor || !pix  )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	// TODO DEBUG
	printk( KERN_ERR "OV5640: configuring sensor for %dx%d\n", pix->width, pix->height );

	/* find a matching sensor mode */
	sensor->mode = ov5640_find_mode( pix->width, pix->height );

	if ( !sensor->mode )
		return err;

	ov5640_init_sensor( sensor->mode );

	switch_fps( &sensor->timeperframe, s, &frame_rate );

	//ov5640_set_flip(client);

	sensor->crop_rect.left = 0;
	sensor->crop_rect.width = pix->width;
	sensor->crop_rect.top = 0;
	sensor->crop_rect.height = pix->height;

	return 0;
}

/* Detect if an ov5640 is present, returns a negative error number if no
 * device is detected, or pidl as version number if a device is detected.
 */
static int ov5640_detect( void )
{
	unsigned long pidh = 0, pidl = 0;
	struct i2c_client *client;

	PDEBUG("%s\n",__func__);

	client = dmw_camera_get_i2c( ov5640.cam_port,
				 	 	 	 	 &ov5640_sensor_desc );

	if ( !client )
	{
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}

	if ( ov5640_read_reg( client, 1, OV5640_PIDH, &pidh ) )
	{
		dmw_camera_put_i2c( ov5640.cam_port );
		return -ENODEV;
	}

	if ( ov5640_read_reg( client, 1, OV5640_PIDL, &pidl ) )
	{
		dmw_camera_put_i2c( ov5640.cam_port );
		return -ENODEV;
	}

	dmw_camera_put_i2c( ov5640.cam_port );

	if ( (pidh == OV5640_PIDH_MAGIC) && (pidl == OV5640_PIDL_MAGIC) )
	{
		PDEBUG( "Detected\n" );
		return 0;
	}

	return -ENODEV;
}

/* To get the cropping capabilities of ov5640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_cropcap( struct v4l2_int_device *s, struct v4l2_cropcap *cropcap )
{
	return -EINVAL;
}

/* To get the current crop window for of ov5640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_g_crop( struct v4l2_int_device *s, struct v4l2_crop *crop )
{
	struct ov5640_sensor *sensor;

	// TODO ROEE
	return -EINVAL;

	if ( !s || !crop )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;

	crop->c = sensor->crop_rect;
	return 0;
}

/* To set the crop window for of ov5640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_s_crop( struct v4l2_int_device *s, struct v4l2_crop *crop )
{
	return -EINVAL;
}

/*
 * ioctl_queryctrl - V4L2 sensor interface handler for VIDIOC_QUERYCTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @qc: standard V4L2 VIDIOC_QUERYCTRL ioctl structure
 *
 * If the requested control is supported, returns the control information
 * from the video_control[] array.  Otherwise, returns -EINVAL if the
 * control is not supported.
 */
static int ioctl_queryctrl( struct v4l2_int_device *s, struct v4l2_queryctrl *qc )
{
	int i;

	if ( !s || !qc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl( qc->id );
	if ( i == -EINVAL )
		qc->flags = V4L2_CTRL_FLAG_DISABLED;

	if ( i < 0 )
		return -EINVAL;

	*qc = video_control[i].qc;
	return 0;
}

/*
 * ioctl_g_ctrl - V4L2 sensor interface handler for VIDIOC_G_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_G_CTRL ioctl structure
 *
 * If the requested control is supported, returns the control's current
 * value from the video_control[] array.  Otherwise, returns -EINVAL
 * if the control is not supported.
 */

static int ioctl_g_ctrl( struct v4l2_int_device * s, struct v4l2_control * vc )
{
	struct vcontrol *lvc;
	int i = 0;

	if ( !s || !vc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl( vc->id );

	if ( i < 0 )
		return -EINVAL;

	lvc = &video_control[i];

	switch ( vc->id )
	{
	case V4L2_CID_BRIGHTNESS:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_CONTRAST:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_PRIVATE_BASE:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_VFLIP:
		vc->value = lvc->current_value;
		break;
	case V4L2_CID_HFLIP:
		vc->value = lvc->current_value;
		break;
	}

	return 0;
}

/*
 * ioctl_s_ctrl - V4L2 sensor interface handler for VIDIOC_S_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_S_CTRL ioctl structure
 *
 * If the requested control is supported, sets the control's current
 * value in HW (and updates the video_control[] array).  Otherwise,
 * returns -EINVAL if the control is not supported.
 */
static int ioctl_s_ctrl( struct v4l2_int_device * s, struct v4l2_control * vc )
{

	int retval = -EINVAL;
	int i = 0;
	struct ov5640_sensor *sensor;
	struct vcontrol *lvc;

	PDEBUG("%s\n",__func__);

	if ( !s || !vc )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	i = find_vctrl( vc->id );
	if ( i < 0 )
	{
		return -EINVAL;
	}

	lvc = &video_control[i];

	switch ( vc->id )
	{
	case V4L2_CID_BRIGHTNESS:
		if ( vc->value >= 0 && vc->value <= 6 )
		{
			retval = ov5640_write_regs( brightness[vc->value] );
		}
		else
		{
			PDEBUG( "BRIGHTNESS LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_CONTRAST:
		if ( vc->value >= 0 && vc->value <= 6 )
		{
			retval = ov5640_write_regs( contrast[vc->value] );
		}
		else
		{
			PDEBUG( "CONTRAST LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_PRIVATE_BASE:
		if ( vc->value >= 0 && vc->value <= 2 )
		{
			retval = ov5640_write_regs( colors[vc->value] );
		}
		else
		{
			PDEBUG( "COLOR LEVEL NOT SUPPORTED\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_VFLIP:
		if ( vc->value >= 0 )
		{

			unsigned int val = 0;
			val = (vc->value > 0) ? 1 : 0;
			retval = ov5640_set_v_flip( val );
		}
		else
		{
			PDEBUG( "VERTIVCAL FLIP INVALID VALUE\n" );
			return -EINVAL;
		}
		break;

	case V4L2_CID_HFLIP:
		if ( vc->value >= 0 )
		{
			unsigned int val = 0;
			val = (vc->value > 0) ? 1 : 0;
			retval = ov5640_set_h_flip( val );
		}
		else
		{
			PDEBUG( "HORIZONTAL FLIP INVALID VALUE\n" );
			return -EINVAL;
		}
		break;
	}

	if ( !retval )
		lvc->current_value = vc->value;

	return retval;
}

/*
 * ioctl_enum_fmt_cap - Implement the CAPTURE buffer VIDIOC_ENUM_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @fmt: standard V4L2 VIDIOC_ENUM_FMT ioctl structure
 *
 * Implement the VIDIOC_ENUM_FMT ioctl for the CAPTURE buffer type.
 */
static int ioctl_enum_fmt_cap( struct v4l2_int_device * s, struct v4l2_fmtdesc * fmt )
{
	int index = 0;
	enum v4l2_buf_type type;

	if ( !s || !fmt )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	index = fmt->index;
	type = fmt->type;

	memset( fmt, 0, sizeof(*fmt) );
	fmt->index = index;
	fmt->type = type;

	switch ( fmt->type )
	{
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
		if ( index >= NUM_CAPTURE_FORMATS )
			return -EINVAL;
		break;

	default:
		return -EINVAL;
	}

	fmt->flags = ov5640_formats[index].flags;
	strlcpy( fmt->description, ov5640_formats[index].description, sizeof(fmt->description) );
	fmt->pixelformat = ov5640_formats[index].pixelformat;

	return 0;
}

/*
 * ioctl_try_fmt_cap - Implement the CAPTURE buffer VIDIOC_TRY_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_TRY_FMT ioctl structure
 *
 * Implement the VIDIOC_TRY_FMT ioctl for the CAPTURE buffer type.  This
 * ioctl is used to negotiate the image capture size and pixel format
 * without actually making it take effect.
 */

static int ioctl_try_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	int ifmt = 0;
	int ret;
	struct v4l2_pix_format *pix;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	pix = &f->fmt.pix;

	/* check resolution */
	ret = check_if_res_supported( pix->width, pix->height );

	if ( ret )
	{
		return ret;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( pix->pixelformat == ov5640_formats[ifmt].pixelformat )
			break;
	}

	/* if no matching pixel format is found */
	if ( ifmt == NUM_CAPTURE_FORMATS )
	{
		return -EINVAL;
	}

	pix->pixelformat = ov5640_formats[ifmt].pixelformat;
	pix->field = V4L2_FIELD_NONE;
	pix->bytesperline = bytes_per_line( pix->width, pix->pixelformat );
	pix->sizeimage = image_size( pix->width, pix->height, pix->pixelformat );
	pix->priv = 0;

	switch ( pix->pixelformat )
	{
	case V4L2_PIX_FMT_NV16:
	case V4L2_PIX_FMT_NV61:
	case V4L2_PIX_FMT_NV12:
	case V4L2_PIX_FMT_NV21:
	case V4L2_PIX_FMT_YUYV:
	case V4L2_PIX_FMT_UYVY:
	default:
		pix->colorspace = V4L2_COLORSPACE_JPEG;
		break;

	case V4L2_PIX_FMT_SGRBG10:
	case V4L2_PIX_FMT_RGB565:
	case V4L2_PIX_FMT_RGB565X:
	case V4L2_PIX_FMT_RGB555:
	case V4L2_PIX_FMT_RGB555X:
		pix->colorspace = V4L2_COLORSPACE_SRGB;
		break;
	}

	return 0;
}

/*
 * ioctl_s_fmt_cap - V4L2 sensor interface handler for VIDIOC_S_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_S_FMT ioctl structure
 *
 * If the requested format is supported, configures the HW to use that
 * format, returns error code if format not supported or HW can't be
 * correctly configured.
 */
static int ioctl_s_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	struct ov5640_sensor *sensor;
	struct v4l2_pix_format *pix;
	int rval = 0;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;
	pix = &f->fmt.pix;

	/* check that the format is valid */
	rval = ioctl_try_fmt_cap( s, f );

	if ( rval )
	{
		return rval;
	}

	/* set new format */
	sensor->pix = *pix;

	/* configure sensor for new format */
	ov5640_configure( s );

	return 0;
}

/*
 * ioctl_g_fmt_cap - V4L2 sensor interface handler for ioctl_g_fmt_cap
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 v4l2_format structure
 *
 * Returns the sensor's current pixel format in the v4l2_format
 * parameter.
 */
static int ioctl_g_fmt_cap( struct v4l2_int_device * s, struct v4l2_format * f )
{
	struct ov5640_sensor *sensor;

	if ( !s || !f )
	{
		PDEBUG("Invalid input\n");
		return -EINVAL;
	}

	sensor = s->priv;
	f->fmt.pix = sensor->pix;

	return 0;
}

/*
 * ioctl_g_parm - V4L2 sensor interface handler for VIDIOC_G_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_G_PARM ioctl structure
 *
 * Returns the sensor's video CAPTURE parameters.
 */
static int ioctl_g_parm( struct v4l2_int_device * s, struct v4l2_streamparm * a )
{
	struct ov5640_sensor *sensor;
	struct v4l2_captureparm *cparm;

	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	cparm = &a->parm.capture;

	if ( a->type != V4L2_BUF_TYPE_VIDEO_CAPTURE )
		return -EINVAL;

	memset( a, 0, sizeof(*a) );
	a->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

	cparm->capability = V4L2_CAP_TIMEPERFRAME;
	cparm->timeperframe = sensor->timeperframe;

	return 0;
}

/*
 * ioctl_s_parm - V4L2 sensor interface handler for VIDIOC_S_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_S_PARM ioctl structure
 *
 * Configures the sensor to use the input parameters, if possible.  If
 * not possible, reverts to the old parameters and returns the
 * appropriate error code.
 */
static int ioctl_s_parm( struct v4l2_int_device * s, struct v4l2_streamparm * a )
{
	int rval = 0;
	struct ov5640_sensor *sensor;
	struct v4l2_fract *timeperframe;
	struct v4l2_fract timeperframe_old;
	int desired_fps = 0;
	enum ov5640_frameintervals_type fps = 0;

	PDEBUG("%s\n",__func__);

	if ( !s || !a )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	timeperframe = &a->parm.capture.timeperframe;
	timeperframe_old = sensor->timeperframe;
	sensor->timeperframe = *timeperframe;

	desired_fps = timeperframe->denominator / timeperframe->numerator;
	PDEBUG("desired_fps = %d denominator=%d numerator=%d \n",desired_fps , timeperframe->denominator , timeperframe->numerator );
	if ( (desired_fps < OV5640_MIN_FPS) || (desired_fps > OV5640_MAX_FPS) )
		return (-EINVAL);

	//	   if (sensor->mode->width > ov5640_resolutions[HD720P].width || sensor->mode->height > ov5640_resolutions[HD720P].height) {
	//               if (desired_fps > OV5640_MAX_FPS)
	//                       return -EINVAL;
	//       }

	rval = switch_fps( timeperframe, s, &fps );

	if ( rval )
		sensor->timeperframe = timeperframe_old;
	else
		*timeperframe = sensor->timeperframe;

	return rval;
}

/*
 * ioctl_g_priv - V4L2 sensor interface handler for vidioc_int_g_priv_num
 * @s: pointer to standard V4L2 device structure
 * @p: void pointer to hold sensor's private data address
 *
 * Returns device's (sensor's) private data area address in p parameter
 * We need the configure since we close the clk when going to Standby mode.
 */
static int ioctl_g_priv( struct v4l2_int_device * s, void * p )
{
	struct ov5640_sensor *sensor;
	if ( !s || !p )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}
	sensor = s->priv;

	/* copy data */
	memcpy( p,
			&(sensor->cam_port->hw_config),
			sizeof( struct dmw96cam_hw_config ) );

	return 0;
}

/*
 * reset_ov5640_to_default
 * @s: pointer to standard V4L2 device structure
 * Sets reset the device to default
 */
static void reset_ov5640_to_default( struct v4l2_int_device * s )
{
#if 0
	struct ov5640_sensor *sensor = s->priv;
	int reg;

	/* Reset */
	ov5640_write_reg(c, OV5640_SYS, 0x80);
	mdelay(10);

	reg = 0x1f;
	if (sensor->pdata->output_drive_capability)
	reg |= (sensor->pdata->output_drive_capability & 0x3) << 6;
	ov5640_write_reg(c, 0xc3, reg);
	ov5640_write_regs (c, ov5640_common);
#endif

	PDEBUG("SENSOR RESET\n");
}

/*
 * ioctl_s_power - V4L2 sensor interface handler for vidioc_int_s_power_num
 * @s: pointer to standard V4L2 device structure
 * @on: power state to which device is to be set
 *
 * Sets devices power state to requrested state, if possible.
 */
static int ioctl_s_power( struct v4l2_int_device * s, enum v4l2_power on )
{
	struct ov5640_sensor *sensor = s->priv;
	static enum v4l2_power prev_on = V4L2_POWER_OFF;

	int rval = 0;

	if ( on == V4L2_POWER_ON )
		PDEBUG("ov5640 = ON prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if ( on == V4L2_POWER_OFF )
		PDEBUG("ov5640 = OFF prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if ( on == V4L2_POWER_STANDBY )
		PDEBUG("ov5640 = STANDBY prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );

	if ( (prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_STANDBY) )
	{
		ov5640_write_regs( ov5640_standby_on );
	}

	rval = dmw_camera_port_power_ctl( sensor->cam_port,
									  on );

	if ( rval < 0 )
	{
		PDEBUG( "Unable to set the power state: "
		OV5640_DRIVER_NAME " sensor\n" );

		return rval;
	}

	/* if turning on, from standby or off */
	if ( on == V4L2_POWER_ON )
	{
		if ( prev_on == V4L2_POWER_STANDBY)
		{
			/* allow sensor to stablize */
			mdelay( 30 );

			ov5640_write_regs( ov5640_standby_off );
		}
		else if ( prev_on == V4L2_POWER_OFF)
		{
			/* allow sensor to stablize */
			mdelay( 30 );
		}
	}


//	 if (on == V4L2_POWER_ON)
//	 sensor->pdata->set_xclk(xclk_current);
//	 else
//	 sensor->pdata->set_xclk(0);

	if ( (prev_on == V4L2_POWER_OFF && on == V4L2_POWER_ON) && (sensor->state == SENSOR_DETECTED) )
		reset_ov5640_to_default( s );

	if ( (prev_on == V4L2_POWER_STANDBY || prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_ON) && (sensor->state == SENSOR_DETECTED) )
		ov5640_configure( s );

	if ( (on == V4L2_POWER_ON) && (sensor->state == SENSOR_NOT_DETECTED) )
	{
		rval = ov5640_detect();
		if ( rval < 0 )
		{
			PDEBUG( "Unable to detect "
			OV5640_DRIVER_NAME " sensor (or sensor is not connected)\n" );
			sensor->state = SENSOR_NOT_DETECTED;

			/* turn port off */
			dmw_camera_port_power_ctl( sensor->cam_port,
									   V4L2_POWER_OFF );

			return rval;
		}

		sensor->state = SENSOR_DETECTED;
		sensor->ver = rval;
		pr_info( OV5640_DRIVER_NAME " Chip version 0x%02x detected\n", sensor->ver );

		reset_ov5640_to_default( s );

		/* associate with port */
		dmw_camera_associate_sensor_with_port( ov5640.cam_port,
											   &ov5640_sensor_desc );
	}

	prev_on = on;
	return 0;
}

/*
 * ioctl_init - V4L2 sensor interface handler for VIDIOC_INT_INIT
 * @s: pointer to standard V4L2 device structure
 *
 * Initialize the sensor device (call ov5640_configure())
 */
static int ioctl_init( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_dev_exit - V4L2 sensor interface handler for vidioc_int_dev_exit_num
 * @s: pointer to standard V4L2 device structure
 *
 * Delinitialise the dev. at slave detach.  The complement of ioctl_dev_init.
 */
static int ioctl_dev_exit( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_dev_init - V4L2 sensor interface handler for vidioc_int_dev_init_num
 * @s: pointer to standard V4L2 device structure
 *
 * Initialise the device when slave attaches to the master.  Returns 0 if
 * ov5640 device could be found, otherwise returns appropriate error.
 */
static int ioctl_dev_init( struct v4l2_int_device *s )
{
	return 0;
}

/**
 * ioctl_enum_framesizes - V4L2 sensor if handler for vidioc_int_enum_framesizes
 * @s: pointer to standard V4L2 device structure
 * @frms: pointer to standard V4L2 framesizes enumeration structure
 *
 * Returns possible framesizes depending on choosen pixel format
 **/
static int ioctl_enum_framesizes( struct v4l2_int_device * s, struct v4l2_frmsizeenum * frms )
{
	int ifmt = 0;
	if ( !s || !frms )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( frms->pixel_format == ov5640_formats[ifmt].pixelformat )
			break;
	}

	/* Is requested pixelformat not found on sensor? */
	if ( ifmt == NUM_CAPTURE_FORMATS )
	{
		PDEBUG("sensor is not supporting the format\n");
		return -EINVAL;
	}

	if ( frms->index >= OV5640_NUM_MODES )
	{
		PDEBUG( "Invalid frame size or not supported by the sensor frms->index=0x%x NUM_DISCRETE_SIZES=%d\n", frms->index, OV5640_NUM_MODES );
		return -EINVAL;
	}

	frms->type = V4L2_FRMSIZE_TYPE_DISCRETE;
	frms->discrete.width = ov5640_modes[frms->index].width;
	frms->discrete.height = ov5640_modes[frms->index].height;

	return 0;
}

static int ioctl_enum_frameintervals( struct v4l2_int_device * s, struct v4l2_frmivalenum * frmi )
{
	int ifmt = 0;
	int ret;

	if ( !s || !frmi )
	{
		PDEBUG("Invalid input\n");
		return -1;
	}

	for ( ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++ )
	{
		if ( frmi->pixel_format == ov5640_formats[ifmt].pixelformat )
			break;
	}

	/* Is requested pixelformat not found on sensor? */
	if ( ifmt == NUM_CAPTURE_FORMATS )
		return -EINVAL;

	ret = check_if_res_supported( frmi->width, frmi->height );

	if ( ret )
	{
		return ret;
	}

	if ( frmi->index >= NUM_TIMEFRAME_VALS || frmi->index > OV5640_30_FPS )
		return -EINVAL;

	frmi->type = V4L2_FRMIVAL_TYPE_DISCRETE;


//	frmi->discrete.numerator = ov5640_frameintervals[frmi->index].numerator;
//	frmi->discrete.denominator = ov5640_frameintervals[frmi->index].denominator;

	// TODO manually override to set at 30fps */
	frmi->discrete.numerator   = 1;
	frmi->discrete.denominator = 30;


	return 0;
}

static int ioctl_s_reg( struct v4l2_int_device * s, const struct v4l2_dbg_register * reg )
{
	struct ov5640_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if ( !s || !reg || !s->priv )
		return -1;

	sensor = s->priv;

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	c = dmw_camera_get_i2c( sensor->cam_port,
				 	 	 	&ov5640_sensor_desc );

	if ( !c )
	{
		return -EINVAL;
	}

	ret = ov5640_write_reg( c, reg->reg, reg->val );

	dmw_camera_put_i2c( ov5640.cam_port );

	return ret;
}

static int ioctl_g_reg( struct v4l2_int_device * s, struct v4l2_dbg_register * reg )
{
	struct ov5640_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if ( !s || !reg || !s->priv )
		return -1;

	sensor = s->priv;

	c = dmw_camera_get_i2c( sensor->cam_port,
				 	 	 	&ov5640_sensor_desc );

	if ( !c )
	{
		return -EINVAL;
	}

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	ret = ov5640_read_reg( c, 1, reg->reg, (unsigned long *) &(reg->val) );

	dmw_camera_put_i2c( ov5640.cam_port );

	return ret;
}

static struct v4l2_int_ioctl_desc ov5640_ioctl_desc[] =
{
       {vidioc_int_enum_framesizes_num,
         (v4l2_int_ioctl_func *)ioctl_enum_framesizes},
       {vidioc_int_enum_frameintervals_num,
         (v4l2_int_ioctl_func *)ioctl_enum_frameintervals},
       {vidioc_int_dev_init_num,
         (v4l2_int_ioctl_func *)ioctl_dev_init},
       {vidioc_int_dev_exit_num,
         (v4l2_int_ioctl_func *)ioctl_dev_exit},
       {vidioc_int_s_power_num,
         (v4l2_int_ioctl_func *)ioctl_s_power},
       {vidioc_int_g_priv_num,
         (v4l2_int_ioctl_func *)ioctl_g_priv},
       {vidioc_int_init_num,
         (v4l2_int_ioctl_func *)ioctl_init},
       {vidioc_int_enum_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_enum_fmt_cap},
       {vidioc_int_try_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_try_fmt_cap},
       {vidioc_int_g_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_g_fmt_cap},
       {vidioc_int_s_fmt_cap_num,
         (v4l2_int_ioctl_func *)ioctl_s_fmt_cap},
       {vidioc_int_g_parm_num,
         (v4l2_int_ioctl_func *)ioctl_g_parm},
       {vidioc_int_s_parm_num,
         (v4l2_int_ioctl_func *)ioctl_s_parm},
       {vidioc_int_queryctrl_num,
         (v4l2_int_ioctl_func *)ioctl_queryctrl},
       {vidioc_int_g_ctrl_num,
         (v4l2_int_ioctl_func *)ioctl_g_ctrl},
       {vidioc_int_s_ctrl_num,
         (v4l2_int_ioctl_func *)ioctl_s_ctrl},
       { vidioc_int_g_crop_num,
         (v4l2_int_ioctl_func *)ioctl_g_crop},
       {vidioc_int_s_crop_num,
         (v4l2_int_ioctl_func *)ioctl_s_crop},
       {vidioc_int_cropcap_num,
         (v4l2_int_ioctl_func *)ioctl_cropcap},
	   {vidioc_int_s_reg_num,
         (v4l2_int_ioctl_func *)ioctl_s_reg},
	   {vidioc_int_g_reg_num,
         (v4l2_int_ioctl_func *)ioctl_g_reg},
};


static struct v4l2_int_slave ov5640_slave =
{
	.ioctls = ov5640_ioctl_desc,
	.num_ioctls = ARRAY_SIZE( ov5640_ioctl_desc ),
};

static struct v4l2_int_device ov5640_int_device =
{
       .module = THIS_MODULE,
       .name   = OV5640_DRIVER_NAME,
       .priv   = &ov5640,
       .type   = v4l2_int_type_slave,
       .u      = {
               .slave = &ov5640_slave,
       },
};

/* probing function */
static int ov5640_probe( dmw_camera_sensor_desc_t * sensor_desc,
						 dmw_camera_port_t * 		cam_port )
{
	struct ov5640_sensor *sensor = &ov5640;
	int err = 0;

	/* associate camera port */
	sensor->cam_port = cam_port;

	sensor->v4l2_int_device = &ov5640_int_device;

	/* set default format */
	sensor->pix.width = ov5640_modes[0].width;
	sensor->pix.height = ov5640_modes[0].height;
	sensor->pix.pixelformat = V4L2_PIX_FMT_NV12;

	sensor->crop_rect.height = ov5640_modes[0].height;
	sensor->crop_rect.width = ov5640_modes[0].width;
	sensor->crop_rect.left = 0;
	sensor->crop_rect.top = 0;

	sensor->timeperframe.denominator = 15;
	sensor->timeperframe.numerator = 1;
	sensor->vflip = 0;
	sensor->hflip = 0;

	err = v4l2_int_device_register( sensor->v4l2_int_device );
	if ( err )
	{
		return err;
	}

	PDEBUG("\n\n\n P r o b i n g	OV5640	s e n s o r	 s u c c e s s   ! ! !\n\n\n");
	return 0;
}

/* sensor descriptor */
static dmw_camera_sensor_desc_t ov5640_sensor_desc =
{
 	 .name 	   = OV5640_DRIVER_NAME,
 	 .probe    = ov5640_probe,
 	 .i2c_addr = OV5640_I2C_ADDR,
 	 .mode	   = DMW_CAMERA_SENSOR_MODE_MIPI_2LANES,
};

/* default platform data, when no pdata is given by the board */
static dmw_camera_sensor_platform_data_t ov5640_default_platform_data =
{
 	 .__sensor_desc = &ov5640_sensor_desc,
};

static int __devinit ov5640_pdev_probe(struct platform_device *pdev)
{
	platform_set_drvdata(pdev, &ov5640_default_platform_data);

	return 0;
}

static int __devexit ov5640_pdev_remove(struct platform_device *pdev)
{
	return 0;
}

static struct platform_driver ov5640_driver = {
	.driver = {
		.name  = OV5640_DRIVER_NAME,
		.owner = THIS_MODULE,
	},
	.probe = ov5640_pdev_probe,
	.remove = __devexit_p(ov5640_pdev_remove),
};

static int __init ov5640_init(void)
{
	return platform_driver_register(&ov5640_driver);
}

static void __exit ov5640_exit(void)
{
	platform_driver_unregister(&ov5640_driver);
}

subsys_initcall(ov5640_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("OV5640 camera sensor driver");
