/***************************************************************************
*
* SIMG PART NUMBER -HDMI Transmitter Driver
*
* Copyright (C) (2011, Silicon Image)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2.
*
* This program is distributed "as is" WITHOUT ANY WARRANTY of any
* kind, whether express or implied; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
*****************************************************************************/


#ifndef SIHDMITX_902X_TPI_H
#define SIHDMITX_902X_TPI_H

//--------------------------------------------------------------------
// System Macro definition
//--------------------------------------------------------------------

//#define DEV_SUPPORT_EDID
//#define DEV_SUPPORT_HDCP
//#define DEV_SUPPORT_CEC
//#define DEV_SUPPORT_3D

//#define CLOCK_EDGE_RISING
#define CLOCK_EDGE_FALLING

//--------------------------------------------------------------------
// TPI Firmware Version
//--------------------------------------------------------------------
static const char TPI_FW_VERSION[] = "TPI Firmware v6.6.3_APP v1.3";

// Generic Constants
//====================================================
#define FALSE	0
#define TRUE	1

#define OFF	0
#define ON	1

#define LOW	0
#define HIGH	1

#define DISABLE	0x00
#define ENABLE	0xFF

//====================================================
#define MAX_V_DESCRIPTORS		20
#define MAX_A_DESCRIPTORS		10
#define MAX_SPEAKER_CONFIGURATIONS	 4
#define AUDIO_DESCR_SIZE		 3

#define RGB		0
#define YCBCR444	1
#define YCBCR422_16BITS	2
#define YCBCR422_8BITS	3
#define XVYCC444	4

#define EXTERNAL_HSVSDE	0
#define INTERNAL_DE	1
#define EMBEDDED_SYNC	2

#define COLORIMETRY_601	0
#define COLORIMETRY_709	1

//====================================================
// Video mode define
#define HDMI_480I60_4X3		1
#define HDMI_576I50_4X3		2
#define HDMI_480P60_4X3		3
#define HDMI_576P50_4X3		4
#define HDMI_720P60		5
#define HDMI_720P50		6
#define HDMI_1080I60		7
#define HDMI_1080I50		8
#define HDMI_1080P60		9
#define HDMI_1080P50		10
#define HDMI_1024_768_60	11
#define HDMI_800_600_60		12
#define HDMI_1024_768_70	13
#define HDMI_1080P24		14
#define HDMI_1080P25		15
#define HDMI_1080P30		16

//====================================================
/* AUDIO */

/* Reg 0x1F: */
#define AFIFO_DISABLE	(0x00 << 7)
#define AFIFO_ENABLE	(0x01 << 7)

#define AMAPPED_FIFO_0	(0x00 << 4)
#define AMAPPED_FIFO_1	(0x01 << 4)
#define AMAPPED_FIFO_2	(0x02 << 4)
#define AMAPPED_FIFO_3	(0x03 << 4)

#define AAUTO_DNSAMPLE_OFF	(0x00 << 3)
#define AAUTO_DNSAMPLE_ON	(0x01 << 3)

#define ALR_SWAP_OFF	(0x00 << 2)
#define ALR_SWAP_ON	(0x01 << 2)

#define A_MAP_PORT_SD0	(0x00 << 0)
#define A_MAP_PORT_SD1	(0x01 << 0)
#define A_MAP_PORT_SD2	(0x02 << 0)
#define A_MAP_PORT_SD3	(0x03 << 0)

/* Reg 0x20: */
#define SCK_SAMPLE_FALLING_EDGE	(0x00 << 7)
#define SCK_SAMPLE_RISING_EDGE	(0x01 << 7)

#define MCLK128FS	(0x00 << 4)
#define MCLK256FS	(0x01 << 4)
#define MCLK384FS	(0x02 << 4)
#define MCLK512FS	(0x03 << 4)
#define MCLK768FS	(0x04 << 4)
#define MCLK1024FS	(0x05 << 4)
#define MCLK1152FS	(0x06 << 4)
#define MCLK192FS	(0x07 << 4)

#define WS_POALRITY_LOW		(0x00 << 3)
#define WS_POLARITY_HIGH	(0x01 << 3)

#define SD_JUSTIFY_LEFT		(0x00 << 2)
#define SD_JUSTIFY_RIGHT	(0x01 << 2)

#define SD_DIR_MSB_FIRST	(0x00 << 1)
#define SD_DIR_LSB_FIRST	(0x01 << 1)

#define WS_SD_1_BIT_SHIFT	(0x00 << 0)
#define WS_SD_NO_BIT_SHIFT	(0x01 << 0)

/* Reg 0x24: */
#define AOUTPUT_FS_NI	(0x01 << 0) /* Not Indicated */
#define AOUTPUT_FS_32K	(0x03 << 0)
#define AOUTPUT_FS_44K1	(0x00 << 0)
#define AOUTPUT_FS_48K	(0x02 << 0)

/* Reg 0x25: */
#define AOUTPUT_WL_16BITS	(0x02 << 0)
#define AOUTPUT_WL_17BITS	(0x0C << 0)
#define AOUTPUT_WL_18BITS	(0x04 << 0)
#define AOUTPUT_WL_19BITS	(0x08 << 0)
#define AOUTPUT_WL_20BITS	(0x0A << 0)
#define AOUTPUT_WL_21BITS	(0x0D << 0)
#define AOUTPUT_WL_22BITS	(0x05 << 0)
#define AOUTPUT_WL_23BITS	(0x09 << 0)
#define AOUTPUT_WL_24BITS	(0x0B << 0)

/* Reg 0x26: */
#define AMODE_MASK	(0x03 << 6)
#define AMODE_DISABLED	(0x00 << 6)
#define AMODE_SPDIF	(0x01 << 6)
#define AMODE_I2S	(0x02 << 6)
#define AMODE_DSD	(0x03 << 6)

#define ALAYOUT_2CH	(0x00 << 5)
#define ALAYOUT_3TO8CH	(0x01 << 5)

#define AMUTE_MASK	(0x01 << 4)
#define AMUTE_OFF	(0x00 << 4)
#define AMUTE_ON	(0x01 << 4)

#define ACODE_TYP_PCM	(0x01 << 0)
#define ACODE_TYP_AC3	(0x02 << 0)
#define ACODE_TYP_MPEG1	(0x03 << 0)
#define ACODE_TYP_MP3	(0x04 << 0)
#define ACODE_TYP_MPEG2	(0x05 << 0)
#define ACODE_TYP_AAC	(0x06 << 0)
#define ACODE_TYP_DTS	(0x07 << 0)
#define ACODE_TYP_ATRAC	(0x08 << 0)

/* Reg 0x27: */
#define AINPUT_WL_REF_STRM_HDR	(0x00 << 6)
#define AINPUT_WL_16BITS	(0x01 << 6)
#define AINPUT_WL_20BITS	(0x02 << 6)
#define AINPUT_WL_24BITS	(0x03 << 6)

#define AINPUT_FS_REF_STRM_HDR	(0x00 << 3)
#define AINPUT_FS_32K		(0x01 << 3)
#define AINPUT_FS_44K1		(0x02 << 3)
#define AINPUT_FS_48K		(0x03 << 3)

#define AHBR_DISABLED	(0x00 << 2)
#define AHBR_ENABLED	(0x01 << 2)


#define ACHANNEL_2CH	1
#define ACHANNEL_3CH	2
#define ACHANNEL_4CH	3
#define ACHANNEL_5CH	4
#define ACHANNEL_6CH	5
#define ACHANNEL_7CH	6
#define ACHANNEL_8CH	7

///--------------------------------------------------------------------
// Debug Definitions
//--------------------------------------------------------------------
// Compile debug prints inline or not
#define CONF__TPI_TRACE_PRINT	(DISABLE)
#define CONF__TPI_DEBUG_PRINT	(DISABLE)
#define CONF__TPI_EDID_PRINT	(DISABLE)
#define CONF__CPI_DEBUG_PRINT	(DISABLE)


// Trace Print Macro
// Note: TPI_TRACE_PRINT Requires double parenthesis
// Example:  TPI_TRACE_PRINT(("hello, world!\n"));
#if (CONF__TPI_TRACE_PRINT == ENABLE)
    #define TPI_TRACE_PRINT(x)	printk x;
#else
	#define TPI_TRACE_PRINT(x)
#endif

// Debug Print Macro
// Note: TPI_DEBUG_PRINT Requires double parenthesis
// Example:  TPI_DEBUG_PRINT(("hello, world!\n"));
#if (CONF__TPI_DEBUG_PRINT == ENABLE)
    #define TPI_DEBUG_PRINT(x)	printk x;
#else
    #define TPI_DEBUG_PRINT(x)
#endif

// EDID Print Macro
// Note: To enable EDID description printing, both CONF__TPI_EDID_PRINT and CONF__TPI_DEBUG_PRINT must be enabled
// Note: TPI_EDID_PRINT Requires double parenthesis
// Example:  TPI_EDID_PRINT(("hello, world!\n"));
#if (CONF__TPI_EDID_PRINT == ENABLE)
    #define TPI_EDID_PRINT(x)	TPI_DEBUG_PRINT(x)
#else
    #define TPI_EDID_PRINT(x)
#endif

// CPI Debug Print Macro
// Note: To enable CPI description printing, both CONF__CPI_DEBUG_PRINT and CONF__TPI_DEBUG_PRINT must be enabled
// Note: CPI_DEBUG_PRINT Requires double parenthesis
// Example:  CPI_DEBUG_PRINT(("hello, world!\n"));
#if (CONF__CPI_DEBUG_PRINT == ENABLE)
    #define CPI_DEBUG_PRINT(x)	TPI_DEBUG_PRINT(x)
#else
    #define CPI_DEBUG_PRINT(x)
#endif

//====================================================

enum AV_ConfigErrorCodes
{
    DE_CANNOT_BE_SET_WITH_EMBEDDED_SYNC,
    V_MODE_NOT_SUPPORTED,
    SET_EMBEDDED_SYC_FAILURE,
    I2S_MAPPING_SUCCESSFUL,
    I2S_INPUT_CONFIG_SUCCESSFUL,
    I2S_HEADER_SET_SUCCESSFUL,
    EHDMI_ARC_SINGLE_SET_SUCCESSFUL,
    EHDMI_ARC_COMMON_SET_SUCCESSFUL,
    EHDMI_HEC_SET_SUCCESSFUL,
    EHDMI_ARC_CM_WITH_HEC_SET_SUCCESSFUL,
    AUD_MODE_NOT_SUPPORTED,
    I2S_NOT_SET,
    DE_SET_OK,
    VIDEO_MODE_SET_OK,
    AUDIO_MODE_SET_OK,
    GBD_SET_SUCCESSFULLY,
    DE_CANNOT_BE_SET_WITH_3D_MODE,
};

// write "1" to clear interrupt bit
#define ClearInterrupt(x) WriteByteTPI(TPI_INTERRUPT_STATUS_REG, x)

// Generic Masks
//====================================================
#define LOW_BYTE	0x00FF
#define HIGH_BYTE	0xFF00

#define LOW_NIBBLE	0x0F
#define HI_NIBBLE	0xF0

#define MSBIT	0x80
#define LSBIT	0x01

#define BIT_0	0x01
#define BIT_1	0x02
#define BIT_2	0x04
#define BIT_3	0x08
#define BIT_4	0x10
#define BIT_5	0x20
#define BIT_6	0x40
#define BIT_7	0x80

#define TWO_LSBITS	0x03
#define THREE_LSBITS	0x07
#define FOUR_LSBITS	0x0F
#define FIVE_LSBITS	0x1F
#define SEVEN_LSBITS	0x7F
#define TWO_MSBITS	0xC0
#define EIGHT_BITS	0xFF
#define BYTE_SIZE	0x08
#define BITS_1_0	0x03
#define BITS_2_1	0x06
#define BITS_2_1_0	0x07
#define BITS_3_2	0x0C
#define BITS_4_3_2	0x1C
#define BITS_5_4	0x30
#define BITS_5_4_3	0x38
#define BITS_6_5	0x60
#define BITS_6_5_4	0x70
#define BITS_7_6	0xC0

#define TPI_INTERNAL_PAGE_REG	0xBC
#define TPI_INDEXED_OFFSET_REG	0xBD
#define TPI_INDEXED_VALUE_REG	0xBE

// Interrupt Masks
//====================================================
#define HOT_PLUG_EVENT	0x01 // 1: connected; 0: disconnected
#define RX_SENSE_EVENT	0x02
#define HOT_PLUG_STATE	0x04
#define RX_SENSE_STATE	0x08

#define AUDIO_ERROR_EVENT	0x10
#define SECURITY_CHANGE_EVENT	0x20
#define V_READY_EVENT		0x40
#define HDCP_CHANGE_EVENT	0x80

#define NON_MASKABLE_INT	0xFF

// TPI Control Masks
//====================================================
#define CS_HDMI_RGB	0x00
#define CS_DVI_RGB	0x03

#define ENABLE_AND_REPEAT	0xC0
#define EN_AND_RPT_MPEG		0xC3
#define DISABLE_MPEG		0x03 // Also Vendor Specific InfoFrames

// Pixel Repetition Masks
//====================================================
#define BIT_BUS_24	0x20
#define BIT_EDGE_RISE	0x10

//Audio Maps
//====================================================
#define BIT_AUDIO_MUTE	0x10

// Input/Output Format Masks
//====================================================
#define BITS_IN_RGB		0x00
#define BITS_IN_YCBCR444	0x01
#define BITS_IN_YCBCR422	0x02

#define BITS_IN_AUTO_RANGE	0x00
#define BITS_IN_FULL_RANGE	0x04
#define BITS_IN_LTD_RANGE	0x08

#define BIT_EN_DITHER_10_8	0x40
#define BIT_EXTENDED_MODE	0x80

#define BITS_OUT_RGB		0x00
#define BITS_OUT_YCBCR444	0x01
#define BITS_OUT_YCBCR422	0x02

#define BITS_OUT_AUTO_RANGE	0x00
#define BITS_OUT_FULL_RANGE	0x04
#define BITS_OUT_LTD_RANGE	0x08

#define BIT_BT_709	0x10

// DE Generator Masks
//====================================================
#define BIT_EN_DE_GEN	0x40
#define DE		0x00
#define DeDataNumBytes	  12

// Embedded Sync Masks
//====================================================
#define BIT_EN_SYNC_EXTRACT	0x40
#define EMB			0x80
#define EmbDataNumBytes		   8

// Audio Modes
//====================================================
#define AUD_PASS_BASIC		0x00
#define AUD_PASS_ALL		0x01
#define AUD_DOWN_SAMPLE		0x02
#define AUD_DO_NOT_CHECK	0x03

#define REFER_TO_STREAM_HDR	0x00
#define TWO_CHANNELS		0x00
#define EIGHT_CHANNELS		0x01
#define AUD_IF_SPDIF		0x40
#define AUD_IF_I2S		0x80
#define AUD_IF_DSD		0xC0
#define AUD_IF_HBR		0x04

#define TWO_CHANNEL_LAYOUT	0x00
#define EIGHT_CHANNEL_LAYOUT	0x20

// I2C Slave Addresses
//====================================================
#define TX_SLAVE_ADDR		0x72
#define CBUS_SLAVE_ADDR		0xC8
#define HDCP_SLAVE_ADDR		0x74
#define EDID_ROM_ADDR		0xA0
#define EDID_SEG_ADDR		0x60

// Indexed Register Offsets, Constants
//====================================================
#define INDEXED_PAGE_0	0x01
#define INDEXED_PAGE_1	0x02
#define INDEXED_PAGE_2	0x03

#define TMDS_CONT_REG	0x82

// DDC Bus Addresses
//====================================================
#define DDC_BSTATUS_ADDR_L 	0x41
#define DDC_BSTATUS_ADDR_H 	0x42
#define DDC_KSV_FIFO_ADDR	0x43
#define KSV_ARRAY_SIZE		 128

// DDC Bus Bit Masks
//====================================================
#define BIT_DDC_HDMI		0x80
#define BIT_DDC_REPEATER	0x40
#define BIT_DDC_FIFO_RDY	0x20
#define DEVICE_COUNT_MASK	0x7F

// KSV Buffer Size
//====================================================
#define DEVICE_COUNT	128 // May be tweaked as needed

// InfoFrames
//====================================================
#define SIZE_AVI_INFOFRAME	0x0E // including checksum byte
#define BITS_OUT_FORMAT		0x60 // Y1Y0 field

#define _4_To_3		0x10 // Aspect ratio - 4:3  in InfoFrame DByte 1
#define _16_To_9	0x20 // Aspect ratio - 16:9 in InfoFrame DByte 1
#define SAME_AS_AR	0x08 // R3R2R1R0 - in AVI InfoFrame DByte 2

#define BT_601	0x40
#define BT_709	0x80

//#define EN_AUDIO_INFOFRAMES		0xC2
#define TYPE_AUDIO_INFOFRAMES		0x84
#define AUDIO_INFOFRAMES_VERSION	0x01
#define AUDIO_INFOFRAMES_LENGTH		0x0A

#define TYPE_GBD_INFOFRAME	0x0A

#define ENABLE_AND_REPEAT	0xC0

#define EN_AND_RPT_MPEG	0xC3
#define DISABLE_MPEG	0x03 // Also Vendor Specific InfoFrames

#define EN_AND_RPT_AUDIO	0xC2
#define DISABLE_AUDIO		0x02

#define EN_AND_RPT_AVI	0xC0 // Not normally used.  Write to TPI 0x19 instead
#define DISABLE_AVI	0x00 // But this is used to Disable

#define NEXT_FIELD		0x80
#define GBD_PROFILE		0x00
#define AFFECTED_GAMUT_SEQ_NUM	0x01

#define ONLY_PACKET		0x30
#define CURRENT_GAMUT_SEQ_NUM	0x01

// FPLL Multipliers:
//====================================================
#define X0d5	0x00
#define X1	0x01
#define X2	0x02
#define X4	0x03

// 3D Constants
//====================================================
#define _3D_STRUC_PRESENT	0x02

// 3D_Stucture Constants
//====================================================
#define FRAME_PACKING			0x00
#define FIELD_ALTERNATIVE		0x01
#define LINE_ALTERNATIVE		0x02
#define SIDE_BY_SIDE_FULL		0x03
#define L_PLUS_DEPTH			0x04
#define L_PLUS_DEPTH_PLUS_GRAPHICS	0x05
#define SIDE_BY_SIDE_HALF		0x08

// 3D_Ext_Data Constants
//====================================================
#define HORIZ_ODD_LEFT_ODD_RIGHT	0x00
#define HORIZ_ODD_LEFT_EVEN_RIGHT	0x01
#define HORIZ_EVEN_LEFT_ODD_RIGHT	0x02
#define HORIZ_EVEN_LEFT_EVEN_RIGHT	0x03

#define QUINCUNX_ODD_LEFT_EVEN_RIGHT	0x04
#define QUINCUNX_ODD_LEFT_ODD_RIGHT	0x05
#define QUINCUNX_EVEN_LEFT_ODD_RIGHT	0x06
#define QUINCUNX_EVEN_LEFT_EVEN_RIGHT	0x07

#define NO_3D_SUPPORT			0x0F

// InfoFrame Type Code
//====================================================
#define AVI		0x00
#define SPD		0x01
#define AUDIO		0x02
#define MPEG		0x03
#define GEN_1		0x04
#define GEN_2		0x05
#define HDMI_VISF	0x06
#define GBD		0x07

// Size of InfoFrame Data types
#define MAX_SIZE_INFOFRAME_DATA		0x22
#define SIZE_AVI_INFOFRAME		0x0E // 14 bytes
#define SIZE_SPD_INFOFRAME		0x19 // 25 bytes
#define SISE_AUDIO_INFOFRAME_IFORM	0x0A // 10 bytes
#define SIZE_AUDIO_INFOFRAME		0x0F // 15 bytes
#define SIZE_MPRG_HDMI_INFOFRAME	0x1B // 27 bytes
#define SIZE_MPEG_INFOFRAME		0x0A // 10 bytes
#define SIZE_GEN_1_INFOFRAME		0x1F // 31 bytes
#define SIZE_GEN_2_INFOFRAME		0x1F // 31 bytes
#define SIZE_HDMI_VISF_INFOFRAME	0x1E // 31 bytes
#define SIZE_GBD_INFOFRAME		0x1C // 28 bytes

#define AVI_INFOFRM_OFFSET		0x0C
#define OTHER_INFOFRM_OFFSET		0xC4
#define TPI_INFOFRAME_ACCESS_REG	0xBF

// Serial Communication Buffer constants
#define MAX_COMMAND_ARGUMENTS		 50
#define GLOBAL_BYTE_BUF_BLOCK_SIZE	131

// Video Mode Constants
//====================================================
#define VMD_ASPECT_RATIO_4x3	0x01
#define VMD_ASPECT_RATIO_16x9	0x02

#define VMD_COLOR_SPACE_RGB		0x00
#define VMD_COLOR_SPACE_YCBCR422	0x01
#define VMD_COLOR_SPACE_YCBCR444	0x02

#define VMD_COLOR_DEPTH_8BIT	0x00
#define VMD_COLOR_DEPTH_10BIT	0x01
#define VMD_COLOR_DEPTH_12BIT	0x02
#define VMD_COLOR_DEPTH_16BIT	0x03

#define VMD_HDCP_NOT_AUTHENTICATED	0x00
#define VMD_HDCP_AUTHENTICATED		0x01

#define VMD_HDMIFORMAT_CEA_VIC	0x00
#define VMD_HDMIFORMAT_HDMI_VIC	0x01
#define VMD_HDMIFORMAT_3D	0x02
#define VMD_HDMIFORMAT_PC	0x03

// These values are from HDMI Spec 1.4 Table H-2
#define VMD_3D_FRAMEPACKING	0
#define VMD_3D_FIELDALTERNATIVE	1
#define VMD_3D_LINEALTERNATIVE	2
#define VMD_3D_SIDEBYSIDEFULL	3
#define VMD_3D_LDEPTH		4
#define VMD_3D_LDEPTHGRAPHICS	5
#define VMD_3D_SIDEBYSIDEHALF	8

//--------------------------------------------------------------------
// System Macro Definitions
//--------------------------------------------------------------------
#define TX_HW_RESET_PERIOD	200
#define SII902XA_DEVICE_ID	0xB0

#define T_HPD_DELAY	10

//--------------------------------------------------------------------
// HDCP Macro Definitions
//--------------------------------------------------------------------
#define AKSV_SIZE		 5
#define NUM_OF_ONES_IN_KSV	20

//--------------------------------------------------------------------
// EDID Constants Definition
//--------------------------------------------------------------------
#define EDID_BLOCK_0_OFFSET	0x00
#define EDID_BLOCK_1_OFFSET	0x80

#define EDID_BLOCK_SIZE		 128
#define EDID_HDR_NO_OF_FF	0x06
#define NUM_OF_EXTEN_ADDR	0x7E

#define EDID_TAG_ADDR		0x00
#define EDID_REV_ADDR		0x01
#define EDID_TAG_IDX		0x02
#define LONG_DESCR_PTR_IDX	0x02
#define MISC_SUPPORT_IDX	0x03

#define ESTABLISHED_TIMING_INDEX	35 // Offset of Established Timing in EDID block
#define NUM_OF_STANDARD_TIMINGS		 8
#define STANDARD_TIMING_OFFSET		38
#define LONG_DESCR_LEN			18
#define NUM_OF_DETAILED_DESCRIPTORS	 4

#define DETAILED_TIMING_OFFSET	0x36

// Offsets within a Long Descriptors Block
//====================================================
#define PIX_CLK_OFFSET		 0
#define H_ACTIVE_OFFSET		 2
#define H_BLANKING_OFFSET	 3
#define V_ACTIVE_OFFSET		 5
#define V_BLANKING_OFFSET	 6
#define H_SYNC_OFFSET		 8
#define H_SYNC_PW_OFFSET	 9
#define V_SYNC_OFFSET		10
#define V_SYNC_PW_OFFSET       	10
#define H_IMAGE_SIZE_OFFSET	12
#define V_IMAGE_SIZE_OFFSET	13
#define H_BORDER_OFFSET		15
#define V_BORDER_OFFSET		16
#define FLAGS_OFFSET		17

#define AR16_10	0
#define AR4_3	1
#define AR5_4	2
#define AR16_9	3

// Data Block Tag Codes
//====================================================
#define AUDIO_D_BLOCK		0x01
#define VIDEO_D_BLOCK		0x02
#define VENDOR_SPEC_D_BLOCK	0x03
#define SPKR_ALLOC_D_BLOCK	0x04
#define USE_EXTENDED_TAG	0x07

// Extended Data Block Tag Codes
//====================================================
#define COLORIMETRY_D_BLOCK	0x05

#define HDMI_SIGNATURE_LEN	0x03

#define CEC_PHYS_ADDR_LEN	0x02
#define EDID_EXTENSION_TAG	0x02
#define EDID_REV_THREE		0x03
#define EDID_DATA_START		0x04

#define EDID_BLOCK_0	0x00
#define EDID_BLOCK_2_3	0x01

#define VIDEO_CAPABILITY_D_BLOCK	0x00

//--------------------------------------------------------------------
// TPI Register Definition
//--------------------------------------------------------------------

// TPI Video Mode Data
#define TPI_PIX_CLK_LSB		(0x00)
#define TPI_PIX_CLK_MSB		(0x01)
#define TPI_VERT_FREQ_LSB	(0x02)
#define TPI_VERT_FREQ_MSB	(0x03)
#define TPI_TOTAL_PIX_LSB	(0x04)
#define TPI_TOTAL_PIX_MSB	(0x05)
#define TPI_TOTAL_LINES_LSB	(0x06)
#define TPI_TOTAL_LINES_MSB	(0x07)

// Pixel Repetition Data
#define TPI_PIX_REPETITION	(0x08)

// TPI AVI Input and Output Format Data
//====================================================
// AVI Input Format Data
#define TPI_INPUT_FORMAT_REG		(0x09)
#define INPUT_COLOR_SPACE_MASK		(BIT_1 | BIT_0)
#define INPUT_COLOR_SPACE_RGB		(0x00)
#define INPUT_COLOR_SPACE_YCBCR444	(0x01)
#define INPUT_COLOR_SPACE_YCBCR422	(0x02)
#define INPUT_COLOR_SPACE_BLACK_MODE	(0x03)

// AVI Output Format Data
#define TPI_OUTPUT_FORMAT_REG	(0x0A)
#define TPI_YC_Input_Mode	(0x0B)

// TPI InfoFrame related constants
#define TPI_AVI_INFO_REG_ADDR		(0x0C) // AVI InfoFrame Checksum
#define TPI_OTHER_INFO_REG_ADDR		(0xBF)
#define TPI_INFO_FRAME_REG_OFFSET	(0xC4)

// TPI AVI InfoFrame Data
#define TPI_AVI_BYTE_0	(0x0C)
#define TPI_AVI_BYTE_1	(0x0D)
#define TPI_AVI_BYTE_2	(0x0E)
#define TPI_AVI_BYTE_3	(0x0F)
#define TPI_AVI_BYTE_4	(0x10)
#define TPI_AVI_BYTE_5	(0x11)

#define TPI_INFO_FRM_DBYTE5	(0xC8)
#define TPI_INFO_FRM_DBYTE6	(0xC9)

#define TPI_END_TOP_BAR_LSB	(0x12)
#define TPI_END_TOP_BAR_MSB	(0x13)

#define TPI_START_BTM_BAR_LSB	(0x14)
#define TPI_START_BTM_BAR_MSB	(0x15)

#define TPI_END_LEFT_BAR_LSB	(0x16)
#define TPI_END_LEFT_BAR_MSB	(0x17)

#define TPI_END_RIGHT_BAR_LSB	(0x18)
#define TPI_END_RIGHT_BAR_MSB	(0x19)

// Colorimetry:
// Set TPI_AVI_BYTE_2 to extended colorimetry
// and use TPI_AVI_BYTE_3
#define SET_EX_COLORIMETRY	(0x0C)

#define TPI_SYSTEM_CONTROL_DATA_REG	(0x1A)

#define LINK_INTEGRITY_MODE_MASK	(BIT_6)
#define LINK_INTEGRITY_STATIC		(0x00)
#define LINK_INTEGRITY_DYNAMIC		(0x40)

#define TMDS_OUTPUT_CONTROL_MASK	(BIT_4)
#define TMDS_OUTPUT_CONTROL_ACTIVE	(0x00)
#define TMDS_OUTPUT_CONTROL_POWER_DOWN	(0x10)

#define AV_MUTE_MASK	(BIT_3)
#define AV_MUTE_NORMAL	(0x00)
#define AV_MUTE_MUTED	(0x08)

#define DDC_BUS_REQUEST_MASK		(BIT_2)
#define DDC_BUS_REQUEST_NOT_USING	(0x00)
#define DDC_BUS_REQUEST_REQUESTED	(0x04)

#define DDC_BUS_GRANT_MASK		(BIT_1)
#define DDC_BUS_GRANT_NOT_AVAILABLE	(0x00)
#define DDC_BUS_GRANT_GRANTED		(0x02)

#define OUTPUT_MODE_MASK	(BIT_0)
#define OUTPUT_MODE_DVI		(0x00)
#define OUTPUT_MODE_HDMI	(0x01)

// TPI Identification Registers
#define TPI_DEVICE_ID		(0x1B)
#define TPI_DEVICE_REV_ID	(0x1C)

#define TPI_RESERVED2		(0x1D)

#define TPI_DEVICE_POWER_STATE_CTRL_REG	(0x1E)

#define CTRL_PIN_CONTROL_MASK		(BIT_4)
#define CTRL_PIN_TRISTATE		(0x00)
#define CTRL_PIN_DRIVEN_TX_BRIDGE	(0x10)

#define TX_POWER_STATE_MASK		(BIT_1 | BIT_0)
#define TX_POWER_STATE_D0		(0x00)
#define TX_POWER_STATE_D1		(0x01)
#define TX_POWER_STATE_D2		(0x02)
#define TX_POWER_STATE_D3		(0x03)

// Configuration of I2S Interface
#define TPI_I2S_EN	(0x1F)
#define TPI_I2S_IN_CFG	(0x20)
#define SCK_SAMPLE_EDGE	(BIT_7)

// Available only when TPI 0x26[7:6]=10 to select I2S input
#define TPI_I2S_CHST_0	(0x21)
#define TPI_I2S_CHST_1	(0x22)
#define TPI_I2S_CHST_2	(0x23)
#define TPI_I2S_CHST_3	(0x24)
#define TPI_I2S_CHST_4	(0x25)

#define AUDIO_INPUT_LENGTH	(0x24)

// Available only when 0x26[7:6]=01
#define TPI_SPDIF_HEADER	(0x24)
#define TPI_AUDIO_HANDLING	(0x25)

// Audio Configuration Regiaters
#define TPI_AUDIO_INTERFACE_REG	(0x26)
#define AUDIO_MUTE_MASK		(BIT_4)
#define AUDIO_MUTE_NORMAL	(0x00)
#define AUDIO_MUTE_MUTED	(0x10)

#define AUDIO_SEL_MASK	(BITS_7_6)

#define TPI_AUDIO_SAMPLE_CTRL		(0x27)
#define TPI_SPEAKER_CFG			(0xC7)
#define TPI_CODING_TYPE_CHANNEL_COUNT	(0xC4)

//--------------------------------------------------------------------
// HDCP Implementation
// HDCP link security logic is implemented in certain transmitters; unique
//   keys are embedded in each chip as part of the solution. The security
//   scheme is fully automatic and handled completely by the hardware.
//--------------------------------------------------------------------

// HDCP Query Data Register
#define TPI_HDCP_QUERY_DATA_REG		(0x29)

#define EXTENDED_LINK_PROTECTION_MASK	(BIT_7)
#define EXTENDED_LINK_PROTECTION_NONE	(0x00)
#define EXTENDED_LINK_PROTECTION_SECURE	(0x80)

#define LOCAL_LINK_PROTECTION_MASK	(BIT_6)
#define LOCAL_LINK_PROTECTION_NONE	(0x00)
#define LOCAL_LINK_PROTECTION_SECURE	(0x40)

#define LINK_STATUS_MASK		(BIT_5 | BIT_4)
#define LINK_STATUS_NORMAL		(0x00)
#define LINK_STATUS_LINK_LOST		(0x10)
#define LINK_STATUS_RENEGOTIATION_REQ	(0x20)
#define LINK_STATUS_LINK_SUSPENDED	(0x30)

#define HDCP_REPEATER_MASK	(BIT_3)
#define HDCP_REPEATER_NO	(0x00)
#define HDCP_REPEATER_YES	(0x08)

#define CONNECTOR_TYPE_MASK	(BIT_2 | BIT_0)
#define CONNECTOR_TYPE_DVI	(0x00)
#define CONNECTOR_TYPE_RSVD	(0x01)
#define CONNECTOR_TYPE_HDMI	(0x04)
#define CONNECTOR_TYPE_FUTURE	(0x05)

#define PROTECTION_TYPE_MASK	(BIT_1)
#define PROTECTION_TYPE_NONE	(0x00)
#define PROTECTION_TYPE_HDCP	(0x02)

// HDCP Control Data Register
#define TPI_HDCP_CONTROL_DATA_REG	(0x2A)
#define PROTECTION_LEVEL_MASK		(BIT_0)
#define PROTECTION_LEVEL_MIN		(0x00)
#define PROTECTION_LEVEL_MAX		(0x01)

#define KSV_FORWARD_MASK	(BIT_4)
#define KSV_FORWARD_ENABLE	(0x10)
#define KSV_FORWARD_DISABLE	(0x00)

// HDCP BKSV Registers
#define TPI_BKSV_1_REG	(0x2B)
#define TPI_BKSV_2_REG	(0x2C)
#define TPI_BKSV_3_REG	(0x2D)
#define TPI_BKSV_4_REG	(0x2E)
#define TPI_BKSV_5_REG	(0x2F)

// HDCP Revision Data Register
#define TPI_HDCP_REVISION_DATA_REG	(0x30)

#define HDCP_MAJOR_REVISION_MASK	(BIT_7 | BIT_6 | BIT_5 | BIT_4)
#define HDCP_MAJOR_REVISION_VALUE	(0x10)

#define HDCP_MINOR_REVISION_MASK	(BIT_3 | BIT_2 | BIT_1 | BIT_0)
#define HDCP_MINOR_REVISION_VALUE	(0x02)

// HDCP KSV and V' Value Data Register
#define TPI_V_PRIME_SELECTOR_REG	(0x31)

// V' Value Readback Registers
#define TPI_V_PRIME_7_0_REG	(0x32)
#define TPI_V_PRIME_15_9_REG	(0x33)
#define TPI_V_PRIME_23_16_REG	(0x34)
#define TPI_V_PRIME_31_24_REG	(0x35)

// HDCP AKSV Registers
#define TPI_AKSV_1_REG	(0x36)
#define TPI_AKSV_2_REG	(0x37)
#define TPI_AKSV_3_REG	(0x38)
#define TPI_AKSV_4_REG	(0x39)
#define TPI_AKSV_5_REG	(0x3A)

#define TPI_DEEP_COLOR_GCP	(0x40)

//--------------------------------------------------------------------
// Interrupt Service
// TPI can be configured to generate an interrupt to the host to notify it of
//   various events. The host can either poll for activity or use an interrupt
//   handler routine. TPI generates on a single interrupt (INT) to the host.
//--------------------------------------------------------------------

// Interrupt Enable Register
#define TPI_INTERRUPT_ENABLE_REG	(0x3C)

#define HDCP_AUTH_STATUS_CHANGE_EN_MASK	(BIT_7)
#define HDCP_AUTH_STATUS_CHANGE_DISABLE	(0x00)
#define HDCP_AUTH_STATUS_CHANGE_ENABLE	(0x80)

#define HDCP_VPRIME_VALUE_READY_EN_MASK	(BIT_6)
#define HDCP_VPRIME_VALUE_READY_DISABLE	(0x00)
#define HDCP_VPRIME_VALUE_READY_ENABLE	(0x40)

#define HDCP_SECURITY_CHANGE_EN_MASK	(BIT_5)
#define HDCP_SECURITY_CHANGE_DISABLE	(0x00)
#define HDCP_SECURITY_CHANGE_ENABLE	(0x20)

#define AUDIO_ERROR_EVENT_EN_MASK	(BIT_4)
#define AUDIO_ERROR_EVENT_DISABLE	(0x00)
#define AUDIO_ERROR_EVENT_ENABLE	(0x10)

#define CPI_EVENT_NO_RX_SENSE_MASK	(BIT_3)
#define CPI_EVENT_NO_RX_SENSE_DISABLE	(0x00)
#define CPI_EVENT_NO_RX_SENSE_ENABLE	(0x08)

#define RECEIVER_SENSE_EVENT_EN_MASK	(BIT_1)
#define RECEIVER_SENSE_EVENT_DISABLE	(0x00)
#define RECEIVER_SENSE_EVENT_ENABLE	(0x02)

#define HOT_PLUG_EVENT_EN_MASK	(BIT_0)
#define HOT_PLUG_EVENT_DISABLE	(0x00)
#define HOT_PLUG_EVENT_ENABLE	(0x01)

// Interrupt Status Register
#define TPI_INTERRUPT_STATUS_REG		(0x3D)

#define HDCP_AUTH_STATUS_CHANGE_EVENT_MASK	(BIT_7)
#define HDCP_AUTH_STATUS_CHANGE_EVENT_NO	(0x00)
#define HDCP_AUTH_STATUS_CHANGE_EVENT_YES	(0x80)

#define HDCP_VPRIME_VALUE_READY_EVENT_MASK	(BIT_6)
#define HDCP_VPRIME_VALUE_READY_EVENT_NO	(0x00)
#define HDCP_VPRIME_VALUE_READY_EVENT_YES	(0x40)

#define HDCP_SECURITY_CHANGE_EVENT_MASK		(BIT_5)
#define HDCP_SECURITY_CHANGE_EVENT_NO		(0x00)
#define HDCP_SECURITY_CHANGE_EVENT_YES		(0x20)

#define AUDIO_ERROR_EVENT_MASK	(BIT_4)
#define AUDIO_ERROR_EVENT_NO	(0x00)
#define AUDIO_ERROR_EVENT_YES	(0x10)

#define CPI_EVENT_MASK		(BIT_3)
#define CPI_EVENT_NO		(0x00)
#define CPI_EVENT_YES		(0x08)
#define RX_SENSE_MASK		(BIT_3) // This bit is dual purpose depending on the value of 0x3C[3]
#define RX_SENSE_NOT_ATTACHED	(0x00)
#define RX_SENSE_ATTACHED	(0x08)

#define HOT_PLUG_PIN_STATE_MASK	(BIT_2)
#define HOT_PLUG_PIN_STATE_LOW	(0x00)
#define HOT_PLUG_PIN_STATE_HIGH	(0x04)

#define RECEIVER_SENSE_EVENT_MASK	(BIT_1)
#define RECEIVER_SENSE_EVENT_NO		(0x00)
#define RECEIVER_SENSE_EVENT_YES	(0x02)

#define HOT_PLUG_EVENT_MASK	(BIT_0)
#define HOT_PLUG_EVENT_NO	(0x00)
#define HOT_PLUG_EVENT_YES	(0x01)

/// KSV FIFO First Status Register
#define TPI_KSV_FIFO_READY_INT	(0x3E)

#define KSV_FIFO_READY_MASK	(BIT_1)
#define KSV_FIFO_READY_NO	(0x00)
#define KSV_FIFO_READY_YES	(0x02)

#define TPI_KSV_FIFO_READY_INT_EN	(0x3F)

#define KSV_FIFO_READY_EN_MASK	(BIT_1)
#define KSV_FIFO_READY_DISABLE	(0x00)
#define KSV_FIFO_READY_ENABLE	(0x02)

/// KSV FIFO Last Status Register
#define TPI_KSV_FIFO_STATUS_REG	(0x41)
#define TPI_KSV_FIFO_VALUE_REG	(0x42)

#define KSV_FIFO_LAST_MASK	(BIT_7)
#define KSV_FIFO_LAST_NO	(0x00)
#define KSV_FIFO_LAST_YES	(0x80)

#define KSV_FIFO_COUNT_MASK	(BIT_4 | BIT_3 | BIT_2 | BIT_1 | BIT_0)

// Sync Register Configuration and Sync Monitoring Registers
#define TPI_SYNC_GEN_CTRL	(0x60)
#define TPI_SYNC_POLAR_DETECT	(0x61)

// Explicit Sync DE Generator Registers (TPI 0x60[7]=0)
#define TPI_DE_DLY	(0x62)
#define TPI_DE_CTRL	(0x63)
#define TPI_DE_TOP	(0x64)

#define TPI_RESERVED4	(0x65)

#define TPI_DE_CNT_7_0	(0x66)
#define TPI_DE_CNT_11_8	(0x67)

#define TPI_DE_LIN_7_0	(0x68)
#define TPI_DE_LIN_10_8	(0x69)

#define TPI_DE_H_RES_7_0	(0x6A)
#define TPI_DE_H_RES_10_8	(0x6B)

#define TPI_DE_V_RES_7_0	(0x6C)
#define TPI_DE_V_RES_10_8	(0x6D)

// Embedded Sync Register Set (TPI 0x60[7]=1)
#define TPI_HBIT_TO_HSYNC_7_0	(0x62)
#define TPI_HBIT_TO_HSYNC_9_8	(0x63)
#define TPI_FIELD_2_OFFSET_7_0	(0x64)
#define TPI_FIELD_2_OFFSET_11_8	(0x65)
#define TPI_HWIDTH_7_0		(0x66)
#define TPI_HWIDTH_8_9		(0x67)
#define TPI_VBIT_TO_VSYNC	(0x68)
#define TPI_VWIDTH		(0x69)

// H/W Optimization Control Registers
#define TPI_HW_OPT_CTRL_1	(0xB9)
#define TPI_HW_OPT_CTRL_2	(0xBA)
#define TPI_HW_OPT_CTRL_3	(0xBB)

// H/W Optimization Control Register #3 Set
#define DDC_DELAY_BIT9_MASK	(BIT_7)
#define DDC_DELAY_BIT9_NO	(0x00)
#define DDC_DELAY_BIT9_YES	(0x80)
#define RI_CHECK_SKIP_MASK	(BIT_3)
#define RI_CHECK_SKIP_NO	(0x00)
#define RI_CHECK_SKIP_YES	(0x08)

// TPI Enable Register
#define TPI_ENABLE	(0xC7)

// Misc InfoFrames
#define MISC_INFO_FRAMES_CTRL	(0xBF)
#define MISC_INFO_FRAMES_TYPE	(0xC0)
#define MISC_INFO_FRAMES_VER	(0xC1)
#define MISC_INFO_FRAMES_LEN	(0xC2)
#define MISC_INFO_FRAMES_CHKSUM	(0xC3)

#endif /* SIHDMITX_902X_TPI_H */
