/*
 *  linux/arch/arm/mach-dmw/sec-fiq.S
 *
 *  Copyright (C) 2010 DSP Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include <linux/linkage.h>
#include <asm/assembler.h>
#include <mach/platform.h>
	.text

/*
 * the below code expects the following values in the following registers:
 * r9:  handler to call
 * r10: base address of the INTC
 */

	.global dw_sec_fiqasm_start
ENTRY(dw_sec_fiqasm_start)
1:	stmdb	sp!, {r0-r12, lr}

	/* clear interrupt in intc (intc base is at r10) */
	mov	r0, #(1 << 19)
	str	r0, [r10, #DMW_PLICU_CH_CLR_INT1]

	/* call handler */
	blx	r9

	ldmia	sp!, {r0-r12, lr}
	subs	pc, lr, #4
ENTRY(dw_sec_fiqasm_end)

