/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;

public class OptionalCompositeOption
implements CompositeOption {
    private final Condition condition;
    private final DefaultCompositeOption composite;

    public OptionalCompositeOption(Condition condition) {
        this.condition = condition;
        this.composite = new DefaultCompositeOption();
    }

    public OptionalCompositeOption(boolean condition) {
        this(new BooleanCondition(condition));
    }

    public OptionalCompositeOption useOptions(Option ... options) {
        this.composite.add(options);
        return this;
    }

    @Override
    public Option[] getOptions() {
        if (this.condition.evaluate()) {
            return this.composite.getOptions();
        }
        return new Option[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.composite == null ? 0 : this.composite.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionalCompositeOption other = (OptionalCompositeOption)obj;
        if (this.composite == null ? other.composite != null : !this.composite.equals(other.composite)) {
            return false;
        }
        return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
    }

    public static class BooleanCondition
    implements Condition {
        private final boolean condition;

        public BooleanCondition(boolean condition) {
            this.condition = condition;
        }

        @Override
        public boolean evaluate() {
            return this.condition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.condition ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanCondition other = (BooleanCondition)obj;
            return this.condition == other.condition;
        }
    }

    public static interface Condition {
        public boolean evaluate();
    }
}

