/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.LenientConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultSelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSetResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.internal.resolve.ArtifactResolveException;

public class DefaultLenientConfiguration
implements LenientConfigurationInternal {
    private final ResolutionHost resolutionHost;
    private final VisitedGraphResults graphResults;
    private final VisitedArtifactSet artifactResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final TransientConfigurationResultsLoader transientConfigurationResultsFactory;
    private final ResolvedArtifactSetResolver artifactSetResolver;
    private final ArtifactSelectionSpec implicitSelectionSpec;
    private SelectedArtifactResults artifactsForThisConfiguration;

    public DefaultLenientConfiguration(ResolutionHost resolutionHost, VisitedGraphResults graphResults, VisitedArtifactSet artifactResults, VisitedFileDependencyResults fileDependencyResults, TransientConfigurationResultsLoader transientConfigurationResultsLoader, ResolvedArtifactSetResolver artifactSetResolver, ArtifactSelectionSpec implicitSelectionSpec) {
        this.resolutionHost = resolutionHost;
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.fileDependencyResults = fileDependencyResults;
        this.transientConfigurationResultsFactory = transientConfigurationResultsLoader;
        this.artifactSetResolver = artifactSetResolver;
        this.implicitSelectionSpec = implicitSelectionSpec;
    }

    private SelectedArtifactResults getSelectedArtifacts() {
        if (this.artifactsForThisConfiguration == null) {
            this.artifactsForThisConfiguration = this.artifactResults.selectLegacy(this.implicitSelectionSpec, true);
        }
        return this.artifactsForThisConfiguration;
    }

    @Override
    public SelectedArtifactSet select(final Spec<? super Dependency> dependencySpec) {
        final SelectedArtifactResults artifactResults = this.artifactResults.selectLegacy(this.implicitSelectionSpec, false);
        return new SelectedArtifactSet(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                this.getDelegate(artifactResults.getArtifacts()).visitDependencies(context);
            }

            @Override
            public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
                ResolvedArtifactSet filteredArtifacts = DefaultLenientConfiguration.this.resolveFilteredArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults);
                this.getDelegate(filteredArtifacts).visitArtifacts(visitor, continueOnSelectionFailure);
            }

            private DefaultSelectedArtifactSet getDelegate(ResolvedArtifactSet filteredArtifacts) {
                return new DefaultSelectedArtifactSet(DefaultLenientConfiguration.this.artifactSetResolver, DefaultLenientConfiguration.this.graphResults, filteredArtifacts, DefaultLenientConfiguration.this.resolutionHost);
            }
        };
    }

    @Override
    public ArtifactSelectionSpec getImplicitSelectionSpec() {
        return this.implicitSelectionSpec;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.graphResults.getUnresolvedDependencies();
    }

    private TransientConfigurationResults loadTransientGraphResults(SelectedArtifactResults artifactResults) {
        return this.transientConfigurationResultsFactory.create(artifactResults);
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.loadTransientGraphResults(this.getSelectedArtifacts()).getFirstLevelDependencies().values()) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    @Deprecated
    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFirstLevelModuleDependencies(Spec)").withAdvice("Use getFirstLevelModuleDependencies() instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    private Set<DependencyGraphNodeResult> getFirstLevelNodes(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<DependencyGraphNodeResult> matches = new LinkedHashSet<DependencyGraphNodeResult>();
        TransientConfigurationResults graphResults = this.loadTransientGraphResults(this.getSelectedArtifacts());
        for (Map.Entry<Dependency, DependencyGraphNodeResult> entry : graphResults.getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList(this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren());
        while (!workQueue.isEmpty()) {
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item)) continue;
            Set children = item.getChildren();
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    @Deprecated
    public Set<File> getFiles() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFiles()").withAdvice("Use a lenient ArtifactView instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_legacy_configuration_get_files")).nagUser();
        LenientFilesAndArtifactResolveVisitor visitor = new LenientFilesAndArtifactResolveVisitor();
        this.artifactSetResolver.visitArtifacts(this.getSelectedArtifacts().getArtifacts(), visitor, this.resolutionHost);
        this.resolutionHost.rethrowFailuresAndReportProblems("files", visitor.getFailures());
        return visitor.files;
    }

    @Deprecated
    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getFiles(Spec)").withAdvice("Use a lenient ArtifactView with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        LenientFilesAndArtifactResolveVisitor visitor = new LenientFilesAndArtifactResolveVisitor();
        ResolvedArtifactSet filteredArtifacts = this.resolveFilteredArtifacts(dependencySpec, this.getSelectedArtifacts());
        this.artifactSetResolver.visitArtifacts(filteredArtifacts, visitor, this.resolutionHost);
        this.resolutionHost.rethrowFailuresAndReportProblems("files", visitor.getFailures());
        return visitor.files;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        LenientArtifactCollectingVisitor visitor = new LenientArtifactCollectingVisitor();
        this.artifactSetResolver.visitArtifacts(this.getSelectedArtifacts().getArtifacts(), visitor, this.resolutionHost);
        this.resolutionHost.rethrowFailuresAndReportProblems("artifacts", visitor.getFailures());
        return visitor.artifacts;
    }

    @Deprecated
    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(LenientConfiguration.class, (String)"getArtifacts(Spec)").withAdvice("Use a lenient ArtifactView with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        LenientArtifactCollectingVisitor visitor = new LenientArtifactCollectingVisitor();
        ResolvedArtifactSet filteredArtifacts = this.resolveFilteredArtifacts(dependencySpec, this.getSelectedArtifacts());
        this.artifactSetResolver.visitArtifacts(filteredArtifacts, visitor, this.resolutionHost);
        this.resolutionHost.rethrowFailuresAndReportProblems("artifacts", visitor.getFailures());
        return visitor.artifacts;
    }

    private ResolvedArtifactSet resolveFilteredArtifacts(Spec<? super Dependency> dependencySpec, SelectedArtifactResults artifactResults) {
        ArrayList<ResolvedArtifactSet> artifactSets = new ArrayList<ResolvedArtifactSet>();
        for (Map.Entry<FileCollectionDependency, Integer> entry : this.fileDependencyResults.getFirstLevelFiles().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            artifactSets.add(artifactResults.getArtifactsWithId(entry.getValue()));
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph(artifactSets));
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            walker.add((Object[])new DependencyGraphNodeResult[]{node});
        }
        walker.findValues();
        return CompositeResolvedArtifactSet.of(artifactSets);
    }

    private static class LenientFilesAndArtifactResolveVisitor
    extends LenientArtifactCollectingVisitor {
        private LenientFilesAndArtifactResolveVisitor() {
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            return FileCollectionStructureVisitor.VisitType.Visit;
        }
    }

    private static class LenientArtifactCollectingVisitor
    implements ArtifactVisitor {
        final Set<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        final Set<File> files = new LinkedHashSet<File>();
        List<Throwable> failures;

        private LenientArtifactCollectingVisitor() {
        }

        @Override
        public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
            try {
                ResolvedArtifact resolvedArtifact = artifact.toPublicView();
                this.files.add(resolvedArtifact.getFile());
                this.artifacts.add(resolvedArtifact);
            }
            catch (ArtifactResolveException resolvedArtifact) {
            }
            catch (Exception e) {
                this.visitFailure(e);
            }
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            if (source instanceof LocalDependencyFiles) {
                return FileCollectionStructureVisitor.VisitType.NoContents;
            }
            return FileCollectionStructureVisitor.VisitType.Visit;
        }

        @Override
        public boolean requireArtifactFiles() {
            return false;
        }

        @Override
        public void visitFailure(Throwable failure) {
            if (this.failures == null) {
                this.failures = new ArrayList<Throwable>();
            }
            this.failures.add(failure);
        }

        public List<Throwable> getFailures() {
            return this.failures != null ? this.failures : Collections.emptyList();
        }
    }

    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<DependencyGraphNodeResult, ResolvedArtifact> {
        private final List<ResolvedArtifactSet> dest;

        ResolvedDependencyArtifactsGraph(List<ResolvedArtifactSet> dest) {
            this.dest = dest;
        }

        public void getNodeValues(DependencyGraphNodeResult node, Collection<? super ResolvedArtifact> values, Collection<? super DependencyGraphNodeResult> connectedNodes) {
            connectedNodes.addAll(node.getOutgoingEdges());
            this.dest.add(node.getArtifactsForNode());
        }

        public void getEdgeValues(DependencyGraphNodeResult from, DependencyGraphNodeResult to, Collection<ResolvedArtifact> values) {
        }
    }
}

