/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.base;

import com.jgoodies.common.base.Strings;
import java.util.List;
import java.util.Objects;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean expression, String messageFormat, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(messageFormat, messageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, String message) {
        return Objects.requireNonNull(reference, message);
    }

    public static <T> T checkNotNull(T reference, String messageFormat, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageFormat, messageArgs));
        }
        return reference;
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean expression, String messageFormat, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(messageFormat, messageArgs));
        }
    }

    public static <S extends CharSequence> S checkNotBlank(S str, String message) {
        Preconditions.checkNotNull(str, message);
        Preconditions.checkArgument(Strings.isNotBlank(str), message);
        return str;
    }

    public static <S extends CharSequence> S checkNotBlank(S str, String messageFormat, Object ... messageArgs) {
        Preconditions.checkNotNull(str, messageFormat, messageArgs);
        Preconditions.checkArgument(Strings.isNotBlank(str), messageFormat, messageArgs);
        return str;
    }

    public static <T> T[] checkNotNullOrEmpty(T[] reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        if (reference.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return reference;
    }

    public static <T> T[] checkNotNullOrEmpty(T[] reference, String messageFormat, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageFormat, messageArgs));
        }
        if (reference.length == 0) {
            throw new IllegalArgumentException(String.format(messageFormat, messageArgs));
        }
        return reference;
    }

    public static <T> List<T> checkNotNullOrEmpty(List<T> reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        if (reference.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return reference;
    }

    public static <T> List<T> checkNotNullOrEmpty(List<T> reference, String messageFormat, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageFormat, messageArgs));
        }
        if (reference.isEmpty()) {
            throw new IllegalArgumentException(String.format(messageFormat, messageArgs));
        }
        return reference;
    }
}

