/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void collapseAllSiblings(JTree tree, TreePath aPath) {
        TreeModel model = tree.getModel();
        Object node = aPath.getLastPathComponent();
        TreeUtils.collapseChildren(tree, aPath);
        for (TreePath path = aPath.getParentPath(); path != null; path = path.getParentPath()) {
            Object parent = path.getLastPathComponent();
            int siblingCount = model.getChildCount(parent);
            for (int i = 0; i < siblingCount; ++i) {
                Object aSibling = model.getChild(parent, i);
                if (aSibling == node) continue;
                TreePath siblingPath = path.pathByAddingChild(aSibling);
                tree.collapsePath(siblingPath);
            }
            node = parent;
        }
    }

    public static void collapseChildren(JTree tree, TreePath path) {
        TreeModel model = tree.getModel();
        Object parent = path.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(parent, i);
            TreePath childPath = path.pathByAddingChild(child);
            tree.collapsePath(childPath);
        }
        tree.collapsePath(path);
    }

    public static void expand(JTree tree, int maxLevelToExpand) {
        for (int level = 0; level < maxLevelToExpand; ++level) {
            for (int row = tree.getRowCount(); row >= 0; --row) {
                tree.expandRow(row);
            }
        }
    }

    public static void expandTopLevel(JTree tree) {
        TreeUtils.expand(tree, 1);
    }
}

