/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.internal.BuilderSupport;
import com.jgoodies.common.swing.internal.IActionObject;
import com.jgoodies.components.JGToolBarButton;
import com.jgoodies.components.JGToolBarSplitButton;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.components.util.OSXComponentProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class ToolBarBuilder {
    private final BuilderSupport support = new BuilderSupport();
    private JToolBar toolBar;
    private IActionObject actionProvider;
    private boolean registerKeyboardActions = false;

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            ToolBarBuilder.configureToolBar(this.toolBar);
        }
        return this.toolBar;
    }

    private static void configureToolBar(JToolBar toolBar) {
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
    }

    private Component add(Component component) {
        return this.getToolBar().add(component);
    }

    public JToolBar build() {
        return this.getToolBar();
    }

    public ToolBarBuilder toolBar(JToolBar toolBar) {
        this.support.checkNotCalledTwice("toolBar");
        this.toolBar = toolBar;
        return this;
    }

    public ToolBarBuilder actionProvider(IActionObject actionProvider) {
        this.support.checkNotCalledTwice("actionProvider");
        this.actionProvider = actionProvider;
        return this;
    }

    public ToolBarBuilder clientProperty(Object key, Object value) {
        this.getToolBar().putClientProperty(key, value);
        return this;
    }

    public ToolBarBuilder border(Border border) {
        this.support.checkNotCalledTwice("border");
        this.getToolBar().setBorder(border);
        return this;
    }

    public ToolBarBuilder padding(EmptyBorder padding) {
        this.support.checkNotCalledTwice("padding");
        this.getToolBar().setBorder(padding);
        return this;
    }

    public ToolBarBuilder opaque(boolean opaque) {
        this.support.checkNotCalledTwice("opaque");
        this.getToolBar().setOpaque(opaque);
        return this;
    }

    public ToolBarBuilder registerKeyboardActions(boolean b) {
        this.support.checkNotCalledTwice("registerKeyboardActions");
        this.registerKeyboardActions = b;
        return this;
    }

    public ToolBarBuilder doWith(Consumer<ToolBarBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public ToolBarBuilder gap() {
        return this.gap(6);
    }

    public ToolBarBuilder largeGap() {
        return this.gap(12);
    }

    public ToolBarBuilder gap(int size) {
        this.add(Box.createRigidArea(new Dimension(size, size)));
        return this;
    }

    public ToolBarBuilder glue() {
        this.add(Box.createGlue());
        return this;
    }

    public ToolBarBuilder separator() {
        this.getToolBar().addSeparator();
        return this;
    }

    public ToolBarBuilder button(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(this.getToolBar().isOpaque());
        }
        this.add(component);
        return this;
    }

    public ToolBarBuilder segmented(AbstractButton ... buttons) {
        Preconditions.checkNotNull(buttons, "The %s must not be null.", "components array");
        Preconditions.checkArgument(buttons.length >= 2, "You must provide at least two components.");
        for (int i = 0; i < buttons.length; ++i) {
            AbstractButton button = buttons[i];
            OSXComponentProperties.setSegmentedTypeAndPosition(button, OSXComponentProperties.SegmentedButtonType.TEXTURED, i, buttons.length);
            this.add(button);
        }
        return this;
    }

    public ToolBarBuilder splitButton(Action action, JPopupMenu popupMenu) {
        JGToolBarSplitButton button = new JGToolBarSplitButton(action, popupMenu);
        button.setOpaque(this.getToolBar().isOpaque());
        OSXComponentProperties.setButtonType(button, OSXComponentProperties.ButtonType.TEXTURED);
        if (this.registerKeyboardActions) {
            ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        }
        this.add(button);
        return this;
    }

    public ToolBarBuilder action(Action action) {
        Preconditions.checkNotNull(action, "The %s must not be null.", "action");
        JGToolBarButton button = new JGToolBarButton(action);
        button.setOpaque(this.getToolBar().isOpaque());
        OSXComponentProperties.setButtonType(button, OSXComponentProperties.ButtonType.TEXTURED);
        if (this.registerKeyboardActions) {
            ComponentUtils.registerKeyboardAction((JComponent)button, action, 2);
        }
        this.add(button);
        return this;
    }

    public ToolBarBuilder action(String actionName) {
        return this.action(this.getActionProvider(), actionName);
    }

    public ToolBarBuilder action(IActionObject actionProvider, String actionName) {
        Preconditions.checkNotNull(actionProvider, "The %s must not be null.", "action provider");
        Preconditions.checkNotNull(actionName, "The %s must not be null.", "action name");
        return this.action(actionProvider.getAction(actionName));
    }

    private IActionObject getActionProvider() {
        Preconditions.checkNotNull(this.actionProvider, "To use the #action(String) feature, a default action provider must be set, see #actionProvider.");
        return this.actionProvider;
    }
}

