/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.application.Action;
import com.jgoodies.application.Application;
import com.jgoodies.common.jsdl.action.ActionBean;
import com.jgoodies.framework.builder.PopupMenuBuilder;
import com.jgoodies.framework.util.History;
import com.jgoodies.jdiskreport.gui.application.JDApplicationModel;
import com.jgoodies.jdiskreport.gui.application.JDNavigationModel;
import com.jgoodies.jdiskreport.gui.application.JDPresentationModel;
import com.jgoodies.jdiskreport.gui.application.JDResources;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.RootNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.search.CompletionApplicationEvent;
import com.jgoodies.search.ValueCompletion;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import javax.swing.JPopupMenu;

public final class JDResultModel
extends ActionBean {
    public static final String PROPERTY_ROOT_NODE = "rootNode";
    public static final String PROPERTY_DETAILS_VISIBLE = "detailsVisible";
    static final String ACTION_UP = "Up";
    static final String ACTION_OPEN_FOLDER_IN_FILE_VIEW = "OpenFolderInFileView";
    static final String ACTION_DELETE_SELECTED_FOLDER = "DeleteSelectedFolder";
    static final String ACTION_SHOW_SIZE_PIE = "ShowSizePie";
    static final String ACTION_SHOW_LARGEST_TABLE = "ShowLargestTable";
    static final String ACTION_SHOW_SIZE_RING = "ShowSizeRing";
    static final String ACTION_SHOW_SIZE_MAP = "ShowSizeMap";
    static final String ACTION_SHOW_DISTRIBUTION_BAR = "ShowDistributionBar";
    static final String ACTION_SHOW_ACCESS_BAR = "ShowAccessBar";
    static final String ACTION_SHOW_MODIFIED_BAR = "ShowModifiedBar";
    static final String ACTION_SHOW_TYPES_PIE = "ShowTypesPie";
    static final String ACTION_SHOW_DETAILS = "ShowDetails";
    static final String ACTION_SORT_BY_SIZE = "SortBySize";
    static final String ACTION_SORT_BY_NAME = "SortByName";
    static final String ACTION_SHOW_COUNT = "ShowCount";
    static final String ACTION_SHOW_SIZE = "ShowSize";
    static final String ACTION_SHOW_FILES = "ShowFiles";
    private static final boolean DETAILS_VISIBLE_DEFAULT = false;
    private static JDResources resources = JDResources.getInstance();
    private final History<DirectoryNode> history;
    private final JDNavigationModel navigationModel;
    private JDPresentationModel presentationModel;
    private final GUISettings guiSettings;
    private final Preferences detailsVisibleNode = Application.getInstance().getContext().getUserPreferences(JDResultModel.class);
    private RootNode rootNode;
    private boolean detailsVisible;

    public JDResultModel(RootNode rootNode) {
        this.rootNode = rootNode;
        this.history = new History(10);
        this.guiSettings = new GUISettings();
        this.navigationModel = new JDNavigationModel(this);
        this.detailsVisible = this.detailsVisibleNode.getBoolean("details_visible", false);
        this.updateShowDetailsAction();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.navigationModel.addPropertyChangeListener("selection", this::onSelectionChanged);
    }

    public History<DirectoryNode> getHistory() {
        return this.history;
    }

    public JDNavigationModel getNavigationModel() {
        return this.navigationModel;
    }

    public JDPresentationModel getPresentationModel() {
        if (this.presentationModel == null) {
            this.presentationModel = new JDPresentationModel(this);
        }
        return this.presentationModel;
    }

    public GUISettings getGuiSettings() {
        return this.guiSettings;
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(RootNode newRootNode) {
        RootNode oldRootNode = this.getRootNode();
        this.rootNode = newRootNode;
        this.navigationModel.updateRoot(this.rootNode);
        this.history.reset();
        this.history.setHome(newRootNode);
        this.history.setSelection(newRootNode);
        this.firePropertyChange(PROPERTY_ROOT_NODE, oldRootNode, newRootNode);
    }

    public Path getRootPath() {
        return Paths.get(this.rootNode.getPathName(), new String[0]);
    }

    public boolean isDetailsVisible() {
        return this.detailsVisible;
    }

    public void setDetailsVisible(boolean b) {
        this.detailsVisible = b;
        this.firePropertyChange(PROPERTY_DETAILS_VISIBLE, this.detailsVisible, this.detailsVisible);
        this.detailsVisibleNode.putBoolean("details_visible", this.detailsVisible);
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        boolean hasSelection = this.navigationModel.getSelection() != null;
        this.setActionsEnabled(this.navigationModel.isUpPossible(), ACTION_UP);
        this.setActionsEnabled(hasSelection, ACTION_OPEN_FOLDER_IN_FILE_VIEW, ACTION_DELETE_SELECTED_FOLDER);
    }

    void onCompletionApplied(CompletionApplicationEvent event) {
        ValueCompletion completion = (ValueCompletion)event.getCompletion();
        DirectoryNode node = (DirectoryNode)completion.getValue();
        this.navigationModel.setSelectionPathTo(node);
    }

    @Action(enabled=false)
    public void onUpPerformed(ActionEvent evt) {
        this.navigationModel.goUp();
    }

    @Action(enabled=false)
    public void onOpenFolderInFileViewPerformed(ActionEvent evt) {
        JDApplicationModel.openPathInFileView(evt, this.getNavigationModel().getSelection().getPathName());
    }

    @Action(enabled=false)
    public void onDeleteSelectedFolderPerformed(ActionEvent evt) {
        DirectoryNode selection = this.getNavigationModel().getSelection();
        JDApplicationModel.deleteFolder(evt, selection);
    }

    @Action
    public void onShowSizePiePerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.SIZE_PIE);
    }

    @Action
    public void onShowSizeRingPerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.SIZE_SUNBURST);
    }

    @Action
    public void onShowSizeMapPerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.SIZE_TREE_MAP);
    }

    @Action
    public void onShowLargestTablePerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.TOP50_LARGEST);
    }

    @Action
    public void onShowDistributionBarPerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.SIZE_DISTRIBUTION_BAR);
    }

    @Action
    public void onShowAccessBarPerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.ACCESSED_DISTRIBUTION_BAR);
    }

    @Action
    public void onShowModifiedBarPerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.MODIFIED_DISTRIBUTION_BAR);
    }

    @Action
    public void onShowTypesPiePerformed(ActionEvent evt) {
        this.getGuiSettings().setViewMode(GUISettings.ViewMode.TYPE_DISTRIBUTION_PIE);
    }

    @Action
    public void onShowDetailsPerformed(ActionEvent evt) {
        this.setDetailsVisible(!this.isDetailsVisible());
        this.updateShowDetailsAction();
    }

    @Action
    public static void onSortBySizePerformed(ActionEvent evt) {
    }

    @Action
    public static void onSortByNamePerformed(ActionEvent evt) {
    }

    @Action
    public static void onShowSizePerformed(ActionEvent evt) {
    }

    @Action
    public static void onShowCountPerformed(ActionEvent evt) {
    }

    @Action
    public static void onShowFilesPerformed(ActionEvent evt) {
    }

    JPopupMenu getExtrasMenu() {
        return new PopupMenuBuilder().actionProvider(this).action(ACTION_SHOW_DETAILS).separator().action("Preferences").action("About").build();
    }

    private void updateShowDetailsAction() {
        javax.swing.Action action = this.getAction(ACTION_SHOW_DETAILS);
        action.putValue("Name", this.isDetailsVisible() ? JDResultModel.resources.hideDetails_text : JDResultModel.resources.showDetails_text);
    }
}

