/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.shared.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public final class ScrollPaneBorder
extends AbstractBorder {
    private final boolean top;
    private final boolean left;
    private final boolean bottom;
    private final boolean right;
    private final Insets insets;

    public ScrollPaneBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.insets = new Insets(top ? 1 : 0, left ? 1 : 0, bottom ? 1 : 0, right ? 1 : 0);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    private static Color getShadowColor() {
        Color unifiedShadow = new Color(204, 204, 204);
        return unifiedShadow != null ? unifiedShadow : UIManager.getColor("controlShadow");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        Color shadow = ScrollPaneBorder.getShadowColor();
        g.translate(x, y);
        g.setColor(shadow);
        if (this.top) {
            g.drawLine(0, 0, w - 1, 0);
        }
        if (this.left) {
            g.drawLine(0, 0, 0, h - 1);
        }
        if (this.right) {
            g.drawLine(w - 1, 0, w - 1, h - 1);
        }
        if (this.bottom) {
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
        g.translate(-x, -y);
    }
}

