/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation.internal;

import com.jgoodies.navigation.views.FocusTracker;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class FocusTrackerSupport {
    private WeakReference<Component> mostRecentFocusOwnerRef;
    private static final String PERMANENT_FOCUS_OWNER_PROPERTY = "permanentFocusOwner";

    public void requestInitialFocus(Container c) {
        if (!FocusTrackerSupport.isInitialFocusRequested(c)) {
            return;
        }
        Component focusOwner = this.getMostRecentFocusOwner(c);
        if (focusOwner != null) {
            focusOwner.requestFocusInWindow();
        }
    }

    public static boolean isInitialFocusRequested(Container c) {
        return c instanceof JComponent && !Boolean.FALSE.equals(((JComponent)c).getClientProperty("initialFocusRequested"));
    }

    public static void setInitialFocusRequested(Container c, boolean b) {
        if (!(c instanceof JComponent)) {
            return;
        }
        ((JComponent)c).putClientProperty("initialFocusRequested", b);
    }

    private Component getMostRecentFocusOwner(Container container) {
        Component mostRecentFocusOwner;
        if (this.mostRecentFocusOwnerRef != null && (mostRecentFocusOwner = (Component)this.mostRecentFocusOwnerRef.get()) != null) {
            return mostRecentFocusOwner;
        }
        return FocusTrackerSupport.getInitialFocusOwner(container);
    }

    private static Component getInitialFocusOwner(Container c) {
        FocusTraversalPolicy policy = FocusTrackerSupport.getFocusTraversalPolicy(c);
        if (policy == null) {
            return c;
        }
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window == null) {
            return c;
        }
        Component initialComponent = policy.getInitialComponent(window);
        if (initialComponent != null) {
            return initialComponent;
        }
        return c;
    }

    private static FocusTraversalPolicy getFocusTraversalPolicy(Container c) {
        if (c.isFocusTraversalPolicyProvider()) {
            return c.getFocusTraversalPolicy();
        }
        Container rootAncestor = c.getFocusCycleRootAncestor();
        Container comp = c;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor == null) {
            return null;
        }
        return rootAncestor.getFocusTraversalPolicy();
    }

    public void setMostRecentFocusOwner(Container container, Component newFocusOwner) {
        if (container != null && container.isAncestorOf(newFocusOwner)) {
            this.mostRecentFocusOwnerRef = new WeakReference<Component>(newFocusOwner);
        }
    }

    public static void trackFocusFor(FocusTracker tracker) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, new WeakPCL(tracker));
    }

    private static class WeakPCL
    implements PropertyChangeListener {
        private final WeakReference<FocusTracker> trackerRef;

        WeakPCL(FocusTracker tracker) {
            this.trackerRef = new WeakReference<FocusTracker>(tracker);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            assert (ev.getPropertyName().equals(FocusTrackerSupport.PERMANENT_FOCUS_OWNER_PROPERTY));
            FocusTracker tracker = (FocusTracker)this.trackerRef.get();
            if (tracker == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FocusTrackerSupport.PERMANENT_FOCUS_OWNER_PROPERTY, this);
                return;
            }
            tracker.setMostRecentFocusOwner((Component)ev.getNewValue());
        }
    }
}

