/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionApplicationEvent;
import com.jgoodies.search.CompletionApplicationListener;
import com.jgoodies.search.CompletionInfoRenderer;
import com.jgoodies.search.CompletionProcessEvent;
import com.jgoodies.search.CompletionProcessListener;
import com.jgoodies.search.CompletionProcessor;
import com.jgoodies.search.CompletionPublisher;
import com.jgoodies.search.CompletionState;
import com.jgoodies.search.CompletionUtils;
import com.jgoodies.search.CompletionView;
import com.jgoodies.search.DefaultCompletionInfoRenderer;
import com.jgoodies.search.DefaultCompletionRenderer;
import com.jgoodies.search.resources.Accessibility;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class CompletionManager {
    public static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    public static final int DEFAULT_ADDITIONAL_INFO_ACTIVATION_DELAY = 100;
    private static final int MAX_VISIBLE_COMPLETIONS = 10;
    private static final StringBuilder COMPLETION_MANAGER_KEY = new StringBuilder("JTextComponent.completionManager");
    private static PropertyChangeListener completionActivationHandler;
    private final CompletionProcessor completionProcessor;
    private boolean modifiable;
    private JTextComponent textComponent;
    private final ListListModel<Completion> completionListModel;
    private final ListSelectionModel completionListSelectionModel;
    private final EventListenerList listenerList;
    private final List<AWTKeyStroke> completionKeyStrokes;
    private DocumentListener documentHandler;
    private List<Completion> publishedCompletions = new ArrayList<Completion>();
    private Object displayedCompletions;
    private Completion pendingCompletion;
    private boolean autoCompletionEnabled = true;
    private boolean prefixCompletionEnabled = true;
    private boolean autoActivationEnabled = true;
    private int autoActivationDelay = 500;
    private int additionalInfoActivationDelay = 100;
    private boolean doubleClickActivationEnabled = true;
    private ListCellRenderer<Object> completionRenderer;
    private Completion completionPrototypeDisplayValue;
    private CompletionInfoRenderer completionInfoRenderer;
    private Completion completionInfoPrototypeDisplayValue;
    private CompletionView completionView;
    private Timer autoActivationTimer;
    private boolean autoInsertAllowed;
    private FocusListener focusHandler;
    private MouseListener doubleClickHandler;
    private KeyListener keyHandler;
    private CompletionProcessorWorker updateCompletionsAfterUserRequestWorker;
    private CompletionProcessorWorker updateCompletionsAfterAutoActivationWorker;
    private static final KeyStroke CTRL_SPACE;
    private static final KeyStroke ENTER;
    private static final KeyStroke ESCAPE;
    private static final KeyStroke UP;
    private static final KeyStroke DOWN;
    private static final KeyStroke PAGE_UP;
    private static final KeyStroke PAGE_DOWN;

    public CompletionManager(CompletionProcessor completionProcessor) {
        Preconditions.checkNotNull(completionProcessor, "The %s must not be null.", "completion processor");
        this.completionProcessor = completionProcessor;
        this.modifiable = true;
        this.completionListModel = new ListListModel();
        this.completionListSelectionModel = new DefaultListSelectionModel();
        this.completionListSelectionModel.setSelectionMode(0);
        this.listenerList = new EventListenerList();
        this.completionKeyStrokes = new ArrayList<AWTKeyStroke>();
        this.completionKeyStrokes.add(CTRL_SPACE);
        CompletionManager.ensureTextCompletionSupportInstalled();
    }

    public static CompletionManager unmodifiableManager(CompletionManager manager) {
        if (!manager.modifiable) {
            return manager;
        }
        CompletionManager unmodifiable = new CompletionManager(manager.getProcessor());
        unmodifiable.setAutoCompletionEnabled(manager.isAutoCompletionEnabled());
        unmodifiable.setPrefixCompletionEnabled(manager.isPrefixCompletionEnabled());
        unmodifiable.setAutoActivationEnabled(manager.isAutoActivationEnabled());
        unmodifiable.setAutoActivationDelay(manager.getAutoActivationDelay());
        unmodifiable.setAdditionalInfoActivationDelay(manager.getAdditionalInfoActivationDelay());
        unmodifiable.setCompletionPrototypeDisplayValue(manager.getCompletionPrototypeDisplayValue());
        unmodifiable.setCompletionInfoPrototypeDisplayValue(manager.getCompletionInfoPrototypeDisplayValue());
        unmodifiable.setCompletionRenderer(manager.completionRenderer);
        unmodifiable.setCompletionInfoRenderer(manager.getCompletionInfoRenderer());
        unmodifiable.modifiable = false;
        return unmodifiable;
    }

    private static void ensureTextCompletionSupportInstalled() {
        if (completionActivationHandler == null) {
            CompletionManager.installTextCompletionSupport();
        }
    }

    private static void installTextCompletionSupport() {
        completionActivationHandler = CompletionManager::onFocusOwnerChanged;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", completionActivationHandler);
    }

    public static void uninstallTextCompletionSupport() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", completionActivationHandler);
        completionActivationHandler = null;
    }

    public CompletionProcessor getProcessor() {
        return this.completionProcessor;
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionEnabled;
    }

    public void setAutoCompletionEnabled(boolean b) {
        this.checkModifiable();
        this.autoCompletionEnabled = b;
    }

    public boolean isPrefixCompletionEnabled() {
        return this.prefixCompletionEnabled;
    }

    public void setPrefixCompletionEnabled(boolean b) {
        this.checkModifiable();
        this.prefixCompletionEnabled = b;
    }

    public boolean isAutoActivationEnabled() {
        return this.autoActivationEnabled;
    }

    public void setAutoActivationEnabled(boolean b) {
        this.checkModifiable();
        this.autoActivationEnabled = b;
    }

    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    public void setAutoActivationDelay(int delay) {
        this.checkModifiable();
        this.autoActivationDelay = delay;
    }

    public int getAdditionalInfoActivationDelay() {
        return this.additionalInfoActivationDelay;
    }

    public void setAdditionalInfoActivationDelay(int delay) {
        this.checkModifiable();
        this.additionalInfoActivationDelay = delay;
    }

    public boolean isDoubleClickActivationEnabled() {
        return this.doubleClickActivationEnabled;
    }

    public void setDoubleClickActivationEnabled(boolean b) {
        this.checkModifiable();
        this.doubleClickActivationEnabled = b;
    }

    public Completion getCompletionPrototypeDisplayValue() {
        return this.completionPrototypeDisplayValue;
    }

    public void setCompletionPrototypeDisplayValue(String prototypeDisplayString) {
        this.checkModifiable();
        this.setCompletionPrototypeDisplayValue(((Completion.Builder)new Completion.Builder().replacementText(prototypeDisplayString, new Object[0])).build());
    }

    public void setCompletionPrototypeDisplayValue(Completion prototypeDisplayValue) {
        this.checkModifiable();
        this.completionPrototypeDisplayValue = prototypeDisplayValue;
    }

    public Completion getCompletionInfoPrototypeDisplayValue() {
        return this.completionInfoPrototypeDisplayValue;
    }

    public void setCompletionInfoPrototypeDisplayValue(Object prototypeDisplayValue) {
        this.checkModifiable();
        this.setCompletionInfoPrototypeDisplayValue(((Completion.Builder)new Completion.Builder().additionalInfo(prototypeDisplayValue)).build());
    }

    public void setCompletionInfoPrototypeDisplayValue(Completion prototypeDisplayValue) {
        this.checkModifiable();
        this.completionInfoPrototypeDisplayValue = prototypeDisplayValue;
    }

    public ListCellRenderer<Object> getCompletionRenderer() {
        return this.completionRenderer == null ? new DefaultCompletionRenderer() : this.completionRenderer;
    }

    public void setCompletionRenderer(ListCellRenderer<Object> completionRenderer) {
        this.checkModifiable();
        this.completionRenderer = completionRenderer;
    }

    public CompletionInfoRenderer getCompletionInfoRenderer() {
        return this.completionInfoRenderer == null ? new DefaultCompletionInfoRenderer() : this.completionInfoRenderer;
    }

    public void setCompletionInfoRenderer(CompletionInfoRenderer completionInfoRenderer) {
        this.checkModifiable();
        this.completionInfoRenderer = completionInfoRenderer;
    }

    public void registerCompletionKeyStroke(AWTKeyStroke completionKeyStroke) {
        Preconditions.checkNotNull(completionKeyStroke, "The %s must not be null.", "completion key stroke");
        Preconditions.checkArgument(!CTRL_SPACE.equals(completionKeyStroke), "The completion key stroke must not be Ctrl Space, because that key stroke is permanently registered as completion key.");
        this.completionKeyStrokes.add(completionKeyStroke);
    }

    public boolean isCompletionPopupVisible() {
        return this.completionView != null && this.completionView.isVisible();
    }

    public void addCompletionApplicationListener(CompletionApplicationListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.add(CompletionApplicationListener.class, listener);
    }

    public void removeCompletionApplicationListener(CompletionApplicationListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(CompletionApplicationListener.class, listener);
    }

    public void addCompletionProcessListener(CompletionProcessListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.add(CompletionProcessListener.class, listener);
    }

    public void removeCompletionProcessListener(CompletionProcessListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(CompletionProcessListener.class, listener);
    }

    private void applyCompletion(Completion completion) {
        if (completion == null) {
            return;
        }
        JTextComponent component = this.getComponent();
        this.fireCompletionApplied(component, completion);
        this.pendingCompletion = null;
    }

    private void fireCompletionApplied(JTextComponent component, Completion completion) {
        CompletionApplicationListener[] listeners = (CompletionApplicationListener[])this.listenerList.getListeners(CompletionApplicationListener.class);
        CompletionApplicationEvent completionEvent = null;
        for (CompletionApplicationListener listener : listeners) {
            if (completionEvent == null) {
                completionEvent = new CompletionApplicationEvent(component, this, completion);
            }
            listener.completionApplied(completionEvent);
        }
    }

    private boolean searchAllowed() {
        if (!this.isActive()) {
            return false;
        }
        CompletionProcessListener[] listeners = (CompletionProcessListener[])this.listenerList.getListeners(CompletionProcessListener.class);
        JTextComponent component = this.getComponent();
        for (CompletionProcessListener listener : listeners) {
            if (listener.searchAllowed(component)) continue;
            return false;
        }
        return true;
    }

    void fireCompletionProcessStarted(JTextComponent component) {
        this.fireCompletionProcessed(component, CompletionProcessEvent.State.STARTED, null);
    }

    void fireCompletionProcessCancelled(JTextComponent component) {
        this.fireCompletionProcessed(component, CompletionProcessEvent.State.CANCELLED, null);
    }

    void fireCompletionProcessSucceeded(JTextComponent component, List<? extends Completion> completions) {
        this.fireCompletionProcessed(component, CompletionProcessEvent.State.SUCCEEDED, completions);
    }

    private void fireCompletionProcessed(JTextComponent component, CompletionProcessEvent.State state, List<? extends Completion> completions) {
        CompletionProcessListener[] listeners = (CompletionProcessListener[])this.listenerList.getListeners(CompletionProcessListener.class);
        CompletionProcessEvent completionProcessEvent = null;
        for (CompletionProcessListener listener : listeners) {
            if (completionProcessEvent == null) {
                completionProcessEvent = new CompletionProcessEvent(component, this, state, completions);
            }
            listener.completionProcessed(completionProcessEvent);
        }
    }

    public void install(JTextComponent aTextComponent) {
        Preconditions.checkNotNull(aTextComponent, "The %s must not be null.", "text component");
        CompletionManager.storeManager(aTextComponent, this);
    }

    public static void uninstall(JTextComponent aTextComponent) {
        CompletionManager manager = CompletionManager.getManager(aTextComponent);
        if (manager == null) {
            return;
        }
        manager.deactivate();
        CompletionManager.storeManager(aTextComponent, null);
    }

    public static CompletionManager getManager(JTextComponent aTextComponent) {
        return (CompletionManager)aTextComponent.getClientProperty(COMPLETION_MANAGER_KEY);
    }

    private static void storeManager(JTextComponent aTextComponent, CompletionManager completionManager) {
        aTextComponent.putClientProperty(COMPLETION_MANAGER_KEY, completionManager);
    }

    public void activate(JTextComponent aTextComponent) {
        Preconditions.checkNotNull(aTextComponent, "The %s must not be null.", "text component");
        CompletionManager installedManager = CompletionManager.getManager(aTextComponent);
        Preconditions.checkArgument(installedManager != null, "No completion support installed for %s", aTextComponent);
        Preconditions.checkState(installedManager == this, "Activated CompletionManager is not the installed CompletionManager for text component %s.", aTextComponent);
        this.documentHandler = new DocumentHandler();
        this.doubleClickHandler = Listeners.mouseDoubleClicked(this::onMouseDoubleClicked);
        this.focusHandler = Listeners.focusLost(this::onFocusLost);
        this.keyHandler = new KeyHandler();
        this.textComponent = aTextComponent;
        this.completionView = new CompletionView(this);
        this.autoActivationTimer = new Timer(this.getAutoActivationDelay(), this::onAutoActivation);
        this.autoActivationTimer.setRepeats(false);
        this.autoActivationTimer.setCoalesce(true);
        this.textComponent.getDocument().addDocumentListener(this.documentHandler);
        this.textComponent.addMouseListener(this.doubleClickHandler);
        this.textComponent.addFocusListener(this.focusHandler);
        this.textComponent.addKeyListener(this.keyHandler);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.autoActivationTimer.stop();
        this.cancelBackgroundExecution();
        this.hidePopups();
        this.textComponent.getDocument().removeDocumentListener(this.documentHandler);
        this.textComponent.removeMouseListener(this.doubleClickHandler);
        this.textComponent.removeFocusListener(this.focusHandler);
        this.textComponent.removeKeyListener(this.keyHandler);
        this.textComponent = null;
        this.completionView = null;
        this.documentHandler = null;
        this.doubleClickHandler = null;
        this.focusHandler = null;
        this.keyHandler = null;
        this.pendingCompletion = null;
    }

    private boolean isActive() {
        return this.getComponent() != null;
    }

    public void reactivate() {
        if (!this.isActive()) {
            return;
        }
        JTextComponent c = this.textComponent;
        this.deactivate();
        this.activate(c);
    }

    void completionPopupVisible() {
    }

    void completionPopupClosed() {
    }

    private void showCompletions(String requestContent, List<? extends Completion> completions) {
        if (!this.isActive()) {
            return;
        }
        if (completions.size() == 0) {
            this.hidePopups();
            return;
        }
        this.autoActivationTimer.stop();
        this.getComponent().putClientProperty("REQUEST_CONTENT", requestContent);
        boolean keepSelectionIndex = this.displayedCompletions == completions;
        this.displayedCompletions = completions;
        this.setCompletions(completions);
        if (!keepSelectionIndex) {
            this.setCompletionSelectionIndex(-1);
        }
        this.completionView.setVisible(true);
    }

    private void insertCommonPrefix(List<? extends Completion> completions) {
        if (!this.isActive()) {
            return;
        }
        String commonPrefix = CompletionUtils.commonPrefix(completions);
        String content = this.getCurrentContent();
        if (commonPrefix.length() > content.length()) {
            this.setText(this.getComponent(), this.getDocument(), commonPrefix, -1);
        }
    }

    void insertSelectedCompletion() {
        this.cancelBackgroundExecution();
        this.insert(this.getSelection());
    }

    private void insert(Completion completion) {
        if (!this.isActive()) {
            return;
        }
        this.hidePopups();
        String replacementText = Preconditions.checkNotNull(completion.getReplacementText(), "The completion replacement text must not be null.\ncompletion display string=%s\ncompletion=%s", completion.getDisplayString(), completion);
        this.setText(this.getComponent(), this.getDocument(), replacementText, completion.getCaretPosition()).thenRun(() -> this.applyCompletion(completion));
    }

    private void hidePopups() {
        if (!this.isActive()) {
            return;
        }
        this.completionView.setVisible(false);
    }

    boolean hasSelection() {
        return this.getCompletionSelectionIndex() != -1;
    }

    Completion getSelection() {
        int index = this.getCompletionSelectionIndex();
        return index == -1 ? null : this.completionListModel.getElementAt(index);
    }

    int getCompletionSelectionIndex() {
        return this.completionListSelectionModel.getMinSelectionIndex();
    }

    private void setCompletionSelectionIndex(int index) {
        if (index == -1) {
            this.completionListSelectionModel.clearSelection();
        } else {
            this.completionListSelectionModel.setSelectionInterval(index, index);
        }
        this.updateComponentPreview();
    }

    ListModel<? extends Completion> getCompletionListModel() {
        return this.completionListModel;
    }

    private void setCompletions(List<? extends Completion> completions) {
        this.completionListModel.setList(completions);
    }

    ListSelectionModel getCompletionListSelectionModel() {
        return this.completionListSelectionModel;
    }

    static int getMaxVisibleCompletions() {
        return 10;
    }

    JTextComponent getComponent() {
        return this.textComponent;
    }

    private void onDocumentChange(boolean isInsertChange) {
        this.pendingCompletion = null;
        if (!this.isActive()) {
            return;
        }
        this.cancelBackgroundExecution();
        this.autoInsertAllowed = isInsertChange;
        if (!this.isAutoActivationEnabled()) {
            this.autoActivationTimer.stop();
            return;
        }
        if (this.isCompletionPopupVisible()) {
            this.autoActivationTimer.restart();
            return;
        }
        boolean autoActivatable = this.getProcessor().isAutoActivatable(this.getCurrentContent(), this.getCurrentCaretPosition());
        if (autoActivatable) {
            this.autoActivationTimer.restart();
        } else {
            this.autoActivationTimer.stop();
        }
    }

    private void onUserRequest(boolean allowsAutoInsert) {
        if (!this.searchAllowed()) {
            return;
        }
        this.autoActivationTimer.stop();
        this.cancelBackgroundExecution();
        this.updateCompletionsAfterUserRequestWorker = new UpdateCompletionsAfterUserRequestWorker(this, this.getCurrentContent(), this.getCurrentCaretPosition(), allowsAutoInsert);
        this.updateCompletionsAfterUserRequestWorker.execute();
    }

    private void onAutoActivation(ActionEvent evt) {
        if (!this.searchAllowed()) {
            return;
        }
        this.cancelBackgroundExecution();
        this.updateCompletionsAfterAutoActivationWorker = new UpdateCompletionsAfterAutoActivationWorker(this, this.getCurrentContent(), this.getCurrentCaretPosition());
        this.updateCompletionsAfterAutoActivationWorker.execute();
    }

    public void onFocusLost() {
        this.onFocusLost(null);
    }

    private void onFocusLost(FocusEvent evt) {
        this.applyCompletion(this.pendingCompletion);
        this.deactivate();
    }

    private void onCancel() {
        this.cancelBackgroundExecution();
        this.hidePopups();
        this.restoreRequestContent();
    }

    private void updateCompletionsAfterUserRequest(String requestContent, boolean allowsAutoInsert, List<? extends Completion> completions) {
        if (completions == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getComponent());
            this.hidePopups();
        } else if (completions.isEmpty()) {
            this.hidePopups();
        } else if (allowsAutoInsert && this.isFirstAutoInsertable(completions)) {
            this.insert(completions.get(0));
        } else {
            if (this.isPrefixCompletionEnabled() && completions.size() > 1) {
                this.insertCommonPrefix(completions);
            }
            this.showCompletions(requestContent, completions);
        }
    }

    private void updateCompletionsAfterAutoActivation(String requestContent, List<? extends Completion> completions) {
        if (completions == null) {
            this.hidePopups();
        } else if (!(this.isCompletionPopupVisible() && this.autoInsertAllowed && this.isFirstAutoInsertable(completions))) {
            this.showCompletions(requestContent, completions);
        } else {
            this.insert(completions.get(0));
        }
    }

    private void cancelBackgroundExecution() {
        if (this.updateCompletionsAfterAutoActivationWorker != null) {
            this.resetPublishedCompletions();
            this.updateCompletionsAfterAutoActivationWorker.cancel(true);
            this.updateCompletionsAfterAutoActivationWorker = null;
        }
        if (this.updateCompletionsAfterUserRequestWorker != null) {
            this.resetPublishedCompletions();
            this.updateCompletionsAfterUserRequestWorker.cancel(true);
            this.updateCompletionsAfterUserRequestWorker = null;
        }
    }

    private void checkModifiable() {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This CompletionManager is unmodifiable.");
        }
    }

    private Document getDocument() {
        return this.textComponent.getDocument();
    }

    private String getCurrentContent() {
        return this.textComponent.getText();
    }

    private int getCurrentCaretPosition() {
        return this.textComponent.getCaretPosition();
    }

    private boolean isFirstAutoInsertable(List<? extends Completion> completions) {
        return this.isAutoCompletionEnabled() && completions.size() == 1 && completions.get(0).isAutoInsertable();
    }

    private void selectCompletion(int indexDiff, boolean loop) {
        int oldIndex = this.getCompletionSelectionIndex();
        int newIndex = oldIndex + indexDiff;
        int firstIndex = 0;
        int lastIndex = this.getCompletionListModel().getSize() - 1;
        if (newIndex < firstIndex) {
            newIndex = loop ? lastIndex : firstIndex;
        } else if (newIndex > lastIndex) {
            newIndex = loop ? firstIndex : lastIndex;
        }
        this.setCompletionSelectionIndex(newIndex);
    }

    private void updateComponentPreview() {
        if (!this.isActive() || !this.hasSelection()) {
            return;
        }
        Completion selection = this.getSelection();
        this.setText(this.getComponent(), this.getDocument(), selection.getReplacementText(), selection.getCaretPosition());
        this.pendingCompletion = selection;
    }

    private void restoreRequestContent() {
        if (!this.isActive()) {
            return;
        }
        String requestContent = (String)this.getComponent().getClientProperty("REQUEST_CONTENT");
        if (requestContent == null) {
            return;
        }
        this.setText(this.getComponent(), this.getDocument(), requestContent, -1);
        this.pendingCompletion = null;
        CompletionManager.setAccessibleNameSuffix(this.getComponent(), "");
    }

    void resetPublishedCompletions() {
        this.publishedCompletions = new ArrayList<Completion>();
    }

    List<Completion> getPublishedCompletions() {
        return this.publishedCompletions;
    }

    private Promise<Void> setText(JTextComponent component, Document document, String text, int caretPosition) {
        this.autoActivationTimer.stop();
        Promise<Void> promise = Promise.pending();
        EventQueue.invokeLater(() -> {
            if (this.documentHandler != null) {
                document.removeDocumentListener(this.documentHandler);
            }
            CompletionUtils.replaceText(document, text);
            promise.resolve(null);
            if (caretPosition != -1) {
                component.setCaretPosition(caretPosition);
            }
            if (this.documentHandler != null) {
                document.addDocumentListener(this.documentHandler);
            }
        });
        return promise;
    }

    void completionProcessStarted(JTextComponent component) {
        this.fireCompletionProcessStarted(component);
        CompletionManager.setAccessibleNameSuffix(component, "\u2026");
    }

    void processCompletions(JComponent component, String requestContent, List<Completion> chunks) {
        this.publishedCompletions.addAll(chunks);
        int size = this.getPublishedCompletions().size();
        if (size > 1) {
            this.showCompletions(requestContent, this.getPublishedCompletions());
            String suffix = Integer.toString(size) + "\u2026";
            CompletionManager.setAccessibleNameSuffix(component, suffix);
        }
    }

    void completionProcessSucceeded(JTextComponent component, List<? extends Completion> completions) {
        this.fireCompletionProcessSucceeded(component, completions);
        String suffix = completions == null ? CompletionManager.getLocalizedString("Completion.accessibleNameSuffix.notSearched") : (completions.isEmpty() ? CompletionManager.getLocalizedString("Completion.accessibleNameSuffix.noResult") : Integer.toString(completions.size()));
        CompletionManager.setAccessibleNameSuffix(component, suffix);
    }

    void completionProcessCancelled(JTextComponent component) {
        this.fireCompletionProcessCancelled(component);
        CompletionManager.setAccessibleNameSuffix(component, "");
    }

    private static void setAccessibleNameSuffix(JComponent component, String suffix) {
        String key = "OldAccessibleName";
        String oldAccessibleName = (String)component.getClientProperty(key);
        if (oldAccessibleName == null) {
            oldAccessibleName = component.getAccessibleContext().getAccessibleName();
            component.putClientProperty(key, oldAccessibleName);
        }
        String accessibleName = oldAccessibleName;
        if (Strings.isNotBlank(suffix)) {
            accessibleName = accessibleName + ": " + suffix;
        }
        component.getAccessibleContext().setAccessibleName(accessibleName);
    }

    private static String getLocalizedString(String key) {
        return ResourceBundle.getBundle(Accessibility.class.getName()).getString(key);
    }

    private static void onFocusOwnerChanged(PropertyChangeEvent evt) {
        Component focusOwner = (Component)evt.getNewValue();
        if (!(focusOwner instanceof JTextComponent)) {
            return;
        }
        JTextComponent focusedTextComponent = (JTextComponent)focusOwner;
        if (!focusedTextComponent.isEditable()) {
            return;
        }
        CompletionManager manager = CompletionManager.getManager(focusedTextComponent);
        if (manager != null) {
            manager.deactivate();
            manager.activate(focusedTextComponent);
        }
    }

    private void onMouseDoubleClicked(MouseEvent evt) {
        if (this.isDoubleClickActivationEnabled()) {
            this.onUserRequest(false);
        }
    }

    static {
        CTRL_SPACE = KeyStroke.getKeyStroke("ctrl SPACE");
        ENTER = KeyStroke.getKeyStroke("ENTER");
        ESCAPE = KeyStroke.getKeyStroke("ESCAPE");
        UP = KeyStroke.getKeyStroke("UP");
        DOWN = KeyStroke.getKeyStroke("DOWN");
        PAGE_UP = KeyStroke.getKeyStroke("PAGE_UP");
        PAGE_DOWN = KeyStroke.getKeyStroke("PAGE_DOWN");
    }

    static abstract class CompletionProcessorWorker
    extends SwingWorker<Boolean, Completion>
    implements CompletionState {
        protected final CompletionManager manager;
        private final JTextComponent component;
        protected final String content;
        private final int caretPosition;
        private final CompletionPublisher publisher;

        CompletionProcessorWorker(CompletionManager manager, String content, int caretPosition) {
            this.manager = manager;
            this.component = manager.getComponent();
            this.content = content;
            this.caretPosition = caretPosition;
            this.publisher = new Publisher(this);
            manager.resetPublishedCompletions();
            manager.completionProcessStarted(this.component);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            return this.manager.getProcessor().search(this.content, this.caretPosition, this.publisher, this);
        }

        void publishCompletions(Completion ... chunks) {
            if (!this.isCancelled()) {
                this.publish(chunks);
            }
        }

        @Override
        protected void process(List<Completion> chunks) {
            this.manager.processCompletions(this.component, this.content, chunks);
        }

        @Override
        protected final void done() {
            if (!this.isCancelled()) {
                try {
                    List<Completion> result = (Boolean)this.get() != false ? this.manager.getPublishedCompletions() : null;
                    this.manager.completionProcessSucceeded(this.component, result);
                    if (this.manager.getComponent() == this.component) {
                        this.succeeded(result);
                    }
                    return;
                }
                catch (InterruptedException result) {
                }
                catch (ExecutionException e) {
                    this.failed(e.getCause());
                }
            }
            this.manager.completionProcessCancelled(this.component);
        }

        protected abstract void succeeded(List<? extends Completion> var1);

        private void failed(Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to compute completions in the background", throwable);
        }
    }

    private final class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.handleDocumentChangeDelayed(false);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.handleDocumentChangeDelayed(true);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.handleDocumentChangeDelayed(false);
        }

        private void handleDocumentChangeDelayed(boolean insert) {
            EventQueue.invokeLater(() -> CompletionManager.this.onDocumentChange(insert));
        }
    }

    private final class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(evt);
            if (!CompletionManager.this.isCompletionPopupVisible()) {
                if (CompletionManager.this.completionKeyStrokes.contains(keyStroke)) {
                    CompletionManager.this.onUserRequest(true);
                    evt.consume();
                }
                return;
            }
            if (ENTER.equals(keyStroke)) {
                if (CompletionManager.this.hasSelection()) {
                    CompletionManager.this.insertSelectedCompletion();
                    evt.consume();
                }
            } else if (ESCAPE.equals(keyStroke)) {
                CompletionManager.this.onCancel();
                evt.consume();
            } else if (UP.equals(keyStroke)) {
                CompletionManager.this.selectCompletion(-1, false);
                evt.consume();
            } else if (DOWN.equals(keyStroke)) {
                CompletionManager.this.selectCompletion(1, false);
                evt.consume();
            } else if (PAGE_UP.equals(keyStroke)) {
                CompletionManager.this.selectCompletion(-10, false);
                evt.consume();
            } else if (PAGE_DOWN.equals(keyStroke)) {
                CompletionManager.this.selectCompletion(10, false);
                evt.consume();
            }
        }
    }

    private static final class ListListModel<E>
    extends AbstractListModel<E> {
        private List<E> elements = Collections.EMPTY_LIST;

        ListListModel() {
        }

        void setList(List<? extends E> elements) {
            this.elements = Collections.unmodifiableList(elements);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        @Override
        public E getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }
    }

    static final class Publisher
    implements CompletionPublisher {
        private final CompletionProcessorWorker worker;

        Publisher(CompletionProcessorWorker worker) {
            this.worker = worker;
        }

        public void publish(Completion ... chunks) {
            this.worker.publishCompletions(chunks);
        }
    }

    static final class UpdateCompletionsAfterAutoActivationWorker
    extends CompletionProcessorWorker {
        UpdateCompletionsAfterAutoActivationWorker(CompletionManager manager, String content, int caretPosition) {
            super(manager, content, caretPosition);
        }

        @Override
        protected void succeeded(List<? extends Completion> completions) {
            this.manager.updateCompletionsAfterAutoActivation(this.content, completions);
        }
    }

    static final class UpdateCompletionsAfterUserRequestWorker
    extends CompletionProcessorWorker {
        private final boolean allowsAutoInsert;

        UpdateCompletionsAfterUserRequestWorker(CompletionManager manager, String content, int caretPosition, boolean allowsAutoInsert) {
            super(manager, content, caretPosition);
            this.allowsAutoInsert = allowsAutoInsert;
        }

        @Override
        protected void succeeded(List<? extends Completion> completions) {
            this.manager.updateCompletionsAfterUserRequest(this.content, this.allowsAutoInsert, completions);
        }
    }
}

