/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;

final class HierarchicalMutableAttributeContainer
extends AbstractAttributeContainer {
    private final AttributesFactory attributesFactory;
    private final AttributeContainerInternal fallback;
    private final AttributeContainerInternal primary;

    HierarchicalMutableAttributeContainer(AttributesFactory attributesFactory, AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        this.attributesFactory = attributesFactory;
        this.fallback = fallback;
        this.primary = primary;
    }

    public Set<Attribute<?>> keySet() {
        return Sets.union((Set)this.fallback.keySet(), (Set)this.primary.keySet());
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.primary.attribute(key, value);
        return this;
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        this.primary.attributeProvider(key, provider);
        return this;
    }

    public <T> @Nullable T getAttribute(Attribute<T> key) {
        if (!this.isValidAttributeRequest(key)) {
            return null;
        }
        Object attribute = this.primary.getAttribute(key);
        if (attribute != null) {
            return (T)attribute;
        }
        return (T)this.fallback.getAttribute(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        if (this.primary.isEmpty()) {
            return this.fallback.asImmutable();
        }
        if (this.fallback.isEmpty()) {
            return this.primary.asImmutable();
        }
        return this.attributesFactory.concat(this.fallback.asImmutable(), this.primary.asImmutable());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalMutableAttributeContainer that = (HierarchicalMutableAttributeContainer)o;
        return this.fallback.equals(that.fallback) && this.primary.equals(that.primary);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fallback, this.primary);
    }

    public String toString() {
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        this.fallback.keySet().forEach(key -> sorted.put((Attribute)key, this.fallback.getAttribute((Attribute)key)));
        this.primary.keySet().forEach(key -> sorted.put((Attribute)key, this.primary.getAttribute((Attribute)key)));
        return ((Object)sorted).toString();
    }
}

