/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Port;
import guru.nidi.graphviz.model.PortNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class ImmutablePortNode
implements PortNode,
LinkSource,
LinkTarget {
    private final MutableNode node;
    private final Port port;

    ImmutablePortNode(MutableNode node, Port port) {
        this.node = node;
        this.port = port;
    }

    public ImmutablePortNode copy() {
        return new ImmutablePortNode(this.node.copy(), this.port);
    }

    @Override
    public PortNode port(@Nullable String record) {
        return new ImmutablePortNode(this.node, new Port(record, this.port.compass()));
    }

    @Override
    public PortNode port(@Nullable Compass compass) {
        return new ImmutablePortNode(this.node, new Port(this.port.record(), compass));
    }

    @Override
    public PortNode port(@Nullable String record, @Nullable Compass compass) {
        return new ImmutablePortNode(this.node, new Port(record, compass));
    }

    @Override
    public Port port() {
        return this.port;
    }

    @Override
    public List<Link> links() {
        return this.node.links;
    }

    @Override
    public Link linkTo(LinkTarget target) {
        return this.node.linkTo(this.port.isEmpty() ? target : Link.between(this.port, target));
    }

    @Override
    public Link linkTo() {
        return Link.to(this);
    }

    @Override
    public LinkTarget asLinkTarget() {
        return this.node;
    }

    @Override
    public LinkSource asLinkSource() {
        return this.node;
    }

    @Override
    public void addTo(MutableGraph graph) {
        graph.nodes.add(this.node);
    }

    public MutableNode node() {
        return this.node;
    }

    @Override
    public Label name() {
        return this.node.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePortNode that = (ImmutablePortNode)o;
        return Objects.equals(this.node, that.node) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.port);
    }

    public String toString() {
        return this.node.name + this.port.toString();
    }
}

