/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import groovy.transform.NonSealed;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.codehaus.groovy.runtime.ArrayGroovyMethods;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;

public class ClassNodeUtils {
    public static String formatTypeName(ClassNode cNode) {
        if (cNode.isArray()) {
            int dim = 0;
            ClassNode cn = cNode;
            while (cn.isArray()) {
                ++dim;
                cn = cn.getComponentType();
            }
            String sb = ClassNodeUtils.formatTypeName(cn) + "[]".repeat(dim);
            return sb;
        }
        return cNode.isGenericsPlaceHolder() ? cNode.getUnresolvedName() : cNode.getName();
    }

    public static MethodNode addGeneratedMethod(ClassNode cNode, String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        MethodNode result = cNode.getDeclaredMethod(name, parameters);
        if (result == null) {
            result = new MethodNode(name, modifiers, returnType, parameters, exceptions, code);
            ClassNodeUtils.addGeneratedMethod(cNode, result);
        }
        return result;
    }

    public static void addGeneratedMethod(ClassNode cNode, MethodNode mNode) {
        cNode.addMethod(mNode);
        AnnotatedNodeUtils.markAsGenerated(cNode, mNode);
    }

    public static void addGeneratedMethod(ClassNode cNode, MethodNode mNode, boolean skipChecks) {
        cNode.addMethod(mNode);
        AnnotatedNodeUtils.markAsGenerated(cNode, mNode, skipChecks);
    }

    public static void addGeneratedInnerClass(ClassNode cNode, ClassNode inner) {
        cNode.getModule().addClass(inner);
        AnnotatedNodeUtils.markAsGenerated(cNode, inner);
    }

    public static ConstructorNode addGeneratedConstructor(ClassNode classNode, int modifiers, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        ConstructorNode ctorNode = new ConstructorNode(modifiers, parameters, exceptions, code);
        ClassNodeUtils.addGeneratedConstructor(classNode, ctorNode);
        return ctorNode;
    }

    public static void addGeneratedConstructor(ClassNode classNode, ConstructorNode ctorNode) {
        classNode.addConstructor(ctorNode);
        AnnotatedNodeUtils.markAsGenerated(classNode, ctorNode);
    }

    public static Map<String, MethodNode> getDeclaredMethodsFromSuper(ClassNode cNode) {
        ClassNode parent = cNode.getSuperClass();
        if (parent == null) {
            return new LinkedHashMap<String, MethodNode>();
        }
        return parent.getDeclaredMethodsMap();
    }

    public static void addDeclaredMethodsFromInterfaces(ClassNode cNode, Map<String, MethodNode> methodsMap) {
        for (ClassNode iface : cNode.getInterfaces()) {
            Map<String, MethodNode> declaredMethods = iface.getDeclaredMethodsMap();
            for (Map.Entry<String, MethodNode> entry : declaredMethods.entrySet()) {
                MethodNode mNode = entry.getValue();
                if (!mNode.getDeclaringClass().isInterface()) continue;
                if (mNode.isAbstract()) {
                    methodsMap.putIfAbsent(entry.getKey(), mNode);
                    continue;
                }
                if (!mNode.isPublic() || mNode.isStatic() || (mNode = methodsMap.put(entry.getKey(), mNode)) == null || mNode.isAbstract() && mNode.getDeclaringClass().isInterface()) continue;
                methodsMap.put(entry.getKey(), mNode);
            }
        }
    }

    public static Map<String, MethodNode> getDeclaredMethodsFromInterfaces(ClassNode cNode) {
        LinkedHashMap<String, MethodNode> methodsMap = new LinkedHashMap<String, MethodNode>();
        ClassNodeUtils.addDeclaredMethodsFromInterfaces(cNode, methodsMap);
        return methodsMap;
    }

    public static void addDeclaredMethodsFromAllInterfaces(ClassNode cNode, Map<String, MethodNode> methodsMap) {
        List<ClassNode> cnInterfaces = Arrays.asList(cNode.getInterfaces());
        for (ClassNode sc = cNode.getSuperClass(); sc != null && !ClassHelper.isObjectType(sc); sc = sc.getSuperClass()) {
            for (ClassNode i : sc.getInterfaces()) {
                if (cnInterfaces.contains(i)) continue;
                methodsMap.putAll(i.getDeclaredMethodsMap());
            }
        }
    }

    public static boolean hasPossibleStaticMethod(ClassNode cNode, String name, Expression arguments, boolean trySpread) {
        int count = 0;
        boolean foundSpread = false;
        if (arguments instanceof TupleExpression) {
            for (Expression arg : (TupleExpression)arguments) {
                if (arg instanceof SpreadExpression) {
                    foundSpread = true;
                    continue;
                }
                ++count;
            }
        } else if (arguments instanceof MapExpression) {
            count = 1;
        }
        for (MethodNode method : cNode.getMethods(name)) {
            if (!method.isStatic()) continue;
            Parameter[] parameters = method.getParameters();
            if (trySpread && foundSpread && parameters.length >= count) {
                return true;
            }
            if (parameters.length == count) {
                return true;
            }
            if (parameters.length > 0 && parameters[parameters.length - 1].getType().isArray()) {
                if (count >= parameters.length - 1) {
                    return true;
                }
                if (trySpread && foundSpread) {
                    return true;
                }
            }
            int nonDefaultParameters = 0;
            for (Parameter parameter : parameters) {
                if (parameter.hasInitialExpression()) continue;
                ++nonDefaultParameters;
            }
            if (count >= parameters.length || nonDefaultParameters > count) continue;
            return true;
        }
        if (cNode.isPrimaryClassNode()) {
            for (PropertyNode pNode : cNode.getProperties()) {
                if (pNode.getGetterNameOrDefault().equals(name)) {
                    return pNode.isStatic() && !ClassNodeUtils.isPackagePrivate(pNode);
                }
                if (!pNode.getSetterNameOrDefault().equals(name)) continue;
                return pNode.isStatic() && !pNode.isFinal() && !ClassNodeUtils.isPackagePrivate(pNode);
            }
        }
        return false;
    }

    public static boolean hasPossibleStaticProperty(ClassNode cNode, String methodName) {
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        String propName = ClassNodeUtils.getPropNameForAccessor(methodName);
        PropertyNode pNode = ClassNodeUtils.getStaticProperty(cNode, propName);
        return pNode != null && (methodName.startsWith("get") || ClassHelper.isPrimitiveBoolean(pNode.getType()));
    }

    public static String getPropNameForAccessor(String accessorName) {
        if (!ClassNodeUtils.isValidAccessorName(accessorName)) {
            return accessorName;
        }
        int prefixLength = accessorName.startsWith("is") ? 2 : 3;
        return String.valueOf(accessorName.charAt(prefixLength)).toLowerCase() + accessorName.substring(prefixLength + 1);
    }

    public static boolean isValidAccessorName(String accessorName) {
        if (accessorName.startsWith("get") || accessorName.startsWith("is") || accessorName.startsWith("set")) {
            int prefixLength = accessorName.startsWith("is") ? 2 : 3;
            return accessorName.length() > prefixLength;
        }
        return false;
    }

    public static boolean isNonSealed(ClassNode cn) {
        ClassNode sc;
        if (cn.isArray() || ClassHelper.isPrimitiveType(cn)) {
            return false;
        }
        if (cn.isPrimaryClassNode()) {
            if (Boolean.TRUE.equals(cn.getNodeMetaData(NonSealed.class))) {
                return true;
            }
        } else {
            try {
                Class tc = cn.getTypeClass();
                return ReflectionUtils.isSealed(tc.getSuperclass()) && !Modifier.isFinal(tc.getModifiers()) && !ReflectionUtils.isSealed(tc);
            }
            catch (AssertionError | LinkageError tc) {
                // empty catch block
            }
        }
        return (sc = cn.getSuperClass()) != null && sc.isSealed() && !Modifier.isFinal(cn.getModifiers()) && !cn.isSealed();
    }

    public static boolean hasStaticProperty(ClassNode cNode, String propName) {
        String otherName;
        PropertyNode found = ClassNodeUtils.getStaticProperty(cNode, propName);
        if (found == null && !(otherName = BeanUtils.decapitalize(propName)).equals(propName)) {
            found = ClassNodeUtils.getStaticProperty(cNode, otherName);
        }
        return found != null;
    }

    public static PropertyNode getStaticProperty(ClassNode cNode, String propName) {
        for (ClassNode classNode = cNode; classNode != null; classNode = classNode.getSuperClass()) {
            for (PropertyNode pn : classNode.getProperties()) {
                if (!pn.getName().equals(propName) || !pn.isStatic() || ClassNodeUtils.isPackagePrivate(pn)) continue;
                return pn;
            }
        }
        return null;
    }

    public static ClassNode getNestHost(ClassNode cNode) {
        while (cNode.getOuterClass() != null) {
            cNode = cNode.getOuterClass();
        }
        return cNode;
    }

    public static boolean isInnerClass(ClassNode cNode) {
        return cNode.getOuterClass() != null && !Modifier.isStatic(cNode.getModifiers());
    }

    public static boolean isCompatibleWith(ClassNode source, ClassNode target) {
        if (source.equals(target)) {
            return true;
        }
        if (source.isArray() && target.isArray() && ArrayTypeUtils.dimension(source) == ArrayTypeUtils.dimension(target)) {
            source = ArrayTypeUtils.elementType(source);
            target = ArrayTypeUtils.elementType(target);
        }
        return !ClassHelper.isPrimitiveType(source) && !ClassHelper.isPrimitiveType(target) && (source.isDerivedFrom(target) || source.implementsInterface(target));
    }

    public static boolean hasNoArgConstructor(ClassNode cNode) {
        List<ConstructorNode> constructors = cNode.getDeclaredConstructors();
        for (ConstructorNode ctor : constructors) {
            if (ctor.getParameters().length != 0 && (!ctor.hasDefaultValue() || !Arrays.stream(ctor.getParameters()).allMatch(Parameter::hasInitialExpression))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExplicitConstructor(AbstractASTTransformation xform, ClassNode cNode) {
        List<ConstructorNode> declaredConstructors = cNode.getDeclaredConstructors();
        for (ConstructorNode constructorNode : declaredConstructors) {
            if (AnnotatedNodeUtils.isGenerated(constructorNode)) continue;
            if (xform != null) {
                xform.addError("Error during " + xform.getAnnotationName() + " processing. Explicit constructors not allowed for class: " + cNode.getNameWithoutPackage(), constructorNode);
            }
            return true;
        }
        return false;
    }

    public static boolean samePackageName(ClassNode first, ClassNode second) {
        return Objects.equals(first.getPackageName(), second.getPackageName());
    }

    public static FieldNode getField(ClassNode classNode, String fieldName) {
        return ClassNodeUtils.getField(classNode, fieldName, fieldNode -> true);
    }

    public static FieldNode getField(ClassNode classNode, String fieldName, Predicate<? super FieldNode> acceptability) {
        ClassNode next;
        ArrayDeque<ClassNode> todo = new ArrayDeque<ClassNode>(Collections.singletonList(classNode));
        HashSet<ClassNode> done = new HashSet<ClassNode>();
        while ((next = (ClassNode)todo.poll()) != null) {
            if (!done.add(next)) continue;
            FieldNode fieldNode = next.getDeclaredField(fieldName);
            if (fieldNode != null && acceptability.test(fieldNode)) {
                if (fieldNode.isPrivate() && ClassNodeUtils.isPackagePrivate(fieldNode)) {
                    fieldNode.setModifiers(fieldNode.getModifiers() & 0xFFFFFFFD);
                }
                return fieldNode;
            }
            Collections.addAll(todo, next.getInterfaces());
            ClassNode superType = next.getSuperClass();
            if (superType == null) continue;
            todo.add(superType);
        }
        return null;
    }

    public static MethodNode getMethod(ClassNode classNode, String methodName, Predicate<? super MethodNode> acceptability) {
        for (ClassNode next = classNode; next != null; next = next.getSuperClass()) {
            for (MethodNode methodNode : next.getDeclaredMethods(methodName)) {
                if (!acceptability.test(methodNode)) continue;
                return methodNode;
            }
        }
        if (classNode.isAbstract() && ArrayGroovyMethods.asBoolean(classNode.getInterfaces())) {
            ClassNode next;
            ArrayDeque<ClassNode> todo = new ArrayDeque<ClassNode>(Arrays.asList(classNode.getInterfaces()));
            HashSet<ClassNode> done = new HashSet<ClassNode>();
            done.add(classNode);
            while ((next = (ClassNode)todo.poll()) != null) {
                if (!done.add(next)) continue;
                for (MethodNode methodNode : next.getDeclaredMethods(methodName)) {
                    if (!acceptability.test(methodNode)) continue;
                    return methodNode;
                }
                Collections.addAll(todo, next.getInterfaces());
            }
        }
        return null;
    }

    public static boolean isSubtype(ClassNode maybeExtendedOrImplemented, ClassNode cNode) {
        return maybeExtendedOrImplemented.isInterface() || cNode.isInterface() ? GeneralUtils.isOrImplements(cNode, maybeExtendedOrImplemented) : cNode.isDerivedFrom(maybeExtendedOrImplemented);
    }

    private static boolean isPackagePrivate(AnnotatedNode aNode) {
        return aNode.getAnnotations().stream().anyMatch(anno -> "groovy.transform.PackageScope".equals(anno.getClassNode().getName())) || aNode.getDeclaringClass().getAnnotations().stream().anyMatch(anno -> "groovy.transform.PackageScope".equals(anno.getClassNode().getName()) && Optional.ofNullable(anno.getMember("value")).filter(expr -> expr.getText().contains("FIELDS")).isPresent());
    }

    private ClassNodeUtils() {
    }
}

