/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Array;
import dafny.DafnySequence;
import dafny.NonLazyDafnySequence;
import dafny.TypeDescriptor;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

final class ArrayDafnySequence<T>
extends NonLazyDafnySequence<T> {
    private final Array<T> seq;
    private boolean unsafe;

    ArrayDafnySequence(TypeDescriptor<T> elementType, Object elements, boolean unsafe) {
        this(Array.wrap(elementType, elements), unsafe);
    }

    ArrayDafnySequence(TypeDescriptor<T> elementType, Object elements) {
        this(Array.wrap(elementType, elements));
    }

    ArrayDafnySequence(Array<T> elements, boolean unsafe) {
        this.seq = elements;
        this.unsafe = unsafe;
    }

    ArrayDafnySequence(Array<T> array) {
        this(array, false);
    }

    Array<T> unwrap() {
        return this.seq;
    }

    @Override
    public Array<T> toArray() {
        return this.seq.copy();
    }

    public static <T> ArrayDafnySequence<T> empty(TypeDescriptor<T> type) {
        return new ArrayDafnySequence<T>(type, type.newArray(0));
    }

    @Override
    public TypeDescriptor<T> elementType() {
        return this.seq.elementType();
    }

    @Override
    public <R> ArrayDafnySequence<R> update(int i, R t) {
        assert (t != null) : "Precondition Violation";
        assert (0 <= i && i < this.length()) : "Precondition Violation";
        Array<R> newArray = this.seq.copy();
        newArray.set(i, t);
        return new ArrayDafnySequence<T>(newArray);
    }

    @Override
    public ArrayDafnySequence<T> subsequence(int lo, int hi) {
        assert (lo >= 0 && hi >= 0 && hi >= lo) : "Precondition Violation";
        return new ArrayDafnySequence<T>(this.seq.copyOfRange(lo, hi));
    }

    @Override
    DafnySequence.Copier<T> newCopier(final int length) {
        return new DafnySequence.Copier<T>(){
            private final Array<T> newArray;
            private int nextIndex;
            {
                this.newArray = Array.newArray(ArrayDafnySequence.this.seq.elementType(), length);
                this.nextIndex = 0;
            }

            @Override
            public void copyFrom(DafnySequence<T> source) {
                if ((source = source.force()) instanceof ArrayDafnySequence) {
                    Array sourceArray = ((ArrayDafnySequence)source).seq;
                    sourceArray.copy(0, this.newArray, this.nextIndex, sourceArray.length());
                    this.nextIndex += sourceArray.length();
                } else {
                    for (Object t : source) {
                        this.newArray.set(this.nextIndex++, t);
                    }
                }
            }

            @Override
            public NonLazyDafnySequence<T> result() {
                return new ArrayDafnySequence(this.newArray);
            }
        };
    }

    @Override
    protected List<T> asList() {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ArrayDafnySequence.this.seq.get(index);
            }

            @Override
            public T set(int index, T element) {
                Object prev = ArrayDafnySequence.this.seq.get(index);
                ArrayDafnySequence.this.seq.set(index, element);
                return prev;
            }

            @Override
            public int size() {
                return ArrayDafnySequence.this.length();
            }
        };
    }

    @Override
    public T select(int i) {
        return this.seq.get(i);
    }

    @Override
    public int length() {
        return this.seq.length();
    }

    @Override
    public Iterator<T> iterator() {
        return this.asList().iterator();
    }

    @Override
    protected boolean equalsNonLazy(NonLazyDafnySequence<T> other) {
        if (other instanceof ArrayDafnySequence) {
            return this.seq.shallowEquals(((ArrayDafnySequence)other).seq);
        }
        return super.equalsNonLazy(other);
    }

    @Override
    public int hashCode() {
        return this.asList().hashCode();
    }

    @Override
    public String verbatimString() {
        if (this.elementType() == TypeDescriptor.UNICODE_CHAR) {
            return new String((int[])this.seq.unwrap(), 0, this.seq.length());
        }
        return new String((char[])this.seq.unwrap());
    }
}

