/******************************************************************************
 *{@C
 *      Copyright:      2009-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgGA.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module osgGA.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgGAHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgGA;

%}

%ignore osgGA::CameraManipulator::setCoordinateFrameCallback;
%ignore osgGA::CameraManipulator::getCoordinateFrameCallback;
%ignore osgGA::EventVisitor::setEvents;
%ignore osgGA::EventVisitor::getEvents;

%include osgGA/EventQueue
%include osgGA/EventVisitor
%include osgGA/EventHandler

%include osgGA/GUIActionAdapter
%include osgGA/GUIEventAdapter
%include osgGA/GUIEventHandler

// CameraManipulator must be included first because of containing the
// base class for all other manipulators.
%include osgGA/CameraManipulator

// Classes dependent on CameraManipulator
%include osgGA/AnimationPathManipulator
%include osgGA/CameraViewSwitchManipulator
%include osgGA/DriveManipulator
%include osgGA/KeySwitchMatrixManipulator
%include osgGA/SphericalManipulator
%include osgGA/StandardManipulator
%include osgGA/UFOManipulator

// Classes dependent on StandardManipulator
%include osgGA/FirstPersonManipulator
%include osgGA/OrbitManipulator

// Classes dependent on OrbitManipulator
%include osgGA/NodeTrackerManipulator
%include osgGA/TerrainManipulator
%include osgGA/TrackballManipulator

// Classes dependent on FirstPersonManipulator
%include osgGA/FlightManipulator

// Classes dependent on TrackballManipulator
%include osgGA/MultiTouchTrackballManipulator

%include osgGA/StateSetManipulator

%include osgGA/Version
