/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdmonitionNodeFormatter
implements NodeFormatter {
    private final AdmonitionOptions options;

    public AdmonitionNodeFormatter(DataHolder options) {
        this.options = new AdmonitionOptions(options);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Collections.singletonList(new NodeFormattingHandler(AdmonitionBlock.class, this::render)));
    }

    private void render(AdmonitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        ((MarkdownWriter)markdown.append((CharSequence)node.getOpeningMarker())).append(' ');
        markdown.appendNonTranslating((CharSequence)node.getInfo());
        if (node.getTitle().isNotNull()) {
            ((MarkdownWriter)((MarkdownWriter)markdown.append(' ')).append('\"')).appendTranslating((CharSequence)node.getTitle()).append('\"');
        }
        markdown.line();
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)RepeatedSequence.repeatOf((CharSequence)" ", (int)this.options.contentIndent).toString());
        context.renderChildren((Node)node);
        markdown.blankLine();
        markdown.popPrefix();
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new AdmonitionNodeFormatter(options);
        }
    }
}

