/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitReportWriter {
    private JUnitReportWriter() {
    }

    public static void writeReport(Task task, String suiteName, File reportFile, Map<String, String> pseudoTests) throws BuildException {
        if (reportFile == null) {
            StringBuilder errors = new StringBuilder();
            for (Map.Entry<String, String> entry : pseudoTests.entrySet()) {
                String msg = entry.getValue();
                if (msg == null) continue;
                errors.append("\n" + entry.getKey() + ": " + msg);
            }
            if (errors.length() > 0) {
                throw new BuildException("Some tests failed:" + errors, task.getLocation());
            }
            task.log("All tests passed");
        } else {
            Document reportDoc = XMLUtil.createDocument("testsuite");
            Element testsuite = reportDoc.getDocumentElement();
            int failures = 0;
            testsuite.setAttribute("errors", "0");
            testsuite.setAttribute("time", "0.0");
            String name = suiteName != null ? suiteName : task.getClass().getName();
            testsuite.setAttribute("name", name);
            for (Map.Entry<String, String> entry : pseudoTests.entrySet()) {
                Element testcase = reportDoc.createElement("testcase");
                testsuite.appendChild(testcase);
                testcase.setAttribute("classname", name);
                testcase.setAttribute("name", entry.getKey());
                testcase.setAttribute("time", "0.0");
                String msg = entry.getValue();
                if (msg == null) continue;
                ++failures;
                Element failure = reportDoc.createElement("failure");
                testcase.appendChild(failure);
                failure.setAttribute("type", "junit.framework.AssertionFailedError");
                failure.setAttribute("message", msg.replaceFirst("(?s)\n.*", ""));
                failure.appendChild(reportDoc.createTextNode(msg));
            }
            testsuite.setAttribute("failures", Integer.toString(failures));
            testsuite.setAttribute("tests", Integer.toString(pseudoTests.size()));
            try (FileOutputStream os = new FileOutputStream(reportFile);){
                XMLUtil.write(reportDoc, (OutputStream)os);
            }
            catch (IOException x) {
                throw new BuildException("Could not write " + reportFile + ": " + x, (Throwable)x, task.getLocation());
            }
            task.log(reportFile + ": " + failures + " failures out of " + pseudoTests.size() + " tests");
        }
    }
}

